/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.world;

import com.plotsquared.core.location.BlockLoc;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.world.SinglePlotArea;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;

public class SinglePlot
extends Plot {
    private final Set<CuboidRegion> regions = Collections.singleton(new CuboidRegion(BlockVector3.at((int)Integer.MIN_VALUE, (int)Integer.MIN_VALUE, (int)Integer.MIN_VALUE), BlockVector3.at((int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE)));

    public SinglePlot(@NonNull PlotArea area, @NonNull PlotId id) {
        super(area, id);
    }

    public SinglePlot(PlotId id, UUID owner, HashSet<UUID> trusted, HashSet<UUID> members, HashSet<UUID> denied, String alias, BlockLoc position, Collection<PlotFlag<?, ?>> flags, PlotArea area, boolean[] merged, long timestamp, int temp) {
        super(id, owner, trusted, members, denied, alias, position, flags, area, merged, timestamp, temp);
    }

    @Override
    public String getWorldName() {
        return this.getId().toUnderscoreSeparatedString();
    }

    @Override
    public SinglePlotArea getArea() {
        return (SinglePlotArea)super.getArea();
    }

    @Override
    public void getSide(Consumer<Location> result) {
        this.getCenter(result);
    }

    @Override
    public boolean isLoaded() {
        this.getArea().loadWorld(this.getId());
        return super.isLoaded();
    }

    @Override
    public @NonNull Set<CuboidRegion> getRegions() {
        return this.regions;
    }
}

