/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.flag.types;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.plotsquared.core.configuration.Settings;
import com.sk89q.worldedit.registry.Keyed;
import com.sk89q.worldedit.world.block.BlockCategory;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BlockTypeWrapper {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + BlockTypeWrapper.class.getSimpleName()));
    private static final Map<BlockType, BlockTypeWrapper> blockTypes = new HashMap<BlockType, BlockTypeWrapper>();
    private static final Map<String, BlockTypeWrapper> blockCategories = new HashMap<String, BlockTypeWrapper>();
    private static final String minecraftNamespace = "minecraft";
    private final @Nullable BlockType blockType;
    private final @Nullable String blockCategoryId;
    private @Nullable BlockCategory blockCategory;

    private BlockTypeWrapper(@NonNull BlockType blockType) {
        this.blockType = (BlockType)Preconditions.checkNotNull((Object)blockType);
        this.blockCategory = null;
        this.blockCategoryId = null;
    }

    private BlockTypeWrapper(@NonNull BlockCategory blockCategory) {
        this.blockType = null;
        this.blockCategory = (BlockCategory)Preconditions.checkNotNull((Object)blockCategory);
        this.blockCategoryId = blockCategory.getId();
    }

    private BlockTypeWrapper(@NonNull String blockCategoryId) {
        this.blockType = null;
        this.blockCategory = null;
        this.blockCategoryId = (String)Preconditions.checkNotNull((Object)blockCategoryId);
    }

    public static BlockTypeWrapper get(BlockType blockType) {
        return blockTypes.computeIfAbsent(blockType, BlockTypeWrapper::new);
    }

    public static BlockTypeWrapper get(BlockCategory blockCategory) {
        return blockCategories.computeIfAbsent(blockCategory.getId(), id -> new BlockTypeWrapper(blockCategory));
    }

    public static BlockTypeWrapper get(String blockCategoryId) {
        Object id = blockCategoryId.indexOf(58) == -1 ? "minecraft:" + blockCategoryId : blockCategoryId;
        return blockCategories.computeIfAbsent((String)id, BlockTypeWrapper::new);
    }

    public String toString() {
        if (this.blockType != null) {
            String key = this.blockType.toString();
            if (key.startsWith("minecraft:")) {
                return key.substring(10);
            }
            return key;
        }
        if (this.blockCategoryId != null) {
            String key = this.blockCategoryId;
            if (key.startsWith("minecraft:")) {
                return "#" + key.substring(10);
            }
            return "#" + key;
        }
        return null;
    }

    public boolean accepts(BlockType blockType) {
        if (this.getBlockType() != null) {
            return this.getBlockType().equals((Object)blockType);
        }
        if (this.getBlockCategory() != null) {
            return this.getBlockCategory().contains((Keyed)blockType);
        }
        return false;
    }

    public @Nullable BlockCategory getBlockCategory() {
        if (this.blockCategory == null && this.blockCategoryId != null) {
            this.blockCategory = (BlockCategory)BlockCategory.REGISTRY.get(this.blockCategoryId);
            if (this.blockCategory == null && !BlockCategory.REGISTRY.values().isEmpty()) {
                if (Settings.DEBUG) {
                    LOGGER.info("- Block category #{} does not exist", (Object)this.blockCategoryId);
                }
                this.blockCategory = new NullBlockCategory(this.blockCategoryId);
            }
        }
        return this.blockCategory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockTypeWrapper that = (BlockTypeWrapper)o;
        return Objects.equal((Object)this.blockType, (Object)that.blockType) && Objects.equal((Object)this.blockCategoryId, (Object)that.blockCategoryId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.blockType, this.blockCategoryId});
    }

    public @Nullable BlockType getBlockType() {
        return this.blockType;
    }

    private static class NullBlockCategory
    extends BlockCategory {
        public NullBlockCategory(String id) {
            super(id);
        }

        public <B extends BlockStateHolder<B>> boolean contains(B blockStateHolder) {
            return false;
        }
    }
}

