/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.flag.implementations;

import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.plot.flag.FlagParseException;
import com.plotsquared.core.plot.flag.PlotFlag;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TitlesFlag
extends PlotFlag<TitlesFlagValue, TitlesFlag> {
    public static final TitlesFlag TITLES_NONE = new TitlesFlag(TitlesFlagValue.NONE);
    public static final TitlesFlag TITLES_TRUE = new TitlesFlag(TitlesFlagValue.TRUE);
    public static final TitlesFlag TITLES_FALSE = new TitlesFlag(TitlesFlagValue.FALSE);

    private TitlesFlag(TitlesFlagValue value) {
        super(value, TranslatableCaption.of("flags.flag_category_enum"), TranslatableCaption.of("flags.flag_description_titles"));
    }

    @Override
    public TitlesFlag parse(@NonNull String input) throws FlagParseException {
        TitlesFlagValue titlesFlagValue = TitlesFlagValue.fromString(input);
        if (titlesFlagValue == null) {
            throw new FlagParseException(this, input, TranslatableCaption.of("flags.flag_error_enum"), new TagResolver[]{TagResolver.resolver((String)"list", (Tag)Tag.inserting((Component)Component.text((String)"none, true, false")))});
        }
        return this.flagOf(titlesFlagValue);
    }

    @Override
    public TitlesFlag merge(@NonNull TitlesFlagValue newValue) {
        if (newValue == TitlesFlagValue.TRUE || newValue == TitlesFlagValue.FALSE) {
            return this.flagOf(newValue);
        }
        return this;
    }

    @Override
    public String toString() {
        return ((TitlesFlagValue)((Object)this.getValue())).name().toLowerCase(Locale.ENGLISH);
    }

    @Override
    public String getExample() {
        return "true";
    }

    @Override
    protected TitlesFlag flagOf(@NonNull TitlesFlagValue value) {
        if (value == TitlesFlagValue.TRUE) {
            return TITLES_TRUE;
        }
        if (value == TitlesFlagValue.FALSE) {
            return TITLES_FALSE;
        }
        return TITLES_NONE;
    }

    @Override
    public Collection<String> getTabCompletions() {
        return Arrays.asList("none", "true", "false");
    }

    public static enum TitlesFlagValue {
        NONE,
        TRUE,
        FALSE;


        public static @Nullable TitlesFlagValue fromString(String value) {
            if (value.equalsIgnoreCase("true")) {
                return TRUE;
            }
            if (value.equalsIgnoreCase("false")) {
                return FALSE;
            }
            if (value.equalsIgnoreCase("none")) {
                return NONE;
            }
            return null;
        }
    }
}

