/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot;

import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum PlotAreaType {
    NORMAL(TranslatableCaption.of("plotareatype.plot_area_type_normal")),
    AUGMENTED(TranslatableCaption.of("plotareatype.plot_area_type_augmented")),
    PARTIAL(TranslatableCaption.of("plotareatype.plot_area_type_partial"));

    private static final Map<String, PlotAreaType> types;
    private final Caption description;

    private PlotAreaType(Caption description) {
        this.description = description;
    }

    public static Map<PlotAreaType, Caption> getDescriptionMap() {
        return Stream.of(PlotAreaType.values()).collect(Collectors.toMap(e -> e, PlotAreaType::getDescription));
    }

    public static Optional<PlotAreaType> fromString(String typeName) {
        return Optional.ofNullable(types.get(typeName.toLowerCase()));
    }

    @Deprecated
    public static Optional<PlotAreaType> fromLegacyInt(int typeId) {
        if (typeId < 0 || typeId >= PlotAreaType.values().length) {
            return Optional.empty();
        }
        return Optional.of(PlotAreaType.values()[typeId]);
    }

    public Caption getDescription() {
        return this.description;
    }

    static {
        types = Stream.of(PlotAreaType.values()).collect(Collectors.toMap(e -> e.toString().toLowerCase(), Function.identity()));
    }
}

