/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum PlotAreaTerrainType {
    NONE,
    ORE,
    ROAD,
    ALL;

    private static final Map<String, PlotAreaTerrainType> types;

    public static Optional<PlotAreaTerrainType> fromString(String typeString) {
        return Optional.ofNullable(types.get(typeString.toLowerCase()));
    }

    @Deprecated
    public static Optional<PlotAreaTerrainType> fromLegacyInt(int typeId) {
        if (typeId < 0 || typeId >= PlotAreaTerrainType.values().length) {
            return Optional.empty();
        }
        return Optional.of(PlotAreaTerrainType.values()[typeId]);
    }

    static {
        types = Stream.of(PlotAreaTerrainType.values()).collect(Collectors.toMap(e -> e.toString().toLowerCase(), Function.identity()));
    }
}

