/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.generator;

import com.plotsquared.core.generator.GridPlotManager;
import com.plotsquared.core.generator.SquarePlotWorld;
import com.plotsquared.core.location.Direction;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.util.HashUtil;
import com.plotsquared.core.util.RegionManager;
import com.sk89q.worldedit.regions.CuboidRegion;
import java.util.Iterator;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class SquarePlotManager
extends GridPlotManager {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + SquarePlotManager.class.getSimpleName()));
    private final SquarePlotWorld squarePlotWorld;
    private final RegionManager regionManager;

    public SquarePlotManager(@NonNull SquarePlotWorld squarePlotWorld, @NonNull RegionManager regionManager) {
        super(squarePlotWorld);
        this.squarePlotWorld = squarePlotWorld;
        this.regionManager = regionManager;
    }

    @Override
    public boolean clearPlot(final @NonNull Plot plot, final @Nullable Runnable whenDone, @Nullable PlotPlayer<?> actor, @Nullable QueueCoordinator queue) {
        final Set<CuboidRegion> regions = plot.getRegions();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                if (regions.isEmpty()) {
                    if (whenDone != null) {
                        whenDone.run();
                    }
                    return;
                }
                Iterator iterator = regions.iterator();
                CuboidRegion region = (CuboidRegion)iterator.next();
                iterator.remove();
                Location pos1 = Location.at(plot.getWorldName(), region.getMinimumPoint());
                Location pos2 = Location.at(plot.getWorldName(), region.getMaximumPoint());
                SquarePlotManager.this.regionManager.regenerateRegion(pos1, pos2, false, this);
            }
        };
        run.run();
        return true;
    }

    @Override
    public Location getPlotTopLocAbs(@NonNull PlotId plotId) {
        int px = plotId.getX();
        int pz = plotId.getY();
        int x = this.squarePlotWorld.ROAD_OFFSET_X + px * (this.squarePlotWorld.ROAD_WIDTH + this.squarePlotWorld.PLOT_WIDTH) - (int)Math.floor(this.squarePlotWorld.ROAD_WIDTH / 2) - 1;
        int z = this.squarePlotWorld.ROAD_OFFSET_Z + pz * (this.squarePlotWorld.ROAD_WIDTH + this.squarePlotWorld.PLOT_WIDTH) - (int)Math.floor(this.squarePlotWorld.ROAD_WIDTH / 2) - 1;
        return Location.at(this.squarePlotWorld.getWorldName(), x, this.squarePlotWorld.getMaxGenHeight(), z);
    }

    @Override
    public PlotId getPlotIdAbs(int x, int y, int z) {
        int end;
        int pathWidthLower;
        if (this.squarePlotWorld.ROAD_OFFSET_X != 0) {
            x -= this.squarePlotWorld.ROAD_OFFSET_X;
        }
        if (this.squarePlotWorld.ROAD_OFFSET_Z != 0) {
            z -= this.squarePlotWorld.ROAD_OFFSET_Z;
        }
        if (this.squarePlotWorld.ROAD_WIDTH == 0) {
            pathWidthLower = -1;
            end = this.squarePlotWorld.PLOT_WIDTH;
        } else {
            pathWidthLower = this.squarePlotWorld.ROAD_WIDTH % 2 == 0 ? this.squarePlotWorld.ROAD_WIDTH / 2 - 1 : this.squarePlotWorld.ROAD_WIDTH / 2;
            end = pathWidthLower + this.squarePlotWorld.PLOT_WIDTH;
        }
        int size = this.squarePlotWorld.PLOT_WIDTH + this.squarePlotWorld.ROAD_WIDTH;
        int dx = Math.floorDiv(x, size) + 1;
        int rx = Math.floorMod(x, size);
        int dz = Math.floorDiv(z, size) + 1;
        int rz = Math.floorMod(z, size);
        if (rz <= pathWidthLower || rz > end || rx <= pathWidthLower || rx > end) {
            return null;
        }
        return PlotId.of(dx, dz);
    }

    public PlotId getNearestPlotId(@NonNull PlotArea plotArea, int x, int y, int z) {
        SquarePlotWorld dpw = (SquarePlotWorld)plotArea;
        if (dpw.ROAD_OFFSET_X != 0) {
            x -= dpw.ROAD_OFFSET_X;
        }
        if (dpw.ROAD_OFFSET_Z != 0) {
            z -= dpw.ROAD_OFFSET_Z;
        }
        int size = dpw.PLOT_WIDTH + dpw.ROAD_WIDTH;
        int idx = x < 0 ? x / size : x / size + 1;
        int idz = z < 0 ? z / size : z / size + 1;
        return PlotId.of(idx, idz);
    }

    @Override
    public PlotId getPlotId(int x, int y, int z) {
        try {
            int end;
            int pathWidthLower;
            x -= this.squarePlotWorld.ROAD_OFFSET_X;
            z -= this.squarePlotWorld.ROAD_OFFSET_Z;
            int size = this.squarePlotWorld.PLOT_WIDTH + this.squarePlotWorld.ROAD_WIDTH;
            if (this.squarePlotWorld.ROAD_WIDTH == 0) {
                pathWidthLower = -1;
                end = this.squarePlotWorld.PLOT_WIDTH;
            } else {
                pathWidthLower = this.squarePlotWorld.ROAD_WIDTH % 2 == 0 ? this.squarePlotWorld.ROAD_WIDTH / 2 - 1 : this.squarePlotWorld.ROAD_WIDTH / 2;
                end = pathWidthLower + this.squarePlotWorld.PLOT_WIDTH;
            }
            int dx = Math.floorDiv(x, size) + 1;
            int rx = Math.floorMod(x, size);
            int dz = Math.floorDiv(z, size) + 1;
            int rz = Math.floorMod(z, size);
            PlotId id = PlotId.of(dx, dz);
            boolean[] merged = new boolean[]{rz <= pathWidthLower, rx > end, rz > end, rx <= pathWidthLower};
            int hash = HashUtil.hash(merged);
            if (hash == 0) {
                return id;
            }
            Plot plot = this.squarePlotWorld.getOwnedPlotAbs(id);
            if (plot == null) {
                return null;
            }
            switch (hash) {
                case 8: {
                    return plot.isMerged(Direction.NORTH) ? id : null;
                }
                case 4: {
                    return plot.isMerged(Direction.EAST) ? id : null;
                }
                case 2: {
                    return plot.isMerged(Direction.SOUTH) ? id : null;
                }
                case 1: {
                    return plot.isMerged(Direction.WEST) ? id : null;
                }
                case 12: {
                    return plot.isMerged(Direction.NORTHEAST) ? id : null;
                }
                case 6: {
                    return plot.isMerged(Direction.SOUTHEAST) ? id : null;
                }
                case 3: {
                    return plot.isMerged(Direction.SOUTHWEST) ? id : null;
                }
                case 9: {
                    return plot.isMerged(Direction.NORTHWEST) ? id : null;
                }
            }
        }
        catch (Exception ignored) {
            LOGGER.error("Invalid plot / road width in settings.yml for world: {}", (Object)this.squarePlotWorld.getWorldName());
        }
        return null;
    }

    @Override
    public Location getPlotBottomLocAbs(@NonNull PlotId plotId) {
        int px = plotId.getX();
        int pz = plotId.getY();
        int x = this.squarePlotWorld.ROAD_OFFSET_X + px * (this.squarePlotWorld.ROAD_WIDTH + this.squarePlotWorld.PLOT_WIDTH) - this.squarePlotWorld.PLOT_WIDTH - (int)Math.floor(this.squarePlotWorld.ROAD_WIDTH / 2);
        int z = this.squarePlotWorld.ROAD_OFFSET_Z + pz * (this.squarePlotWorld.ROAD_WIDTH + this.squarePlotWorld.PLOT_WIDTH) - this.squarePlotWorld.PLOT_WIDTH - (int)Math.floor(this.squarePlotWorld.ROAD_WIDTH / 2);
        return Location.at(this.squarePlotWorld.getWorldName(), x, this.squarePlotWorld.getMinGenHeight(), z);
    }
}

