/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.configuration.file;

import com.plotsquared.core.configuration.Configuration;
import com.plotsquared.core.configuration.InvalidConfigurationException;
import com.plotsquared.core.configuration.MemoryConfiguration;
import com.plotsquared.core.configuration.file.FileConfigurationOptions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;

public abstract class FileConfiguration
extends MemoryConfiguration {
    FileConfiguration() {
    }

    public FileConfiguration(Configuration defaults) {
        super(defaults);
    }

    public void save(File file) throws IOException {
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        String data = this.saveToString();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            writer.write(data);
        }
    }

    public abstract String saveToString();

    public void load(File file) throws IOException, InvalidConfigurationException {
        try (FileInputStream stream = new FileInputStream(file);){
            this.load(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8));
        }
    }

    public void load(Reader reader) throws IOException, InvalidConfigurationException {
        String builder;
        try (BufferedReader input = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);){
            builder = input.lines().map(line -> line + "\n").collect(Collectors.joining());
        }
        this.loadFromString(builder);
    }

    public abstract void loadFromString(String var1) throws InvalidConfigurationException;

    protected abstract String buildHeader();

    @Override
    public FileConfigurationOptions options() {
        if (this.options == null) {
            this.options = new FileConfigurationOptions(this);
        }
        return (FileConfigurationOptions)this.options;
    }
}

