/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.command.Argument;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.PlayerManager;
import com.plotsquared.core.util.TabCompletions;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="remove", aliases={"r", "untrust", "ut", "undeny", "unban", "ud", "pardon"}, usage="/plot remove <player | *>", category=CommandCategory.SETTINGS, requiredType=RequiredType.NONE, permission="plots.remove")
public class Remove
extends SubCommand {
    private final EventDispatcher eventDispatcher;

    @Inject
    public Remove(@NonNull EventDispatcher eventDispatcher) {
        super(Argument.PlayerName);
        this.eventDispatcher = eventDispatcher;
    }

    @Override
    public boolean onCommand(PlotPlayer<?> player, String[] args) {
        Location location = player.getLocation();
        Plot plot = location.getPlotAbs();
        if (plot == null) {
            player.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return false;
        }
        if (!plot.hasOwner()) {
            player.sendMessage((Caption)TranslatableCaption.of("info.plot_unowned"), new TagResolver[0]);
            return false;
        }
        if (!plot.isOwner(player.getUUID()) && !player.hasPermission(Permission.PERMISSION_ADMIN_COMMAND_REMOVE)) {
            player.sendMessage((Caption)TranslatableCaption.of("permission.no_plot_perms"), new TagResolver[0]);
            return true;
        }
        PlayerManager.getUUIDsFromString(args[0], (uuids, throwable) -> {
            int count = 0;
            if (throwable instanceof TimeoutException) {
                player.sendMessage((Caption)TranslatableCaption.of("players.fetching_players_timeout"), new TagResolver[0]);
                return;
            }
            if (throwable != null) {
                player.sendMessage((Caption)TranslatableCaption.of("errors.invalid_player"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)args[0])))});
                return;
            }
            if (!uuids.isEmpty()) {
                for (UUID uuid : uuids) {
                    if (plot.getTrusted().contains(uuid)) {
                        if (!plot.removeTrusted(uuid)) continue;
                        this.eventDispatcher.callTrusted(player, plot, uuid, false);
                        ++count;
                        continue;
                    }
                    if (plot.getMembers().contains(uuid)) {
                        if (!plot.removeMember(uuid)) continue;
                        this.eventDispatcher.callMember(player, plot, uuid, false);
                        ++count;
                        continue;
                    }
                    if (plot.getDenied().contains(uuid)) {
                        if (!plot.removeDenied(uuid)) continue;
                        this.eventDispatcher.callDenied(player, plot, uuid, false);
                        ++count;
                        continue;
                    }
                    if (uuid != DBFunc.EVERYONE) continue;
                    count += plot.getTrusted().size();
                    if (plot.removeTrusted(uuid)) {
                        this.eventDispatcher.callTrusted(player, plot, uuid, false);
                    }
                    count += plot.getMembers().size();
                    if (plot.removeMember(uuid)) {
                        this.eventDispatcher.callMember(player, plot, uuid, false);
                    }
                    count += plot.getDenied().size();
                    if (!plot.removeDenied(uuid)) continue;
                    this.eventDispatcher.callDenied(player, plot, uuid, false);
                }
            }
            if (count == 0) {
                player.sendMessage((Caption)TranslatableCaption.of("errors.invalid_player"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)args[0])))});
            } else {
                player.sendMessage((Caption)TranslatableCaption.of("member.removed_players"), new TagResolver[]{TagResolver.resolver((String)"amount", (Tag)Tag.inserting((Component)Component.text((int)count)))});
            }
        });
        return true;
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> player, String[] args, boolean space) {
        Location location = player.getLocation();
        Plot plot = location.getPlotAbs();
        if (plot == null) {
            return Collections.emptyList();
        }
        return TabCompletions.completeAddedPlayers(player, plot, String.join((CharSequence)",", args).trim(), Collections.singletonList(player.getName()));
    }
}

