/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.backup;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.plotsquared.core.backup.Backup;
import com.plotsquared.core.backup.BackupManager;
import com.plotsquared.core.backup.BackupProfile;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.ConsolePlayer;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.schematic.Schematic;
import com.plotsquared.core.util.SchematicHandler;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.core.util.task.TaskManager;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PlayerBackupProfile
implements BackupProfile {
    static final MiniMessage MINI_MESSAGE = MiniMessage.builder().build();
    private final UUID owner;
    private final Plot plot;
    private final BackupManager backupManager;
    private final SchematicHandler schematicHandler;
    private final Object backupLock = new Object();
    private volatile List<Backup> backupCache;

    @Inject
    public PlayerBackupProfile(@Assisted @NonNull UUID owner, @Assisted @NonNull Plot plot, @NonNull BackupManager backupManager, @NonNull SchematicHandler schematicHandler) {
        this.owner = owner;
        this.plot = plot;
        this.backupManager = backupManager;
        this.schematicHandler = schematicHandler;
    }

    private static boolean isValidFile(@NonNull Path path) {
        String name = path.getFileName().toString();
        return name.endsWith(".schem") || name.endsWith(".schematic");
    }

    private static Path resolve(@NonNull Path parent, String child) {
        Path path = parent;
        try {
            if (!Files.exists(parent, new LinkOption[0])) {
                Files.createDirectory(parent, new FileAttribute[0]);
            }
            if (!Files.exists(path = parent.resolve(child), new LinkOption[0])) {
                Files.createDirectory(path, new FileAttribute[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull CompletableFuture<List<Backup>> listBackups() {
        Object object = this.backupLock;
        synchronized (object) {
            if (this.backupCache != null) {
                return CompletableFuture.completedFuture(this.backupCache);
            }
            return CompletableFuture.supplyAsync(() -> {
                Path path = this.getBackupDirectory();
                if (!Files.exists(path, new LinkOption[0])) {
                    try {
                        Files.createDirectories(path, new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return Collections.emptyList();
                    }
                }
                ArrayList<Backup> backups = new ArrayList<Backup>();
                try {
                    Files.walk(path, new FileVisitOption[0]).filter(PlayerBackupProfile::isValidFile).forEach(file -> {
                        try {
                            BasicFileAttributes basicFileAttributes = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
                            backups.add(new Backup(this, basicFileAttributes.creationTime().toMillis(), (Path)file));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                backups.sort(Comparator.comparingLong(Backup::getCreationTime).reversed());
                this.backupCache = backups;
                return this.backupCache;
            });
        }
    }

    @Override
    public void destroy() {
        this.listBackups().whenCompleteAsync((backups, error) -> {
            if (error != null) {
                error.printStackTrace();
            }
            backups.forEach(Backup::delete);
            this.backupCache = null;
        });
    }

    @Override
    public @NonNull Path getBackupDirectory() {
        return PlayerBackupProfile.resolve(PlayerBackupProfile.resolve(PlayerBackupProfile.resolve(this.backupManager.getBackupPath(), Objects.requireNonNull(this.plot.getArea().toString(), "plot area id")), Objects.requireNonNull(this.plot.getId().toDashSeparatedString(), "plot id")), Objects.requireNonNull(this.owner.toString(), "owner"));
    }

    @Override
    public @NonNull CompletableFuture<Backup> createBackup() {
        CompletableFuture<Backup> future = new CompletableFuture<Backup>();
        this.listBackups().thenAcceptAsync(backups -> {
            Object object = this.backupLock;
            synchronized (object) {
                List<Plot> plots;
                boolean result;
                if (backups.size() == this.backupManager.getBackupLimit()) {
                    ((Backup)backups.get(backups.size() - 1)).delete();
                }
                if (!(result = this.schematicHandler.exportAll(plots = Collections.singletonList(this.plot), this.getBackupDirectory().toFile(), "%world%-%id%-" + System.currentTimeMillis(), () -> future.complete(new Backup(this, System.currentTimeMillis(), null))))) {
                    future.completeExceptionally(new RuntimeException("Failed to complete the backup"));
                }
                this.backupCache = null;
            }
        });
        return future;
    }

    @Override
    public @NonNull CompletableFuture<Void> restoreBackup(@NonNull Backup backup, @Nullable PlotPlayer<?> player) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (backup.getFile() == null || !Files.exists(backup.getFile(), new LinkOption[0])) {
            future.completeExceptionally(new IllegalArgumentException("The specific backup does not exist"));
        } else {
            TaskManager.runTaskAsync(() -> {
                Schematic schematic = null;
                try {
                    schematic = this.schematicHandler.getSchematic(backup.getFile().toFile());
                }
                catch (SchematicHandler.UnsupportedFormatException e) {
                    e.printStackTrace();
                }
                if (schematic == null) {
                    future.completeExceptionally(new IllegalArgumentException("The backup is non-existent or not in the correct format"));
                } else {
                    this.schematicHandler.paste(schematic, this.plot, 0, this.plot.getArea().getMinBuildHeight(), 0, false, player, new RunnableVal<Boolean>(){

                        @Override
                        public void run(Boolean value) {
                            if (value.booleanValue()) {
                                future.complete(null);
                            } else {
                                future.completeExceptionally(new RuntimeException(MINI_MESSAGE.escapeTags(TranslatableCaption.of("schematics.schematic_paste_failed").getComponent(ConsolePlayer.getConsole()))));
                            }
                        }
                    });
                }
            });
        }
        return future;
    }
}

