/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.backup;

import com.google.inject.Singleton;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.backup.BackupManager;
import com.plotsquared.core.backup.BackupProfile;
import com.plotsquared.core.backup.NullBackupProfile;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import java.nio.file.Path;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Singleton
public class NullBackupManager
implements BackupManager {
    @Override
    public @NonNull BackupProfile getProfile(@NonNull Plot plot) {
        return new NullBackupProfile();
    }

    @Override
    public void automaticBackup(@Nullable PlotPlayer<?> plotPlayer, @NonNull Plot plot, @NonNull Runnable whenDone) {
        whenDone.run();
    }

    @Override
    public @NonNull Path getBackupPath() {
        return Objects.requireNonNull(PlotSquared.platform()).getDirectory().toPath();
    }

    @Override
    public int getBackupLimit() {
        return 0;
    }

    @Override
    public boolean shouldAutomaticallyBackup() {
        return false;
    }
}

