/*
 * Decompiled with CFR 0.152.
 */
package com.intele.chimera.client.impl;

import com.intele.chimera.client.GatewayClient;
import com.intele.chimera.client.request.GatewayRequest;
import com.intele.chimera.gw.xsd.smsgateway.request._2013._02.Request;
import com.intele.chimera.gw.xsd.smsgateway.response._2013._02.Response;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;

public class GatewayClientImpl
implements GatewayClient {
    private final Client client;
    private final String target;
    private final MediaType mediaType;

    public GatewayClientImpl(Client client, String target, MediaType mediaType) {
        this.client = client;
        this.target = target;
        this.mediaType = mediaType;
    }

    @Override
    public Response send(GatewayRequest gatewayRequest) {
        Request request = gatewayRequest.getRequest();
        return this.send(request);
    }

    @Override
    public Response send(Request request) {
        Entity entity;
        WebTarget webTarget = this.client.target(this.target);
        if (this.mediaType.equals((Object)MediaType.APPLICATION_XML_TYPE)) {
            entity = Entity.xml((Object)request);
        } else if (this.mediaType.equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
            entity = Entity.json((Object)request);
        } else {
            throw new IllegalStateException("Mediatype " + this.mediaType + " is not supported.");
        }
        Invocation buildPost = webTarget.request().accept(new MediaType[]{this.mediaType}).buildPost(entity);
        return (Response)buildPost.invoke(Response.class);
    }

    @Override
    public void close() {
        this.client.close();
    }
}

