/*
 * Decompiled with CFR 0.152.
 */
package com.instapp.nat.permission;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.support.annotation.NonNull;
import com.instapp.nat.permission.ModuleResultListener;
import java.util.HashMap;

public class PermissionChecker {
    public static boolean lacksPermissions(Context context, String ... permissions) {
        if (Build.VERSION.SDK_INT < 23) {
            return false;
        }
        for (String permission : permissions) {
            if (!PermissionChecker.lacksPermission(context, permission)) continue;
            return true;
        }
        return false;
    }

    public static boolean lacksPermission(Context context, String permission) {
        if (Build.VERSION.SDK_INT < 23) {
            return false;
        }
        return context.checkSelfPermission(permission) == -1;
    }

    public static boolean hasAllPermissionsGranted(@NonNull int[] grantResults) {
        for (int grantResult : grantResults) {
            if (grantResult != -1) continue;
            return false;
        }
        return true;
    }

    public static void requestPermissions(final Activity activity, HashMap<String, String> dialogParams, final ModuleResultListener listener, final int requestCode, final String ... permissions) {
        if (PermissionChecker.shouldShowRequestPermissionsRationale(activity, permissions)) {
            AlertDialog dialog = new AlertDialog.Builder((Context)activity).setTitle((CharSequence)dialogParams.get("title")).setMessage((CharSequence)dialogParams.get("message")).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int i) {
                    listener.onResult(true);
                }
            }).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int i) {
                    PermissionChecker.requestPermissionInner(activity, requestCode, permissions);
                }
            }).create();
            dialog.setCanceledOnTouchOutside(false);
            dialog.show();
        } else {
            PermissionChecker.requestPermissionInner(activity, requestCode, permissions);
        }
    }

    public static void requestPermissionInner(Activity context, int requestCode, String ... permissions) {
        if (Build.VERSION.SDK_INT >= 23) {
            context.requestPermissions(permissions, requestCode);
        }
    }

    public static boolean shouldShowRequestPermissionsRationale(Activity activity, String ... permissions) {
        if (Build.VERSION.SDK_INT < 23) {
            return false;
        }
        for (String permission : permissions) {
            if (!activity.shouldShowRequestPermissionRationale(permission)) continue;
            return true;
        }
        return false;
    }

    public static boolean shouldShowRequestPermissionRationale(Activity activity, String permission) {
        if (Build.VERSION.SDK_INT < 23) {
            return false;
        }
        return activity.shouldShowRequestPermissionRationale(permission);
    }
}

