/*
 * Decompiled with CFR 0.152.
 */
package com.instapp.nat.media.image;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.ExifInterface;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import com.instapp.nat.media.image.ImagePreviewActivity;
import com.instapp.nat.media.image.MessageEvent;
import com.instapp.nat.media.image.ModuleResultListener;
import com.instapp.nat.media.image.Util;
import com.instapp.nat.media.image.multi_image_selector.MultiImageSelector;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class ImageModule {
    public static final String PREVIEW = "image_preview";
    public ModuleResultListener mPreviewListener;
    private static volatile ImageModule instance = null;
    private Context mContext;

    private ImageModule(Context context) {
        this.mContext = context;
        EventBus.getDefault().register((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImageModule getInstance(Context context) {
        if (instance != null) return instance;
        Class<ImageModule> clazz = ImageModule.class;
        synchronized (ImageModule.class) {
            if (instance != null) return instance;
            instance = new ImageModule(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void pick(Activity activity, HashMap<String, Object> param) {
        int limit = 9;
        boolean showCamera = false;
        if (param.containsKey("limit")) {
            limit = (Integer)param.get("limit");
            int n = limit = limit < 1 ? 1 : limit;
        }
        if (param.containsKey("showCamera")) {
            showCamera = (Boolean)param.get("showCamera");
        }
        MultiImageSelector selector = MultiImageSelector.create((Context)activity);
        selector.showCamera(showCamera);
        selector.count(limit);
        if (limit == 1) {
            selector.single();
        } else {
            selector.multi();
        }
        selector.start(activity, 1003);
    }

    public Object onPickActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1003) {
            if (resultCode == 0) {
                return null;
            }
            if (resultCode != -1) {
                return Util.getError("MEDIA_ABORTED", 110090);
            }
            ArrayList path = data.getStringArrayListExtra("select_result");
            HashMap<String, ArrayList> result = new HashMap<String, ArrayList>();
            result.put("paths", path);
            return result;
        }
        return null;
    }

    public void preview(String[] files, HashMap<String, Object> param, ModuleResultListener listener) {
        this.mPreviewListener = listener;
        int currentIndex = 0;
        String style2 = "dots";
        if (param.containsKey("current")) {
            currentIndex = (Integer)param.get("current");
        }
        if (param.containsKey("style")) {
            style2 = (String)param.get("style");
        }
        Intent intent = new Intent(this.mContext, ImagePreviewActivity.class);
        intent.putExtra("paths", files);
        intent.putExtra("style", style2);
        intent.putExtra("current", currentIndex);
        this.mContext.startActivity(intent);
        listener.onResult(null);
    }

    public void info(String path, final ModuleResultListener listener) {
        if (path.startsWith("http://") || path.startsWith("https://")) {
            OkHttpClient okHttpClient = new OkHttpClient();
            Request request = new Request.Builder().url(path).build();
            okHttpClient.newCall(request).enqueue(new Callback(){

                public void onResponse(Response response) throws IOException {
                    InputStream is = response.body().byteStream();
                    HashMap<String, Object> result = new HashMap<String, Object>();
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
                    if (bitmap == null) {
                        listener.onResult(Util.getError("MEDIA_SRC_NOT_SUPPORTED", 110120));
                        return;
                    }
                    String outMimeType = options.outMimeType;
                    String type = ImageModule.this.getImageType(outMimeType);
                    if (type.equals("unknow")) {
                        result.put("type", type);
                        listener.onResult(result);
                    }
                    int outHeight = options.outHeight;
                    int outWidth = options.outWidth;
                    result.put("width", outWidth);
                    result.put("height", outHeight);
                    result.put("type", type);
                    listener.onResult(result);
                }

                public void onFailure(Request request, IOException e) {
                    listener.onResult(Util.getError("MEDIA_NETWORK_ERROR", 110090));
                }
            });
        } else {
            HashMap<String, Object> result = new HashMap<String, Object>();
            BitmapFactory.Options options = new BitmapFactory.Options();
            Bitmap bitmap = null;
            boolean isSampleSize = false;
            try {
                bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
            }
            catch (OutOfMemoryError error) {
                error.printStackTrace();
                options.inSampleSize = 2;
                isSampleSize = true;
                bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
            }
            if (bitmap == null) {
                listener.onResult(Util.getError("MEDIA_SRC_NOT_SUPPORTED", 110120));
                return;
            }
            String outMimeType = options.outMimeType;
            String type = this.getImageType(outMimeType);
            if (type.equals("unknow")) {
                result.put("type", type);
                listener.onResult(result);
            }
            int outHeight = isSampleSize ? options.outHeight * 2 : options.outHeight;
            int outWidth = isSampleSize ? options.outWidth * 2 : options.outWidth;
            result.put("width", outWidth);
            result.put("height", outHeight);
            result.put("type", type);
            listener.onResult(result);
        }
    }

    public void exif(String path, final ModuleResultListener listener) {
        if (path.startsWith("http://") || path.startsWith("https://")) {
            OkHttpClient okHttpClient = new OkHttpClient();
            Request request = new Request.Builder().url(path).build();
            okHttpClient.newCall(request).enqueue(new Callback(){

                public void onResponse(Response response) {
                    try {
                        InputStream is = response.body().byteStream();
                        String str_time = new Date().getTime() + "";
                        File file = new File(Environment.getExternalStorageDirectory().getAbsolutePath() + "/" + str_time + ".jpg");
                        if (!file.exists()) {
                            file.createNewFile();
                        }
                        FileOutputStream fos = new FileOutputStream(file);
                        byte[] buffer = new byte[1024];
                        int len = 0;
                        while ((len = is.read(buffer)) != -1) {
                            fos.write(buffer, 0, len);
                        }
                        fos.flush();
                        is.close();
                        fos.close();
                        ImageModule.this.getPictureExif(file.getAbsolutePath(), listener);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        listener.onResult(Util.getError("MEDIA_NETWORK_ERROR", 110050));
                    }
                }

                public void onFailure(Request request, IOException e) {
                    listener.onResult(Util.getError("MEDIA_NETWORK_ERROR", 110050));
                }
            });
        } else {
            this.getPictureExif(path, listener);
        }
    }

    private void getPictureExif(String path, ModuleResultListener listener) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            ExifInterface exifInterface = new ExifInterface(path);
            String[] tags_str = new String[]{"GPSLatitudeRef", "GPSLongitudeRef", "GPSProcessingMethod", "ImageWidth", "ImageLength", "Make", "Model"};
            String[] tags_double = new String[]{"FNumber", "Flash", "FocalLength", "GPSAltitude", "GPSAltitudeRef", "GPSLongitude", "GPSLatitude", "ImageLength", "ImageWidth", "ISOSpeedRatings", "Orientation", "WhiteBalance", "ExposureTime"};
            HashMap<String, Object> exif_str = this.getExif_str(exifInterface, tags_str);
            result.putAll(exif_str);
            HashMap<String, Object> exif_double = this.getExif_double(exifInterface, tags_double);
            result.putAll(exif_double);
            if (Build.VERSION.SDK_INT == 23) {
                String[] tags_23 = new String[]{"DateTimeDigitized", "SubSecTime", "SubSecTimeDigitized", "SubSecTimeOriginal"};
                HashMap<String, Object> exif23 = this.getExif_str(exifInterface, tags_23);
                result.putAll(exif23);
            }
            if (Build.VERSION.SDK_INT > 23) {
                String[] tags_24_str = new String[]{"Artist", "CFAPattern", "ComponentsConfiguration", "Copyright", "DateTimeOriginal", "DeviceSettingDescription", "ExifVersion", "FileSource", "FlashpixVersion", "GPSAreaInformation", "GPSDestBearingRef", "GPSDestDistanceRef", "GPSDestLatitudeRef", "GPSDestLongitudeRef", "GPSDOP", "GPSImgDirection", "GPSImgDirectionRef", "GPSMapDatum", "GPSMeasureMode", "GPSSatellites", "GPSSpeedRef", "GPSStatus", "GPSTrackRef", "GPSVersionID", "ImageDescription", "ImageUniqueID", "InteroperabilityIndex", "MakerNote", "OECF", "RelatedSoundFile", "SceneType", "Software", "SpatialFrequencyResponse", "SpectralSensitivity", "SubSecTimeDigitized", "SubSecTimeOriginal", "UserComment"};
                String[] tags24_double = new String[]{"ApertureValue", "BitsPerSample", "BrightnessValue", "ColorSpace", "CompressedBitsPerPixel", "Compression", "Contrast", "CustomRendered", "DigitalZoomRatio", "ExposureBiasValue", "ExposureIndex", "ExposureMode", "ExposureProgram", "FlashEnergy", "FocalLengthIn35mmFilm", "FocalPlaneResolutionUnit", "FocalPlaneXResolution", "FocalPlaneYResolution", "FNumber", "GainControl", "GPSDestBearing", "GPSDestDistance", "GPSDestLatitude", "GPSDestLongitude", "GPSDifferential", "GPSSpeed", "GPSTrack", "ISOSpeedRatings", "JPEGInterchangeFormat", "JPEGInterchangeFormatLength", "LightSource", "MaxApertureValue", "MeteringMode", "PhotometricInterpretation", "PixelXDimension", "PixelYDimension", "PlanarConfiguration", "PrimaryChromaticities", "ReferenceBlackWhite", "ResolutionUnit", "RowsPerStrip", "SamplesPerPixel", "Saturation", "SceneCaptureType", "SensingMethod", "Sharpness", "ShutterSpeedValue", "StripByteCounts", "StripOffsets", "SubjectArea", "SubjectDistance", "SubjectDistanceRange", "SubjectLocation", "ThumbnailImageLength", "ThumbnailImageWidth", "TransferFunction", "WhitePoint", "XResolution", "YCbCrCoefficients", "YCbCrPositioning", "YCbCrSubSampling", "YResolution"};
                HashMap<String, Object> exif24_str = this.getExif_str(exifInterface, tags_24_str);
                result.putAll(exif24_str);
                HashMap<String, Object> exif24_double = this.getExif_double(exifInterface, tags24_double);
                result.putAll(exif24_double);
            }
            String TAG_DATETIME = exifInterface.getAttribute("DateTime");
            String TAG_GPS_TIMESTAMP = exifInterface.getAttribute("GPSTimeStamp");
            long dateTime = this.formatTime(TAG_DATETIME, "yy:mm:dd hh:mm:ss");
            long gpsDateTime = this.formatTime(TAG_GPS_TIMESTAMP, "hh:mm:ss");
            if (dateTime != 0L) {
                result.put("DateTime", dateTime);
            }
            if (gpsDateTime != 0L) {
                result.put("GPSTimeStamp", TAG_GPS_TIMESTAMP);
            }
            listener.onResult(result);
        }
        catch (IOException e) {
            e.printStackTrace();
            listener.onResult(Util.getError("MEDIA_SRC_NOT_SUPPORTED", 110120));
        }
    }

    public String getImageType(String mimeType) {
        if (mimeType == null || !mimeType.startsWith("image")) {
            return "unknow";
        }
        if (mimeType.contains("png")) {
            return "png";
        }
        if (mimeType.contains("jpeg")) {
            return "jpeg";
        }
        if (mimeType.contains("webp")) {
            return "webp";
        }
        if (mimeType.contains("gif")) {
            return "gif";
        }
        if (mimeType.contains("bmp")) {
            return "bmp";
        }
        if (mimeType.contains("ico")) {
            return "ico";
        }
        return "unknow";
    }

    public HashMap<String, Object> getExif_str(ExifInterface exifInterface, String[] tags) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String tag : tags) {
            String attribute = exifInterface.getAttribute(tag);
            if (TextUtils.isEmpty((CharSequence)attribute)) continue;
            result.put(tag, attribute);
        }
        return result;
    }

    public HashMap<String, Object> getExif_double(ExifInterface exifInterface, String[] tags) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String tag : tags) {
            double attribute = exifInterface.getAttributeDouble(tag, 0.0);
            if (attribute == 0.0) continue;
            result.put(tag, attribute);
        }
        return result;
    }

    public long formatTime(String date_str, String format_str) {
        if (date_str == null) {
            return 0L;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format_str);
            Date parse = null;
            parse = simpleDateFormat.parse(date_str);
            return parse.getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    @Subscribe
    public void onMessageEvent(MessageEvent messageEvent) {
        if (messageEvent.mType.equals(PREVIEW) && this.mPreviewListener != null) {
            this.mPreviewListener.onResult(Util.getError(messageEvent.mMsg, 1));
        }
    }
}

