/*
 * Decompiled with CFR 0.152.
 */
package com.instapp.nat.media_image.zoomimageview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import java.util.ArrayList;
import java.util.List;

public class ZoomImageView
extends ImageView
implements ViewTreeObserver.OnGlobalLayoutListener,
View.OnTouchListener,
ScaleGestureDetector.OnScaleGestureListener {
    private static final String TAG = "ZoomImageView";
    private boolean isInit;
    private Matrix mMatrix = new Matrix();
    private float mMinScale;
    private float mMidScale;
    private float mMaxScale;
    private ScaleGestureDetector mScaleGestureDetector;
    private int mLastPointereCount;
    private float mLastX;
    private float mLastY;
    private int mTouchSlop;
    private boolean isCanDrag;
    private boolean isCheckLeftAndRight;
    private boolean isCheckTopAndBottom;
    private GestureDetector mGestureDetector;
    private boolean isScaleing;
    private List<MotionEvent> events;
    private View.OnClickListener onClickListener;
    private int arae_img_id = -1;
    private static boolean IS_DEBUG = false;

    public ZoomImageView(Context context) {
        this(context, null);
    }

    public ZoomImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ZoomImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mScaleGestureDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)this);
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onDoubleTap(MotionEvent e) {
                if (ZoomImageView.this.isScaleing || ZoomImageView.this.getScale() >= ZoomImageView.this.mMaxScale) {
                    return true;
                }
                ZoomImageView.this.isScaleing = true;
                float x = e.getX();
                float y = e.getY();
                if (ZoomImageView.this.getScale() < ZoomImageView.this.mMidScale) {
                    ZoomImageView.this.postDelayed(new AutoScaleRunnable(ZoomImageView.this.mMidScale, x, y), 16L);
                } else {
                    ZoomImageView.this.postDelayed(new AutoScaleRunnable(ZoomImageView.this.mMinScale, x, y), 16L);
                }
                return true;
            }

            public boolean onSingleTapConfirmed(MotionEvent e) {
                if (ZoomImageView.this.onClickListener != null) {
                    ZoomImageView.this.onClickListener.onClick((View)ZoomImageView.this);
                    return true;
                }
                return false;
            }
        });
        this.setOnTouchListener(this);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.events = new ArrayList<MotionEvent>();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        ZoomImageView.log("\u6ce8\u518c\u4e86OnGlobalLayoutListener");
        this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    @SuppressLint(value={"NewApi"})
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        ZoomImageView.log("\u53cd\u6ce8\u518c\u4e86OnGlobalLayoutListener");
        this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    public void onGlobalLayout() {
        if (this.arae_img_id != -1) {
            this.arae_img_id = -1;
            return;
        }
        this.setScaleType(ImageView.ScaleType.MATRIX);
        ZoomImageView.log("\u6267\u884c\u4e86onGlobalLayout| NULL:" + (this.getDrawable() == null));
        if (this.getDrawable() == null || this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        if (!this.isInit) {
            ZoomImageView.log("\u521d\u59cb\u5316\u5b8c\u6bd5");
            int width = this.getWidth();
            int height = this.getHeight();
            float screenWeight = (float)height * 1.0f / (float)width;
            int imageH = this.getDrawable().getIntrinsicHeight();
            int imageW = this.getDrawable().getIntrinsicWidth();
            float imageWeight = (float)imageH * 1.0f / (float)imageW;
            if (screenWeight >= imageWeight) {
                float scale = 1.0f;
                if (imageW > width && imageH < height) {
                    scale = (float)width * 1.0f / (float)imageW;
                }
                if (imageH > height && imageW < width) {
                    scale = (float)height * 1.0f / (float)imageH;
                }
                if (imageH > height && imageW > width) {
                    scale = Math.min((float)width * 1.0f / (float)imageW, (float)height * 1.0f / (float)imageH);
                    ZoomImageView.log("max scale:" + scale);
                }
                if (imageH < height && imageW < width) {
                    scale = Math.min((float)width * 1.0f / (float)imageW, (float)height * 1.0f / (float)imageH);
                    ZoomImageView.log("min scale:" + scale);
                }
                this.mMinScale = scale;
                this.mMidScale = this.mMinScale * 2.0f;
                this.mMaxScale = this.mMinScale * 4.0f;
                int dx = this.getWidth() / 2 - imageW / 2;
                int dy = this.getHeight() / 2 - imageH / 2;
                this.mMatrix.postTranslate((float)dx, (float)dy);
                this.mMatrix.postScale(this.mMinScale, this.mMinScale, (float)(width / 2), (float)(height / 2));
            } else {
                float scale;
                this.mMaxScale = scale = (float)width * 1.0f / (float)imageW;
                this.mMidScale = this.mMaxScale / 2.0f;
                this.mMinScale = this.mMaxScale / 4.0f;
                this.mMatrix.postScale(this.mMaxScale, this.mMaxScale, 0.0f, 0.0f);
            }
            this.setImageMatrix(this.mMatrix);
            this.isInit = true;
        }
    }

    public static void log(String value) {
        if (IS_DEBUG) {
            Log.w((String)TAG, (String)value);
        }
    }

    public void reSetState() {
        this.isInit = false;
        this.setTag(null);
        this.mMatrix.reset();
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        if (this.mGestureDetector.onTouchEvent(motionEvent)) {
            return true;
        }
        if (motionEvent.getPointerCount() > 1) {
            this.mScaleGestureDetector.onTouchEvent(motionEvent);
        }
        float x = 0.0f;
        float y = 0.0f;
        int pointerCount = motionEvent.getPointerCount();
        for (int i = 0; i < pointerCount; ++i) {
            x += motionEvent.getX(i);
            y += motionEvent.getY(i);
        }
        x /= (float)pointerCount;
        y /= (float)pointerCount;
        if (this.mLastPointereCount != pointerCount) {
            this.isCanDrag = false;
            this.mLastX = x;
            this.mLastY = y;
        }
        this.mLastPointereCount = pointerCount;
        switch (motionEvent.getAction()) {
            case 0: {
                RectF rectF = this.getMatrixRectF();
                if (!(rectF.width() > (float)this.getWidth() + 0.01f) && !(rectF.height() > (float)this.getHeight() + 0.01f) || rectF.right == (float)this.getWidth() || rectF.left == 0.0f) break;
                try {
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                }
                catch (Exception e) {
                    ZoomImageView.log(e.toString());
                }
                break;
            }
            case 2: {
                float dx = x - this.mLastX;
                float dy = y - this.mLastY;
                if (!this.isCanDrag) {
                    this.isCanDrag = this.isMoveAction(dx, dy);
                }
                if (this.isCanDrag) {
                    RectF rectF = this.getMatrixRectF();
                    if (this.getDrawable() != null) {
                        this.isCheckTopAndBottom = true;
                        this.isCheckLeftAndRight = true;
                        if (rectF.width() <= (float)this.getWidth()) {
                            this.isCheckLeftAndRight = false;
                            dx = 0.0f;
                        }
                        if (rectF.height() <= (float)this.getHeight()) {
                            this.isCheckTopAndBottom = false;
                            dy = 0.0f;
                        }
                        this.mMatrix.postTranslate(dx, dy);
                        this.checkBorderWhenTranslate();
                        this.setImageMatrix(this.mMatrix);
                    }
                }
                this.mLastX = x;
                this.mLastY = y;
                RectF rect = this.getMatrixRectF();
                if (!(rect.width() > (float)this.getWidth() + 0.01f) && !(rect.height() > (float)this.getHeight() + 0.01f) || rect.right == (float)this.getWidth() || rect.left == 0.0f) break;
                try {
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                }
                catch (Exception e) {
                    ZoomImageView.log(e.toString());
                }
                break;
            }
            case 1: 
            case 3: {
                this.mLastPointereCount = 0;
            }
        }
        return true;
    }

    private void checkBorderWhenTranslate() {
        RectF rectF = this.getMatrixRectF();
        float deltaX = 0.0f;
        float deltaY = 0.0f;
        int width = this.getWidth();
        int height = this.getHeight();
        if (rectF.top > 0.0f && this.isCheckTopAndBottom) {
            deltaY = -rectF.top;
        }
        if (rectF.bottom < (float)height && this.isCheckTopAndBottom) {
            deltaY = (float)height - rectF.bottom;
        }
        if (rectF.left > 0.0f && this.isCheckLeftAndRight) {
            deltaX = -rectF.left;
        }
        if (rectF.right < (float)width && this.isCheckLeftAndRight) {
            deltaX = (float)width - rectF.right;
        }
        this.mMatrix.postTranslate(deltaX, deltaY);
        this.setImageMatrix(this.mMatrix);
    }

    private boolean isMoveAction(float dx, float dy) {
        return Math.sqrt(dx * dx + dy * dy) > (double)this.mTouchSlop;
    }

    public boolean onScale(ScaleGestureDetector detector) {
        float scaleFactor = detector.getScaleFactor();
        float scale = this.getScale();
        if (this.getDrawable() == null) {
            return true;
        }
        if (scale < this.mMaxScale && scaleFactor > 1.0f || scale > this.mMinScale && scaleFactor < 1.0f) {
            if (scaleFactor * scale < this.mMinScale) {
                scaleFactor = this.mMinScale / scale;
            }
            if (scale * scaleFactor > this.mMaxScale) {
                scaleFactor = this.mMaxScale / scale;
            }
            this.mMatrix.postScale(scaleFactor, scaleFactor, detector.getFocusX(), detector.getFocusY());
            this.checkBorderAndCenterWhenScale();
            this.setImageMatrix(this.mMatrix);
        }
        return true;
    }

    private void checkBorderAndCenterWhenScale() {
        RectF rectF = this.getMatrixRectF();
        float deltaX = 0.0f;
        float deltaY = 0.0f;
        int width = this.getWidth();
        int height = this.getHeight();
        if (rectF.width() >= (float)width) {
            if (rectF.left > 0.0f) {
                deltaX = -rectF.left;
            }
            if (rectF.right < (float)width) {
                deltaX = (float)width - rectF.right;
            }
        }
        if (rectF.height() >= (float)height) {
            if (rectF.top > 0.0f) {
                deltaY = 0.0f;
            }
            if (rectF.bottom < (float)height) {
                deltaY = (float)height - rectF.bottom;
            }
        }
        if (rectF.width() < (float)width) {
            deltaX = (float)width / 2.0f - rectF.right + rectF.width() / 2.0f;
        }
        if (rectF.height() < (float)height) {
            deltaY = (float)height / 2.0f - rectF.bottom + rectF.height() / 2.0f;
        }
        this.mMatrix.postTranslate(deltaX, deltaY);
        this.setImageMatrix(this.mMatrix);
    }

    private RectF getMatrixRectF() {
        RectF rectF = new RectF();
        Drawable drawable2 = this.getDrawable();
        if (drawable2 != null) {
            rectF.set(0.0f, 0.0f, (float)drawable2.getIntrinsicWidth(), (float)drawable2.getIntrinsicHeight());
            this.mMatrix.mapRect(rectF);
        }
        return rectF;
    }

    public boolean onScaleBegin(ScaleGestureDetector scaleGestureDetector) {
        return true;
    }

    public void onScaleEnd(ScaleGestureDetector scaleGestureDetector) {
    }

    private float getScale() {
        float[] values = new float[9];
        this.mMatrix.getValues(values);
        return values[0];
    }

    public void setImageBitmap(Bitmap bm) {
        this.reSetState();
        super.setImageBitmap(bm);
    }

    public void setImageResource(int resId) {
        this.reSetState();
        super.setImageResource(resId);
    }

    public void setImageDrawable(Drawable drawable2) {
        this.reSetState();
        super.setImageDrawable(drawable2);
    }

    public void setOnClickListener(View.OnClickListener l) {
        this.onClickListener = l;
    }

    public void placeholder(int resID) {
        this.arae_img_id = resID;
        this.setScaleType(ImageView.ScaleType.CENTER);
        this.setImageResource(resID);
    }

    private class AutoScaleRunnable
    implements Runnable {
        private float mTargetScale;
        private float x;
        private float y;
        private float tmpScale;
        private final float BIGGER = 1.07f;
        private final float SMALL = 0.93f;

        public AutoScaleRunnable(float mTargetScale, float x, float y) {
            this.mTargetScale = mTargetScale;
            this.x = x;
            this.y = y;
            this.tmpScale = ZoomImageView.this.getScale() < mTargetScale ? 1.07f : 0.93f;
        }

        @Override
        public void run() {
            ZoomImageView.this.mMatrix.postScale(this.tmpScale, this.tmpScale, this.x, this.y);
            ZoomImageView.this.checkBorderAndCenterWhenScale();
            ZoomImageView.this.setImageMatrix(ZoomImageView.this.mMatrix);
            float currentScale = ZoomImageView.this.getScale();
            if (this.tmpScale > 1.0f && currentScale < this.mTargetScale || this.tmpScale < 1.0f && currentScale > this.mTargetScale) {
                ZoomImageView.this.postDelayed(this, 16L);
            } else {
                float scale = this.mTargetScale / currentScale;
                ZoomImageView.this.mMatrix.postScale(scale, scale, this.x, this.y);
                ZoomImageView.this.checkBorderAndCenterWhenScale();
                ZoomImageView.this.setImageMatrix(ZoomImageView.this.mMatrix);
                ZoomImageView.this.isScaleing = false;
            }
        }
    }
}

