/*
 * Decompiled with CFR 0.152.
 */
package com.instapp.nat.media_image.multi_image_selector;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.database.Cursor;
import android.graphics.Point;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.CursorLoader;
import android.support.v4.content.Loader;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.ListPopupWindow;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.ListAdapter;
import android.widget.TextView;
import android.widget.Toast;
import com.instapp.nat.media_image.R;
import com.instapp.nat.media_image.multi_image_selector.adapter.FolderAdapter;
import com.instapp.nat.media_image.multi_image_selector.adapter.ImageGridAdapter;
import com.instapp.nat.media_image.multi_image_selector.bean.Folder;
import com.instapp.nat.media_image.multi_image_selector.bean.Image;
import com.instapp.nat.media_image.multi_image_selector.utils.FileUtils;
import com.instapp.nat.media_image.multi_image_selector.utils.ScreenUtils;
import com.squareup.picasso.Picasso;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;

public class MultiImageSelectorFragment
extends Fragment {
    public static final String TAG = "MultiImageSelectorFragment";
    private static final int REQUEST_STORAGE_WRITE_ACCESS_PERMISSION = 110;
    private static final int REQUEST_CAMERA = 100;
    private static final String KEY_TEMP_FILE = "key_temp_file";
    public static final int MODE_SINGLE = 0;
    public static final int MODE_MULTI = 1;
    public static final String EXTRA_SELECT_COUNT = "max_select_count";
    public static final String EXTRA_SELECT_MODE = "select_count_mode";
    public static final String EXTRA_SHOW_CAMERA = "show_camera";
    public static final String EXTRA_DEFAULT_SELECTED_LIST = "default_list";
    private static final int LOADER_ALL = 0;
    private static final int LOADER_CATEGORY = 1;
    private ArrayList<String> resultList = new ArrayList();
    private ArrayList<Folder> mResultFolder = new ArrayList();
    private GridView mGridView;
    private Callback mCallback;
    private ImageGridAdapter mImageAdapter;
    private FolderAdapter mFolderAdapter;
    private ListPopupWindow mFolderPopupWindow;
    private TextView mCategoryText;
    private View mPopupAnchorView;
    private boolean hasFolderGened = false;
    private File mTmpFile;
    private LoaderManager.LoaderCallbacks<Cursor> mLoaderCallback = new LoaderManager.LoaderCallbacks<Cursor>(){
        private final String[] IMAGE_PROJECTION = new String[]{"_data", "_display_name", "date_added", "mime_type", "_size", "_id"};

        public Loader<Cursor> onCreateLoader(int id2, Bundle args) {
            CursorLoader cursorLoader = null;
            if (id2 == 0) {
                cursorLoader = new CursorLoader((Context)MultiImageSelectorFragment.this.getActivity(), MediaStore.Images.Media.EXTERNAL_CONTENT_URI, this.IMAGE_PROJECTION, this.IMAGE_PROJECTION[4] + ">0 AND " + this.IMAGE_PROJECTION[3] + "=? OR " + this.IMAGE_PROJECTION[3] + "=? ", new String[]{"image/jpeg", "image/png"}, this.IMAGE_PROJECTION[2] + " DESC");
            } else if (id2 == 1) {
                cursorLoader = new CursorLoader((Context)MultiImageSelectorFragment.this.getActivity(), MediaStore.Images.Media.EXTERNAL_CONTENT_URI, this.IMAGE_PROJECTION, this.IMAGE_PROJECTION[4] + ">0 AND " + this.IMAGE_PROJECTION[0] + " like '%" + args.getString("path") + "%'", null, this.IMAGE_PROJECTION[2] + " DESC");
            }
            return cursorLoader;
        }

        private boolean fileExist(String path) {
            if (!TextUtils.isEmpty((CharSequence)path)) {
                return new File(path).exists();
            }
            return false;
        }

        public void onLoadFinished(Loader<Cursor> loader, Cursor data) {
            if (data != null && data.getCount() > 0) {
                ArrayList<Image> images = new ArrayList<Image>();
                data.moveToFirst();
                do {
                    File folderFile;
                    String path = data.getString(data.getColumnIndexOrThrow(this.IMAGE_PROJECTION[0]));
                    String name = data.getString(data.getColumnIndexOrThrow(this.IMAGE_PROJECTION[1]));
                    long dateTime = data.getLong(data.getColumnIndexOrThrow(this.IMAGE_PROJECTION[2]));
                    if (!this.fileExist(path)) continue;
                    Image image = null;
                    if (!TextUtils.isEmpty((CharSequence)name)) {
                        image = new Image(path, name, dateTime);
                        images.add(image);
                    }
                    if (MultiImageSelectorFragment.this.hasFolderGened || (folderFile = new File(path).getParentFile()) == null || !folderFile.exists()) continue;
                    String fp = folderFile.getAbsolutePath();
                    Folder f = MultiImageSelectorFragment.this.getFolderByPath(fp);
                    if (f == null) {
                        Folder folder = new Folder();
                        folder.name = folderFile.getName();
                        folder.path = fp;
                        folder.cover = image;
                        ArrayList<Image> imageList = new ArrayList<Image>();
                        imageList.add(image);
                        folder.images = imageList;
                        MultiImageSelectorFragment.this.mResultFolder.add(folder);
                        continue;
                    }
                    f.images.add(image);
                } while (data.moveToNext());
                MultiImageSelectorFragment.this.mImageAdapter.setData(images);
                if (MultiImageSelectorFragment.this.resultList != null && MultiImageSelectorFragment.this.resultList.size() > 0) {
                    MultiImageSelectorFragment.this.mImageAdapter.setDefaultSelected(MultiImageSelectorFragment.this.resultList);
                }
                if (!MultiImageSelectorFragment.this.hasFolderGened) {
                    MultiImageSelectorFragment.this.mFolderAdapter.setData(MultiImageSelectorFragment.this.mResultFolder);
                    MultiImageSelectorFragment.this.hasFolderGened = true;
                }
            }
        }

        public void onLoaderReset(Loader<Cursor> loader) {
        }
    };

    public void onAttach(Context context) {
        super.onAttach(context);
        try {
            this.mCallback = (Callback)this.getActivity();
        }
        catch (ClassCastException e) {
            throw new ClassCastException("The Activity must implement MultiImageSelectorFragment.Callback interface...");
        }
    }

    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.mis_fragment_multi_image, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        ArrayList tmp;
        super.onViewCreated(view, savedInstanceState);
        final int mode = this.selectMode();
        if (mode == 1 && (tmp = this.getArguments().getStringArrayList(EXTRA_DEFAULT_SELECTED_LIST)) != null && tmp.size() > 0) {
            this.resultList = tmp;
        }
        this.mImageAdapter = new ImageGridAdapter((Context)this.getActivity(), this.showCamera(), 3);
        this.mImageAdapter.showSelectIndicator(mode == 1);
        this.mPopupAnchorView = view.findViewById(R.id.footer);
        this.mCategoryText = (TextView)view.findViewById(R.id.category_btn);
        this.mCategoryText.setText(R.string.mis_folder_all);
        this.mCategoryText.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (MultiImageSelectorFragment.this.mFolderPopupWindow == null) {
                    MultiImageSelectorFragment.this.createPopupFolderList();
                }
                if (MultiImageSelectorFragment.this.mFolderPopupWindow.isShowing()) {
                    MultiImageSelectorFragment.this.mFolderPopupWindow.dismiss();
                } else {
                    MultiImageSelectorFragment.this.mFolderPopupWindow.show();
                    int index = MultiImageSelectorFragment.this.mFolderAdapter.getSelectIndex();
                    index = index == 0 ? index : index - 1;
                    MultiImageSelectorFragment.this.mFolderPopupWindow.getListView().setSelection(index);
                }
            }
        });
        this.mGridView = (GridView)view.findViewById(R.id.grid);
        this.mGridView.setAdapter((ListAdapter)this.mImageAdapter);
        this.mGridView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                if (MultiImageSelectorFragment.this.mImageAdapter.isShowCamera()) {
                    if (i == 0) {
                        MultiImageSelectorFragment.this.showCameraAction();
                    } else {
                        Image image = (Image)adapterView.getAdapter().getItem(i);
                        MultiImageSelectorFragment.this.selectImageFromGrid(image, mode);
                    }
                } else {
                    Image image = (Image)adapterView.getAdapter().getItem(i);
                    MultiImageSelectorFragment.this.selectImageFromGrid(image, mode);
                }
            }
        });
        this.mGridView.setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView view, int scrollState) {
                if (scrollState == 2) {
                    Picasso.with((Context)view.getContext()).pauseTag((Object)MultiImageSelectorFragment.TAG);
                } else {
                    Picasso.with((Context)view.getContext()).resumeTag((Object)MultiImageSelectorFragment.TAG);
                }
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            }
        });
        this.mFolderAdapter = new FolderAdapter((Context)this.getActivity());
    }

    private void createPopupFolderList() {
        Point point = ScreenUtils.getScreenSize((Context)this.getActivity());
        int width = point.x;
        int height = (int)((float)point.y * 0.5625f);
        this.mFolderPopupWindow = new ListPopupWindow((Context)this.getActivity());
        this.mFolderPopupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(-1));
        this.mFolderPopupWindow.setAdapter((ListAdapter)this.mFolderAdapter);
        this.mFolderPopupWindow.setContentWidth(width);
        this.mFolderPopupWindow.setWidth(width);
        this.mFolderPopupWindow.setHeight(height);
        this.mFolderPopupWindow.setAnchorView(this.mPopupAnchorView);
        this.mFolderPopupWindow.setModal(true);
        this.mFolderPopupWindow.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                MultiImageSelectorFragment.this.mFolderAdapter.setSelectIndex(i);
                final int index = i;
                final AdapterView<?> v = adapterView;
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        MultiImageSelectorFragment.this.mFolderPopupWindow.dismiss();
                        if (index == 0) {
                            MultiImageSelectorFragment.this.getActivity().getSupportLoaderManager().restartLoader(0, null, MultiImageSelectorFragment.this.mLoaderCallback);
                            MultiImageSelectorFragment.this.mCategoryText.setText(R.string.mis_folder_all);
                            if (MultiImageSelectorFragment.this.showCamera()) {
                                MultiImageSelectorFragment.this.mImageAdapter.setShowCamera(true);
                            } else {
                                MultiImageSelectorFragment.this.mImageAdapter.setShowCamera(false);
                            }
                        } else {
                            Folder folder = (Folder)v.getAdapter().getItem(index);
                            if (null != folder) {
                                MultiImageSelectorFragment.this.mImageAdapter.setData(folder.images);
                                MultiImageSelectorFragment.this.mCategoryText.setText((CharSequence)folder.name);
                                if (MultiImageSelectorFragment.this.resultList != null && MultiImageSelectorFragment.this.resultList.size() > 0) {
                                    MultiImageSelectorFragment.this.mImageAdapter.setDefaultSelected(MultiImageSelectorFragment.this.resultList);
                                }
                            }
                            MultiImageSelectorFragment.this.mImageAdapter.setShowCamera(false);
                        }
                        MultiImageSelectorFragment.this.mGridView.smoothScrollToPosition(0);
                    }
                }, 100L);
            }
        });
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putSerializable(KEY_TEMP_FILE, (Serializable)this.mTmpFile);
    }

    public void onViewStateRestored(@Nullable Bundle savedInstanceState) {
        super.onViewStateRestored(savedInstanceState);
        if (savedInstanceState != null) {
            this.mTmpFile = (File)savedInstanceState.getSerializable(KEY_TEMP_FILE);
        }
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.getActivity().getSupportLoaderManager().initLoader(0, null, this.mLoaderCallback);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 100) {
            if (resultCode == -1) {
                if (this.mTmpFile != null && this.mCallback != null) {
                    this.mCallback.onCameraShot(this.mTmpFile);
                }
            } else {
                while (this.mTmpFile != null && this.mTmpFile.exists()) {
                    boolean success = this.mTmpFile.delete();
                    if (!success) continue;
                    this.mTmpFile = null;
                }
            }
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        if (this.mFolderPopupWindow != null && this.mFolderPopupWindow.isShowing()) {
            this.mFolderPopupWindow.dismiss();
        }
        super.onConfigurationChanged(newConfig);
    }

    private void showCameraAction() {
        if (ContextCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            this.requestPermission("android.permission.WRITE_EXTERNAL_STORAGE", this.getString(R.string.mis_permission_rationale_write_storage), 110);
        } else {
            Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
            if (intent.resolveActivity(this.getActivity().getPackageManager()) != null) {
                try {
                    this.mTmpFile = FileUtils.createTmpFile((Context)this.getActivity());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (this.mTmpFile != null && this.mTmpFile.exists()) {
                    intent.putExtra("output", (Parcelable)Uri.fromFile((File)this.mTmpFile));
                    this.startActivityForResult(intent, 100);
                } else {
                    Toast.makeText((Context)this.getActivity(), (int)R.string.mis_error_image_not_exist, (int)0).show();
                }
            } else {
                Toast.makeText((Context)this.getActivity(), (int)R.string.mis_msg_no_camera, (int)0).show();
            }
        }
    }

    private void requestPermission(final String permission2, String rationale, final int requestCode) {
        if (this.shouldShowRequestPermissionRationale(permission2)) {
            new AlertDialog.Builder(this.getContext()).setTitle(R.string.mis_permission_dialog_title).setMessage((CharSequence)rationale).setPositiveButton(R.string.mis_permission_dialog_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    MultiImageSelectorFragment.this.requestPermissions(new String[]{permission2}, requestCode);
                }
            }).setNegativeButton(R.string.mis_permission_dialog_cancel, null).create().show();
        } else {
            this.requestPermissions(new String[]{permission2}, requestCode);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == 110) {
            if (grantResults[0] == 0) {
                this.showCameraAction();
            }
        } else {
            super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    private void selectImageFromGrid(Image image, int mode) {
        if (image != null) {
            if (mode == 1) {
                if (this.resultList.contains(image.path)) {
                    this.resultList.remove(image.path);
                    if (this.mCallback != null) {
                        this.mCallback.onImageUnselected(image.path);
                    }
                } else {
                    if (this.selectImageCount() == this.resultList.size()) {
                        Toast.makeText((Context)this.getActivity(), (int)R.string.mis_msg_amount_limit, (int)0).show();
                        return;
                    }
                    this.resultList.add(image.path);
                    if (this.mCallback != null) {
                        this.mCallback.onImageSelected(image.path);
                    }
                }
                this.mImageAdapter.select(image);
            } else if (mode == 0 && this.mCallback != null) {
                this.mCallback.onSingleImageSelected(image.path);
            }
        }
    }

    private Folder getFolderByPath(String path) {
        if (this.mResultFolder != null) {
            for (Folder folder : this.mResultFolder) {
                if (!TextUtils.equals((CharSequence)folder.path, (CharSequence)path)) continue;
                return folder;
            }
        }
        return null;
    }

    private boolean showCamera() {
        return this.getArguments() == null || this.getArguments().getBoolean(EXTRA_SHOW_CAMERA, true);
    }

    private int selectMode() {
        return this.getArguments() == null ? 1 : this.getArguments().getInt(EXTRA_SELECT_MODE);
    }

    private int selectImageCount() {
        return this.getArguments() == null ? 9 : this.getArguments().getInt(EXTRA_SELECT_COUNT);
    }

    public static interface Callback {
        public void onSingleImageSelected(String var1);

        public void onImageSelected(String var1);

        public void onImageUnselected(String var1);

        public void onCameraShot(File var1);
    }
}

