/*
 * Decompiled with CFR 0.152.
 */
package com.instapp.nat.media_image.multi_image_selector;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.widget.Toast;
import com.instapp.nat.media_image.R;
import com.instapp.nat.media_image.multi_image_selector.MultiImageSelectorActivity;
import java.util.ArrayList;

public class MultiImageSelector {
    public static final String EXTRA_RESULT = "select_result";
    private boolean mShowCamera = true;
    private int mMaxCount = 9;
    private int mMode = 1;
    private ArrayList<String> mOriginData;
    private static MultiImageSelector sSelector;

    @Deprecated
    private MultiImageSelector(Context context) {
    }

    private MultiImageSelector() {
    }

    @Deprecated
    public static MultiImageSelector create(Context context) {
        if (sSelector == null) {
            sSelector = new MultiImageSelector(context);
        }
        return sSelector;
    }

    public static MultiImageSelector create() {
        if (sSelector == null) {
            sSelector = new MultiImageSelector();
        }
        return sSelector;
    }

    public MultiImageSelector showCamera(boolean show) {
        this.mShowCamera = show;
        return sSelector;
    }

    public MultiImageSelector count(int count) {
        this.mMaxCount = count;
        return sSelector;
    }

    public MultiImageSelector single() {
        this.mMode = 0;
        return sSelector;
    }

    public MultiImageSelector multi() {
        this.mMode = 1;
        return sSelector;
    }

    public MultiImageSelector origin(ArrayList<String> images) {
        this.mOriginData = images;
        return sSelector;
    }

    public void start(Activity activity, int requestCode) {
        Activity context = activity;
        if (this.hasPermission((Context)context)) {
            activity.startActivityForResult(this.createIntent((Context)context), requestCode);
        } else {
            Toast.makeText((Context)context, (int)R.string.mis_error_no_permission, (int)0).show();
        }
    }

    public void start(Fragment fragment, int requestCode) {
        Context context = fragment.getContext();
        if (this.hasPermission(context)) {
            fragment.startActivityForResult(this.createIntent(context), requestCode);
        } else {
            Toast.makeText((Context)context, (int)R.string.mis_error_no_permission, (int)0).show();
        }
    }

    private boolean hasPermission(Context context) {
        if (Build.VERSION.SDK_INT >= 16) {
            return ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_EXTERNAL_STORAGE") == 0;
        }
        return true;
    }

    private Intent createIntent(Context context) {
        Intent intent = new Intent(context, MultiImageSelectorActivity.class);
        intent.putExtra("show_camera", this.mShowCamera);
        intent.putExtra("max_select_count", this.mMaxCount);
        if (this.mOriginData != null) {
            intent.putStringArrayListExtra("default_list", this.mOriginData);
        }
        intent.putExtra("select_count_mode", this.mMode);
        return intent;
    }
}

