/*
 * Decompiled with CFR 0.152.
 */
package com.instapp.nat.media_image;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.instapp.nat.media_image.ImagePreviewAdapter;
import com.instapp.nat.media_image.MessageEvent;
import com.instapp.nat.media_image.R;
import com.instapp.nat.media_image.Util;
import com.instapp.nat.media_image.zoomimageview.ZoomImageView;
import com.squareup.picasso.Picasso;
import java.util.ArrayList;
import org.greenrobot.eventbus.EventBus;

public class ImagePreviewActivity
extends AppCompatActivity {
    private ViewPager mViewPager;
    private LinearLayout mIndicator;
    private ImagePreviewAdapter mAdapter;
    private ArrayList<ZoomImageView> mDatas;
    private int mStartIndex;
    private String mStyle;
    private String[] mPaths;
    private TextView mTextView;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_image_preview);
        Intent intent = this.getIntent();
        if (intent != null) {
            this.mPaths = intent.getStringArrayExtra("paths");
            this.mStyle = intent.getStringExtra("style");
            this.mStartIndex = intent.getIntExtra("current", 0);
            if (this.mPaths.length > 9 && this.mStyle.equals("dots")) {
                this.mStyle = "label";
            }
        }
        this.initView();
        this.setData();
    }

    private void initView() {
        this.mViewPager = (ViewPager)this.findViewById(R.id.viewpager);
        this.mIndicator = (LinearLayout)this.findViewById(R.id.ll_indicator);
        this.mAdapter = new ImagePreviewAdapter();
        this.mViewPager.setAdapter((PagerAdapter)this.mAdapter);
        this.mViewPager.setOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                if (ImagePreviewActivity.this.mStyle.equals("dots")) {
                    for (int i = 0; i < ImagePreviewActivity.this.mIndicator.getChildCount(); ++i) {
                        View view = ImagePreviewActivity.this.mIndicator.getChildAt(i);
                        view.setEnabled(i == position);
                    }
                } else if (ImagePreviewActivity.this.mStyle.equals("label")) {
                    ImagePreviewActivity.this.mTextView.setText((CharSequence)(position + 1 + "-" + ImagePreviewActivity.this.mAdapter.getCount()));
                }
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
    }

    public void setData() {
        if (this.mPaths == null && this.mPaths.length == 0) {
            this.finish();
        }
        this.mDatas = new ArrayList();
        for (int i = 0; i < this.mPaths.length; ++i) {
            ZoomImageView zoomImageView = new ZoomImageView((Context)this);
            this.mDatas.add(zoomImageView);
            if (this.mPaths[i].startsWith("http://") || this.mPaths[i].startsWith("https://")) {
                Picasso.with((Context)this).load(this.mPaths[i]).into((ImageView)zoomImageView);
            } else if (this.mPaths[i].startsWith("R.mipmap") || this.mPaths[i].startsWith("R.drawable")) {
                Picasso.with((Context)this).load(this.mPaths[i]).into((ImageView)zoomImageView);
            } else {
                Bitmap bitmap = null;
                try {
                    bitmap = BitmapFactory.decodeFile((String)this.mPaths[i]);
                }
                catch (OutOfMemoryError error) {
                    error.printStackTrace();
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    options.inSampleSize = 2;
                    bitmap = BitmapFactory.decodeFile((String)this.mPaths[i], (BitmapFactory.Options)options);
                }
                if (bitmap == null) {
                    EventBus.getDefault().post((Object)new MessageEvent("MEDIA_SRC_NOT_SUPPORTED", "image_preview"));
                }
                zoomImageView.setImageBitmap(bitmap);
            }
            if (this.mStyle.equals("dots")) {
                ImageView indicator = new ImageView((Context)this);
                indicator.setImageResource(R.drawable.indicator);
                LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams((int)Util.dp2px((Context)this, 8.0f), (int)Util.dp2px((Context)this, 8.0f));
                layoutParams.leftMargin = (int)Util.dp2px((Context)this, 4.0f);
                indicator.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                this.mIndicator.addView((View)indicator);
                indicator.setEnabled(i == this.mStartIndex);
                this.mIndicator.setVisibility(0);
            }
            zoomImageView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    ImagePreviewActivity.this.finish();
                }
            });
        }
        if (this.mStyle.equals("label")) {
            this.mTextView = new TextView((Context)this);
            this.mTextView.setText((CharSequence)(this.mStartIndex + 1 + " / " + this.mPaths.length));
            this.mTextView.setTextColor(this.getResources().getColor(R.color.white));
            this.mTextView.setTextSize(14.0f);
            this.mIndicator.addView((View)this.mTextView);
            this.mIndicator.setVisibility(0);
        } else if (this.mStyle.equals("none")) {
            this.mIndicator.setVisibility(8);
        }
        this.mAdapter.setData(this.mDatas);
        this.mViewPager.setCurrentItem(this.mStartIndex);
    }
}

