/*
 * Decompiled with CFR 0.152.
 */
package com.instana.android.instrumentation.okhttp3;

import com.instana.android.Instana;
import com.instana.android.core.util.ConstantsAndUtil;
import com.instana.android.core.util.Logger;
import com.instana.android.core.util.OkHttp3ExtensionsKt;
import com.instana.android.instrumentation.HTTPMarker;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/instana/android/instrumentation/okhttp3/OkHttp3GlobalInterceptor;", "Lokhttp3/Interceptor;", "()V", "httpMarkers", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/instana/android/instrumentation/HTTPMarker;", "cancel", "", "request", "Lokhttp3/Request;", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "runtime_release"})
public final class OkHttp3GlobalInterceptor
implements Interceptor {
    @NotNull
    public static final OkHttp3GlobalInterceptor INSTANCE = new OkHttp3GlobalInterceptor();
    @NotNull
    private static final ConcurrentHashMap<String, HTTPMarker> httpMarkers = new ConcurrentHashMap();

    private OkHttp3GlobalInterceptor() {
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Response response;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request intercepted = chain.request();
        String header = intercepted.header("X-INSTANA-ANDROID");
        String string = intercepted.url().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"intercepted.url().toString()");
        String url = string;
        String redactedUrl = ConstantsAndUtil.INSTANCE.redactQueryParams(url);
        Request request = null;
        HTTPMarker marker = null;
        if (ConstantsAndUtil.INSTANCE.isAutoEnabled() && !ConstantsAndUtil.INSTANCE.hasTrackingHeader(header) && !ConstantsAndUtil.INSTANCE.isBlacklistedURL(url)) {
            if (!ConstantsAndUtil.INSTANCE.checkTag(header) && !ConstantsAndUtil.INSTANCE.isLibraryCallBoolean(url)) {
                Headers headers;
                Headers headers2 = intercepted.headers();
                Intrinsics.checkNotNullExpressionValue((Object)headers2, (String)"intercepted.headers()");
                Map<String, String> requestHeaders = ConstantsAndUtil.INSTANCE.getCapturedRequestHeaders$runtime_release(OkHttp3ExtensionsKt.toMap(headers2));
                marker = Instana.startCapture$default(redactedUrl, null, requestHeaders, 2, null);
                if (marker != null) {
                    Logger.d(Intrinsics.stringPlus((String)"Automatically marked OkHttp3 request with: `url` ", (Object)redactedUrl));
                    ((Map)httpMarkers).put(marker.headerValue(), marker);
                    headers2 = chain.request().newBuilder().header("X-INSTANA-ANDROID", marker.headerValue()).build();
                    Intrinsics.checkNotNullExpressionValue((Object)headers2, (String)"{\n                    Lo\u2026build()\n                }");
                    headers = headers2;
                } else {
                    Logger.e(Intrinsics.stringPlus((String)"Failed to automatically mark OkHttp3 request with: `url` ", (Object)redactedUrl));
                    headers2 = intercepted;
                    Intrinsics.checkNotNullExpressionValue((Object)headers2, (String)"{\n                    Lo\u2026rcepted\n                }");
                    headers = headers2;
                }
                request = headers;
            } else {
                Logger.d(Intrinsics.stringPlus((String)"Skipped already tagged OkHttp3 request with: `url` ", (Object)redactedUrl));
                Intrinsics.checkNotNullExpressionValue((Object)intercepted, (String)"intercepted");
                request = intercepted;
            }
        } else {
            Logger.d(Intrinsics.stringPlus((String)"Ignored OkHttp3 request with: `url` ", (Object)redactedUrl));
            Intrinsics.checkNotNullExpressionValue((Object)intercepted, (String)"intercepted");
            request = intercepted;
        }
        try {
            Response response2 = chain.proceed(request);
            Logger.d(Intrinsics.stringPlus((String)"Finishing OkHttp3 request with: `url` ", (Object)redactedUrl));
            HTTPMarker hTTPMarker = marker;
            if (hTTPMarker != null) {
                HTTPMarker $this$intercept_u24lambda_u2d0 = hTTPMarker;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"response");
                $this$intercept_u24lambda_u2d0.finish(response2);
                httpMarkers.remove(marker.headerValue(), marker);
            }
            response = response2;
            Intrinsics.checkNotNullExpressionValue((Object)response, (String)"{\n            val respon\u2026       response\n        }");
        }
        catch (Exception e) {
            Logger.d("Finishing OkHttp3 request with: `url` " + redactedUrl + ", `error` " + e.getMessage());
            HTTPMarker hTTPMarker = marker;
            if (hTTPMarker != null) {
                HTTPMarker $this$intercept_u24lambda_u2d1 = hTTPMarker;
                boolean bl = false;
                $this$intercept_u24lambda_u2d1.finish(request, (Throwable)e);
                httpMarkers.remove(marker.headerValue(), marker);
            }
            throw e;
        }
        return response;
    }

    public final void cancel(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        HttpUrl httpUrl = request.url();
        String string = httpUrl == null ? null : httpUrl.toString();
        if (string == null) {
            return;
        }
        String url = string;
        String redactedUrl = ConstantsAndUtil.INSTANCE.redactQueryParams(url);
        String cancelledTrackerValue = request.header("X-INSTANA-ANDROID");
        if (cancelledTrackerValue == null) {
            Logger.w(Intrinsics.stringPlus((String)"No marker found for cancelled OkHttp3 request with: 'url' ", (Object)redactedUrl));
            return;
        }
        HTTPMarker marker = httpMarkers.get(cancelledTrackerValue);
        if (marker == null) {
            Headers headers = request.headers();
            Intrinsics.checkNotNullExpressionValue((Object)headers, (String)"request.headers()");
            Map<String, String> requestHeaders = ConstantsAndUtil.INSTANCE.getCapturedRequestHeaders$runtime_release(OkHttp3ExtensionsKt.toMap(headers));
            marker = Instana.startCapture$default(redactedUrl, null, requestHeaders, 2, null);
        }
        HTTPMarker hTTPMarker = marker;
        if (hTTPMarker != null) {
            HTTPMarker $this$cancel_u24lambda_u2d2 = hTTPMarker;
            boolean bl = false;
            $this$cancel_u24lambda_u2d2.cancel();
            httpMarkers.remove($this$cancel_u24lambda_u2d2.headerValue());
        }
    }
}

