/*
 * Decompiled with CFR 0.152.
 */
package com.instana.android.instrumentation;

import android.content.Context;
import android.net.ConnectivityManager;
import android.telephony.TelephonyManager;
import com.instana.android.core.InstanaConfig;
import com.instana.android.core.InstanaWorkManager;
import com.instana.android.instrumentation.HTTPCaptureConfig;
import com.instana.android.instrumentation.HTTPMarker;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000fJ.\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u000f2\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u001fJ\u000e\u0010 \u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fJ\u000e\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006$"}, d2={"Lcom/instana/android/instrumentation/InstrumentationService;", "", "context", "Landroid/content/Context;", "manager", "Lcom/instana/android/core/InstanaWorkManager;", "config", "Lcom/instana/android/core/InstanaConfig;", "(Landroid/content/Context;Lcom/instana/android/core/InstanaWorkManager;Lcom/instana/android/core/InstanaConfig;)V", "connectivityManager", "Landroid/net/ConnectivityManager;", "getConnectivityManager", "()Landroid/net/ConnectivityManager;", "tags", "", "", "telephonyManager", "Landroid/telephony/TelephonyManager;", "getTelephonyManager", "()Landroid/telephony/TelephonyManager;", "addTag", "", "tag", "hasTag", "", "header", "markCall", "Lcom/instana/android/instrumentation/HTTPMarker;", "url", "viewName", "requestHeaders", "", "removeTag", "setType", "type", "Lcom/instana/android/instrumentation/HTTPCaptureConfig;", "runtime_release"})
public final class InstrumentationService {
    @NotNull
    private final Context context;
    @NotNull
    private final InstanaWorkManager manager;
    @NotNull
    private final InstanaConfig config;
    @NotNull
    private final Set<String> tags;
    @NotNull
    private final ConnectivityManager connectivityManager;
    @NotNull
    private final TelephonyManager telephonyManager;

    public InstrumentationService(@NotNull Context context, @NotNull InstanaWorkManager manager, @NotNull InstanaConfig config) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.context = context;
        this.manager = manager;
        this.config = config;
        this.tags = new LinkedHashSet();
        Object object = this.context.getSystemService("connectivity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        this.connectivityManager = (ConnectivityManager)object;
        Object object2 = this.context.getSystemService("phone");
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        this.telephonyManager = (TelephonyManager)object2;
    }

    @NotNull
    public final ConnectivityManager getConnectivityManager() {
        return this.connectivityManager;
    }

    @NotNull
    public final TelephonyManager getTelephonyManager() {
        return this.telephonyManager;
    }

    public final void setType(@NotNull HTTPCaptureConfig type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.config.setHttpCaptureConfig(type);
    }

    @NotNull
    public final HTTPMarker markCall(@NotNull String url, @Nullable String viewName, @Nullable Map<String, String> requestHeaders) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return new HTTPMarker(url, viewName, requestHeaders, this.context, this.manager, this.config);
    }

    public final boolean hasTag(@NotNull String header) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        return this.tags.contains(header);
    }

    public final void addTag(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.tags.add(tag);
    }

    public final void removeTag(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.tags.remove(tag);
    }
}

