/*
 * Decompiled with CFR 0.152.
 */
package com.instana.android.crash;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.RestrictTo;
import com.instana.android.core.util.Logger;
import com.instana.android.crash.CrashService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\u0018\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/instana/android/crash/ExceptionHandler;", "Ljava/lang/Thread$UncaughtExceptionHandler;", "crashService", "Lcom/instana/android/crash/CrashService;", "originalHandler", "(Lcom/instana/android/crash/CrashService;Ljava/lang/Thread$UncaughtExceptionHandler;)V", "disable", "", "enable", "uncaughtException", "thread", "Ljava/lang/Thread;", "throwable", "", "runtime_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class ExceptionHandler
implements Thread.UncaughtExceptionHandler {
    @NotNull
    private final CrashService crashService;
    @NotNull
    private final Thread.UncaughtExceptionHandler originalHandler;

    public ExceptionHandler(@NotNull CrashService crashService, @NotNull Thread.UncaughtExceptionHandler originalHandler) {
        Intrinsics.checkNotNullParameter((Object)crashService, (String)"crashService");
        Intrinsics.checkNotNullParameter((Object)originalHandler, (String)"originalHandler");
        this.crashService = crashService;
        this.originalHandler = originalHandler;
    }

    public final void enable() {
        if (!(Thread.getDefaultUncaughtExceptionHandler() instanceof ExceptionHandler)) {
            Thread.setDefaultUncaughtExceptionHandler(this);
        }
    }

    public final void disable() {
        if (Thread.getDefaultUncaughtExceptionHandler() instanceof ExceptionHandler) {
            Thread.setDefaultUncaughtExceptionHandler(this.originalHandler);
        }
    }

    @Override
    public void uncaughtException(@NotNull Thread thread, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            this.crashService.submitCrash(thread, throwable);
        } else {
            new Handler(Looper.getMainLooper()).post(() -> ExceptionHandler.uncaughtException$lambda-0(this, thread, throwable));
        }
        Logger.i("Handover control to default Exception Handler");
        this.originalHandler.uncaughtException(thread, throwable);
    }

    private static final void uncaughtException$lambda-0(ExceptionHandler this$0, Thread $thread, Throwable $throwable) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$thread, (String)"$thread");
        Intrinsics.checkNotNullParameter((Object)$throwable, (String)"$throwable");
        this$0.crashService.submitCrash($thread, $throwable);
    }
}

