/*
 * Decompiled with CFR 0.152.
 */
package com.instana.android.core.util;

import androidx.annotation.RestrictTo;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J'\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b2\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u00a2\u0006\u0002\u0010\u000bJ)\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0004\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/instana/android/core/util/ThreadUtil;", "", "()V", "getAppThreads", "", "Ljava/lang/Thread;", "()[Ljava/lang/Thread;", "getStackTracesFor", "Ljava/util/HashMap;", "", "threadList", "([Ljava/lang/Thread;)Ljava/util/HashMap;", "println", "", "out", "Ljava/io/PrintWriter;", "thread", "stackTrace", "Ljava/lang/StackTraceElement;", "(Ljava/io/PrintWriter;Ljava/lang/Thread;[Ljava/lang/StackTraceElement;)V", "runtime_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class ThreadUtil {
    @NotNull
    public static final ThreadUtil INSTANCE = new ThreadUtil();

    private ThreadUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HashMap<String, String> getStackTracesFor(@NotNull Thread[] threadList) {
        Intrinsics.checkNotNullParameter((Object)threadList, (String)"threadList");
        HashMap<String, String> traces = new HashMap<String, String>();
        int n = 0;
        int n2 = threadList.length;
        while (n < n2) {
            void $this$mapTo$iv$iv;
            Thread notNull;
            Thread thread = threadList[n];
            ++n;
            if (thread == null) continue;
            boolean bl = false;
            StackTraceElement[] stackTraceElementArray = notNull.getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"notNull.stackTrace");
            Object[] $this$map$iv = stackTraceElementArray;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                StackTraceElement stackTraceElement = (StackTraceElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.toString());
            }
            String trace = ((List)destination$iv$iv).toString();
            traces.put(notNull.getName(), trace);
        }
        return traces;
    }

    @NotNull
    public final Thread[] getAppThreads() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        if (threadGroup == null) {
            boolean $i$f$emptyArray = false;
            return new Thread[0];
        }
        ThreadGroup rootGroup = threadGroup;
        Thread[] threadList = new Thread[rootGroup.activeCount()];
        while (rootGroup.enumerate(threadList, false) == threadList.length) {
            threadList = new Thread[threadList.length * 2];
        }
        return threadList;
    }

    public final void println(@NotNull PrintWriter out, @NotNull Thread thread, @NotNull StackTraceElement[] stackTrace) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        Intrinsics.checkNotNullParameter((Object)stackTrace, (String)"stackTrace");
        out.print("\"");
        out.print(thread.getName());
        out.print("\" #");
        out.print(thread.getId());
        if (thread.isDaemon()) {
            out.print(" daemon");
        }
        out.print(" prio=");
        out.print(thread.getPriority());
        out.print(thread.getState().name());
        out.println();
        int n = 0;
        int n2 = stackTrace.length;
        while (n < n2) {
            StackTraceElement st = stackTrace[n];
            ++n;
            out.print("    ");
            out.print(st.getClassName());
            out.print(".");
            out.print(st.getMethodName());
            out.print(" (");
            out.print(st.getFileName());
            if (st.getLineNumber() > 0) {
                out.print(":");
                out.print(st.getLineNumber());
            }
            if (st.isNativeMethod()) {
                out.print("/Native Method");
            }
            out.println(")");
        }
        out.println();
    }
}

