/*
 * Decompiled with CFR 0.152.
 */
package com.instana.android.core.util;

import com.instana.android.core.util.Logger;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000J\u0015\u0010\u000e\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0012J\u001b\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0016J\u001a\u0010\u0017\u001a\u00020\u00142\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0012J\u0015\u0010\u0019\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0010R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/instana/android/core/util/MaxCapacityMap;", "K", "V", "", "maxCapacity", "", "(I)V", "map", "", "getMaxCapacity", "()I", "clear", "", "clone", "get", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "getAll", "", "put", "", "value", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "putAll", "from", "remove", "runtime_release"})
public final class MaxCapacityMap<K, V> {
    private final int maxCapacity;
    @NotNull
    private Map<K, V> map;

    public MaxCapacityMap(int maxCapacity) {
        this.maxCapacity = maxCapacity;
        this.map = new LinkedHashMap();
    }

    public final int getMaxCapacity() {
        return this.maxCapacity;
    }

    public final boolean put(K key, V value) {
        boolean bl;
        if (this.map.size() < this.maxCapacity) {
            this.map.put(key, value);
            bl = true;
        } else {
            Logger.e("Tried to add an element to a full map");
            bl = false;
        }
        return bl;
    }

    public final boolean putAll(@NotNull Map<K, ? extends V> from) {
        boolean bl;
        Map map;
        Intrinsics.checkNotNullParameter(from, (String)"from");
        Map $this$putAll_u24lambda_u2d0 = map = (Map)new LinkedHashMap();
        boolean bl2 = false;
        $this$putAll_u24lambda_u2d0.putAll(this.map);
        $this$putAll_u24lambda_u2d0.putAll(from);
        Map buffer = map;
        if (buffer.size() <= this.maxCapacity) {
            this.map = buffer;
            bl = true;
        } else {
            Logger.e("Tried to add elements to a full map");
            bl = false;
        }
        return bl;
    }

    @Nullable
    public final V get(K key) {
        return this.map.get(key);
    }

    @NotNull
    public final Map<K, V> getAll() {
        return MapsKt.toMap(this.map);
    }

    @Nullable
    public final V remove(K key) {
        return this.map.remove(key);
    }

    public final void clear() {
        this.map.clear();
    }

    @NotNull
    public final MaxCapacityMap<K, V> clone() {
        MaxCapacityMap<K, V> newMap = new MaxCapacityMap<K, V>(this.maxCapacity);
        newMap.putAll(this.map);
        return newMap;
    }
}

