/*
 * Decompiled with CFR 0.152.
 */
package com.instana.android.core.util;

import android.app.Application;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.RestrictTo;
import androidx.core.app.ActivityCompat;
import com.instana.android.Instana;
import com.instana.android.core.InstanaConfig;
import com.instana.android.core.event.models.ConnectionType;
import com.instana.android.core.event.models.EffectiveConnectionType;
import com.instana.android.core.event.models.Platform;
import com.instana.android.core.util.ConstantsAndUtil;
import com.instana.android.core.util.Logger;
import com.instana.android.core.util.StringExtensionsKt;
import com.instana.android.core.util.URLUtils;
import com.instana.android.instrumentation.HTTPCaptureConfig;
import com.instana.android.instrumentation.InstrumentationService;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0014\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004J\u0015\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0018J\u0015\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u001aJ\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ-\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040 H\u0000\u00a2\u0006\u0002\b\"J-\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040 H\u0000\u00a2\u0006\u0002\b$J \u0010%\u001a\u0004\u0018\u00010\u00042\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+J \u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+J\u0018\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)J\u0006\u00100\u001a\u00020\u0004J\u001e\u00101\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u000102\u0012\u0006\u0012\u0004\u0018\u0001020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u00103\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004J\u000e\u00104\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0004J\u0010\u00105\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\u0010\u00106\u001a\u00020\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0004J\u000e\u00107\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u001b\u0010\u000f\u001a\u00020\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000b\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00068"}, d2={"Lcom/instana/android/core/util/ConstantsAndUtil;", "", "()V", "EMPTY_STR", "", "TRACKING_HEADER_KEY", "client", "Lokhttp3/OkHttpClient;", "getClient", "()Lokhttp3/OkHttpClient;", "client$delegate", "Lkotlin/Lazy;", "isAutoEnabled", "", "()Z", "runtime", "Ljava/lang/Runtime;", "getRuntime", "()Ljava/lang/Runtime;", "runtime$delegate", "checkTag", "header", "forceNoRedundantURLPort", "url", "forceNoRedundantURLPort$runtime_release", "forceRedundantURLPort", "forceRedundantURLPort$runtime_release", "getAppVersionNameAndVersionCode", "Lkotlin/Pair;", "app", "Landroid/app/Application;", "getCapturedRequestHeaders", "", "headers", "getCapturedRequestHeaders$runtime_release", "getCapturedResponseHeaders", "getCapturedResponseHeaders$runtime_release", "getCarrierName", "context", "Landroid/content/Context;", "cm", "Landroid/net/ConnectivityManager;", "tm", "Landroid/telephony/TelephonyManager;", "getCellularConnectionType", "Lcom/instana/android/core/event/models/EffectiveConnectionType;", "getConnectionType", "Lcom/instana/android/core/event/models/ConnectionType;", "getOsName", "getViewportWidthAndHeight", "", "hasTrackingHeader", "isBlacklistedURL", "isHeaderToCapture", "isLibraryCallBoolean", "redactQueryParams", "runtime_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class ConstantsAndUtil {
    @NotNull
    public static final ConstantsAndUtil INSTANCE = new ConstantsAndUtil();
    @NotNull
    public static final String EMPTY_STR = "";
    @NotNull
    public static final String TRACKING_HEADER_KEY = "X-INSTANA-ANDROID";
    @NotNull
    private static final Lazy runtime$delegate = LazyKt.lazy((Function0)runtime.2.INSTANCE);
    @NotNull
    private static final Lazy client$delegate = LazyKt.lazy((Function0)client.2.INSTANCE);

    private ConstantsAndUtil() {
    }

    @NotNull
    public final Runtime getRuntime() {
        Lazy lazy = runtime$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-runtime>(...)");
        return (Runtime)object;
    }

    @NotNull
    public final OkHttpClient getClient() {
        Lazy lazy = client$delegate;
        return (OkHttpClient)lazy.getValue();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final String getOsName() {
        String string;
        if (Build.VERSION.SDK_INT >= 23) {
            String string2 = Build.VERSION.BASE_OS;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"BASE_OS");
            if (!StringsKt.isBlank((CharSequence)string2)) {
                string2 = Build.VERSION.BASE_OS;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            Build.VERSION.BASE_OS\n        }");
                string = string2;
                return string;
            }
        }
        string = Platform.ANDROID.getInternalType();
        return string;
    }

    @Nullable
    public final ConnectionType getConnectionType(@NotNull Context context, @NotNull ConnectivityManager cm) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cm, (String)"cm");
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_NETWORK_STATE") != 0) {
            Logger.w("Missing permission 'ACCESS_NETWORK_STATE'. Instana Agent won't be able to detect connection type");
            return null;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            Network network = cm.getActiveNetwork();
            try {
                NetworkCapabilities capabilities = cm.getNetworkCapabilities(network);
                if (capabilities != null) {
                    return capabilities.hasTransport(3) ? ConnectionType.ETHERNET : (capabilities.hasTransport(1) ? ConnectionType.WIFI : (capabilities.hasTransport(0) ? ConnectionType.CELLULAR : null));
                }
            }
            catch (SecurityException e) {
                Logger.w("Failed to detect connection type", e);
            }
        } else {
            NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
            if (activeNetwork != null) {
                ConnectionType connectionType;
                switch (activeNetwork.getType()) {
                    case 9: {
                        connectionType = ConnectionType.ETHERNET;
                        break;
                    }
                    case 1: {
                        connectionType = ConnectionType.WIFI;
                        break;
                    }
                    case 0: {
                        connectionType = ConnectionType.CELLULAR;
                        break;
                    }
                    default: {
                        connectionType = null;
                    }
                }
                return connectionType;
            }
        }
        return null;
    }

    @Nullable
    public final String getCarrierName(@NotNull Context context, @NotNull ConnectivityManager cm, @NotNull TelephonyManager tm) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cm, (String)"cm");
        Intrinsics.checkNotNullParameter((Object)tm, (String)"tm");
        ConnectionType connectionType = this.getConnectionType(context, cm);
        return (connectionType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[connectionType.ordinal()]) == 1 ? tm.getNetworkOperatorName() : null;
    }

    @Nullable
    public final EffectiveConnectionType getCellularConnectionType(@NotNull Context context, @NotNull ConnectivityManager cm, @NotNull TelephonyManager tm) {
        EffectiveConnectionType effectiveConnectionType;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cm, (String)"cm");
        Intrinsics.checkNotNullParameter((Object)tm, (String)"tm");
        if (this.getConnectionType(context, cm) != ConnectionType.CELLULAR) {
            return null;
        }
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            Logger.w("Missing permission 'READ_PHONE_STATE'. Instana Agent won't be able to detect cellular network type");
            return null;
        }
        int networkType = Build.VERSION.SDK_INT >= 24 ? tm.getDataNetworkType() : tm.getNetworkType();
        switch (networkType) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                effectiveConnectionType = EffectiveConnectionType.TYPE_2G;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                effectiveConnectionType = EffectiveConnectionType.TYPE_3G;
                break;
            }
            case 13: {
                effectiveConnectionType = EffectiveConnectionType.TYPE_4G;
                break;
            }
            default: {
                effectiveConnectionType = null;
            }
        }
        return effectiveConnectionType;
    }

    @NotNull
    public final Pair<String, String> getAppVersionNameAndVersionCode(@NotNull Application app) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        String versionCode = null;
        String version = null;
        try {
            PackageInfo packageInfo = app.getPackageManager().getPackageInfo(app.getPackageName(), 0);
            version = packageInfo.versionName;
            versionCode = Build.VERSION.SDK_INT >= 28 ? String.valueOf(packageInfo.getLongVersionCode()) : String.valueOf(packageInfo.versionCode);
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.e("Failed to detect app versionName and versionCode", e);
            return new Pair((Object)EMPTY_STR, (Object)EMPTY_STR);
        }
        String string = version;
        if (string == null) {
            string = EMPTY_STR;
        }
        return new Pair((Object)string, (Object)versionCode);
    }

    public final boolean hasTrackingHeader(@Nullable String header) {
        return header != null;
    }

    public final boolean checkTag(@Nullable String header) {
        boolean bl;
        if (header != null) {
            boolean bl2;
            InstrumentationService instrumentationService = Instana.INSTANCE.getInstrumentationService$runtime_release();
            bl = instrumentationService == null ? false : (bl2 = instrumentationService.hasTag(header));
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final Pair<Integer, Integer> getViewportWidthAndHeight(@NotNull Application app) {
        Pair pair;
        Display display;
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Object object = app.getSystemService("window");
        WindowManager windowManager = object instanceof WindowManager ? (WindowManager)object : null;
        Object object2 = display = windowManager == null ? null : windowManager.getDefaultDisplay();
        if (Build.VERSION.SDK_INT >= 17) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            Display display2 = display;
            if (display2 != null) {
                display2.getRealMetrics(displayMetrics);
            }
            pair = TuplesKt.to((Object)displayMetrics.widthPixels, (Object)displayMetrics.heightPixels);
        } else {
            Display display3 = display;
            Display display4 = display;
            pair = TuplesKt.to((Object)(display3 == null ? null : Integer.valueOf(display3.getWidth())), (Object)(display4 == null ? null : Integer.valueOf(display4.getHeight())));
        }
        return pair;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isLibraryCallBoolean(@Nullable String url) {
        String string;
        String string2;
        String string3 = url;
        if (string3 == null) {
            return true;
        }
        String it = string3;
        boolean bl = false;
        CharSequence charSequence = it;
        InstanaConfig instanaConfig = Instana.getConfig();
        if (instanaConfig == null) {
            string2 = EMPTY_STR;
        } else {
            string2 = instanaConfig.getReportingURLWithPort$runtime_release();
            if (string2 == null) {
                string2 = EMPTY_STR;
            }
        }
        if (StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string2, (boolean)false, (int)2, null)) return true;
        CharSequence charSequence2 = it;
        InstanaConfig instanaConfig2 = Instana.getConfig();
        if (instanaConfig2 == null) {
            string = EMPTY_STR;
        } else {
            string = instanaConfig2.getReportingURLWithoutPort$runtime_release();
            if (string == null) {
                string = EMPTY_STR;
            }
        }
        if (!StringsKt.contains$default((CharSequence)charSequence2, (CharSequence)string, (boolean)false, (int)2, null)) return false;
        return true;
    }

    public final boolean isAutoEnabled() {
        InstanaConfig instanaConfig = Instana.getConfig();
        return (instanaConfig == null ? null : instanaConfig.getHttpCaptureConfig()) == HTTPCaptureConfig.AUTO;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isBlacklistedURL(@NotNull String url) {
        boolean bl;
        void $this$mapTo$iv$iv;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Iterable $this$any$iv = Instana.INSTANCE.getInternalURLs$runtime_release();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl2 = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                Regex it = (Regex)element$iv;
                boolean bl3 = false;
                if (!it.matches((CharSequence)url)) continue;
                return true;
            }
            bl2 = false;
        }
        if (bl2) return true;
        Iterable $this$map$iv = Instana.getIgnoreURLs();
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pattern pattern = (Pattern)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            collection.add(new Regex((Pattern)it));
        }
        $this$any$iv = (List)destination$iv$iv;
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        iterator = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator.hasNext()) return false;
            element$iv = iterator.next();
            Regex it = (Regex)element$iv;
            boolean bl5 = false;
            if (it.matches((CharSequence)url)) return true;
            if (it.matches((CharSequence)StringExtensionsKt.removeTrailing(url, "/"))) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final boolean isHeaderToCapture(String header) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = Instana.getCaptureHeaders();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Pattern it = (Pattern)element$iv;
                    boolean bl2 = false;
                    if (!new Regex(it).matches((CharSequence)header)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> getCapturedRequestHeaders$runtime_release(@NotNull Map<String, String> headers) {
        String headerName;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Iterable $this$filter$iv = headers.keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            headerName = (String)element$iv$iv;
            boolean bl = false;
            if (!INSTANCE.isHeaderToCapture(headerName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associateWith$iv = (List)destination$iv$iv;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            headerName = (String)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            String string = headers.get(headerName);
            map.put(t, string);
        }
        Map $this$filterValues$iv = result$iv;
        boolean $i$f$filterValues = false;
        result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            String value = (String)entry$iv.getValue();
            boolean bl = false;
            if (!(value != null)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> getCapturedResponseHeaders$runtime_release(@NotNull Map<String, String> headers) {
        String headerName;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Iterable $this$filter$iv = headers.keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            headerName = (String)element$iv$iv;
            boolean bl = false;
            if (!INSTANCE.isHeaderToCapture(headerName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associateWith$iv = (List)destination$iv$iv;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            headerName = (String)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            String string = headers.get(headerName);
            map.put(t, string);
        }
        Map $this$filterValues$iv = result$iv;
        boolean $i$f$filterValues = false;
        result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            String value = (String)entry$iv.getValue();
            boolean bl = false;
            if (!(value != null)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String redactQueryParams(@NotNull String url) {
        String string;
        List list;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (Instana.getRedactHTTPQuery().size() > 0) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = Instana.getRedactHTTPQuery();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pattern pattern = (Pattern)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Regex((Pattern)it));
            }
            list = (List)destination$iv$iv;
        } else {
            InstanaConfig instanaConfig = Instana.getConfig();
            list = instanaConfig == null ? null : instanaConfig.getDefaultRedactedQueryParams$runtime_release();
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
        }
        List regexList = list;
        InstanaConfig instanaConfig = Instana.getConfig();
        if (instanaConfig == null) {
            string = EMPTY_STR;
        } else {
            string = instanaConfig.getDefaultRedactedQueryParamValue$runtime_release();
            if (string == null) {
                string = EMPTY_STR;
            }
        }
        return URLUtils.Companion.redactURLQueryParams(url, string, regexList);
    }

    @NotNull
    public final String forceRedundantURLPort$runtime_release(@NotNull String url) {
        String string;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            URL originalURL = new URL(url);
            int newPort = originalURL.getPort() != -1 ? originalURL.getPort() : originalURL.getDefaultPort();
            string = new URL(originalURL.getProtocol(), originalURL.getHost(), newPort, originalURL.getFile()).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n            val origin\u2026ile).toString()\n        }");
        }
        catch (MalformedURLException e) {
            Logger.w(Intrinsics.stringPlus((String)"URL seems malformed: ", (Object)url));
            Logger.w(e.toString());
            string = url;
        }
        return string;
    }

    @NotNull
    public final String forceNoRedundantURLPort$runtime_release(@NotNull String url) {
        String string;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            URL originalURL = new URL(url);
            boolean isPortRedundant = originalURL.getPort() == originalURL.getDefaultPort();
            string = isPortRedundant ? new URL(originalURL.getProtocol(), originalURL.getHost(), originalURL.getFile()).toString() : url;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n            val origin\u2026l\n            }\n        }");
        }
        catch (MalformedURLException e) {
            Logger.w(Intrinsics.stringPlus((String)"URL seems malformed: ", (Object)url));
            Logger.w(e.toString());
            string = url;
        }
        return string;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConnectionType.values().length];
            nArray[ConnectionType.CELLULAR.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

