/*
 * Decompiled with CFR 0.152.
 */
package com.instana.android.core.event.models;

import androidx.annotation.IntRange;
import androidx.annotation.Size;
import androidx.annotation.VisibleForTesting;
import com.instana.android.core.event.models.AppProfile;
import com.instana.android.core.event.models.BeaconType;
import com.instana.android.core.event.models.ConnectionProfile;
import com.instana.android.core.event.models.ConnectionType;
import com.instana.android.core.event.models.DeviceProfile;
import com.instana.android.core.event.models.EffectiveConnectionType;
import com.instana.android.core.event.models.Platform;
import com.instana.android.core.event.models.UserProfile;
import com.instana.android.core.util.Logger;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 \\2\u00020\u0001:\u0001\\BO\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0007J\r\u0010\u001b\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001e\u001a\u00020\u0007J\r\u0010\u001f\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010\u001cJ\b\u0010 \u001a\u0004\u0018\u00010\u0007J\u0010\u0010!\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u0010$\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u0010%\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u0010&\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u0010'\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u0010(\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0005J\u0010\u0010)\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u0010*\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u0010+\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u000e\u0010,\u001a\u00020\"2\u0006\u0010#\u001a\u00020-J\u0010\u0010.\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u0010/\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0005J\u0010\u00100\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u00101\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u00102\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u00103\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0005J\u000e\u00104\u001a\u00020\"2\u0006\u0010#\u001a\u000205J\u0010\u00106\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0005J\u0010\u00107\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0005J\u0012\u00108\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007H\u0002J\u0010\u00109\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u0010:\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u000e\u0010;\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0015J\u001a\u0010<\u001a\u00020\"2\b\b\u0001\u0010\u001e\u001a\u00020\u00072\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u0010=\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u0010>\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0017J\u0010\u0010?\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u001a\u0010@\u001a\u00020\"2\b\b\u0001\u0010\u001e\u001a\u00020\u00072\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u0010A\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u0010B\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u0010C\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u000e\u0010D\u001a\u00020\"2\u0006\u0010#\u001a\u00020EJ\u000e\u0010F\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0015J\u0010\u0010G\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u0010H\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u0010I\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0005J\u0010\u0010J\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0005J\u000e\u0010K\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0003J\u0010\u0010L\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u0010M\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0016\u0010N\u001a\u00020\"2\u000e\b\u0001\u0010#\u001a\b\u0012\u0004\u0012\u00020P0OJ\u0010\u0010Q\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u0010R\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u0010S\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0017J\u0010\u0010T\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0017J\b\u0010U\u001a\u00020\u0007H\u0016J\f\u0010V\u001a\u00020\u0007*\u00020PH\u0003J\f\u0010W\u001a\u00020\u0007*\u00020\u0007H\u0003J\f\u0010X\u001a\u00020\u0007*\u00020\u0007H\u0003J\u001c\u0010Y\u001a\u00020\u0007*\u00020\u00072\u0006\u0010Z\u001a\u00020\u00172\u0006\u0010[\u001a\u00020\u0007H\u0002R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00170\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006]"}, d2={"Lcom/instana/android/core/event/models/Beacon;", "", "type", "Lcom/instana/android/core/event/models/BeaconType;", "duration", "", "mobileAppId", "", "sessionId", "errorCount", "appProfile", "Lcom/instana/android/core/event/models/AppProfile;", "deviceProfile", "Lcom/instana/android/core/event/models/DeviceProfile;", "connectionProfile", "Lcom/instana/android/core/event/models/ConnectionProfile;", "userProfile", "Lcom/instana/android/core/event/models/UserProfile;", "(Lcom/instana/android/core/event/models/BeaconType;JLjava/lang/String;Ljava/lang/String;JLcom/instana/android/core/event/models/AppProfile;Lcom/instana/android/core/event/models/DeviceProfile;Lcom/instana/android/core/event/models/ConnectionProfile;Lcom/instana/android/core/event/models/UserProfile;)V", "booleanMap", "", "", "intMap", "", "longMap", "stringMap", "getBeaconId", "getGooglePlayServicesMissing", "()Ljava/lang/Boolean;", "getMeta", "key", "getRooted", "getView", "setAgentVersion", "", "value", "setAllStackTraces", "setAppBuild", "setAppVersion", "setBackendTraceId", "setBatchSize", "setBeaconId", "setBundleIdentifier", "setCarrier", "setConnectionType", "Lcom/instana/android/core/event/models/ConnectionType;", "setCustomEventName", "setDecodedBodySize", "setDeviceHardware", "setDeviceManufacturer", "setDeviceModel", "setDuration", "setEffectiveConnectionType", "Lcom/instana/android/core/event/models/EffectiveConnectionType;", "setEncodedBodySize", "setErrorCount", "setErrorId", "setErrorMessage", "setErrorType", "setGooglePlayServicesMissing", "setHttpCallHeaders", "setHttpCallMethod", "setHttpCallStatus", "setHttpCallUrl", "setMeta", "setMobileAppId", "setOsName", "setOsVersion", "setPlatform", "Lcom/instana/android/core/event/models/Platform;", "setRooted", "setSessionId", "setStackTrace", "setTimestamp", "setTransferSize", "setType", "setUserEmail", "setUserId", "setUserLanguages", "", "Ljava/util/Locale;", "setUserName", "setView", "setViewportHeight", "setViewportWidth", "toString", "bcp47", "escape", "md5", "truncate", "maxLength", "humanReadableDescription", "Companion", "runtime_release"})
public final class Beacon {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Integer> intMap = new LinkedHashMap();
    @NotNull
    private final Map<String, Long> longMap = new LinkedHashMap();
    @NotNull
    private final Map<String, String> stringMap = new LinkedHashMap();
    @NotNull
    private final Map<String, Boolean> booleanMap = new LinkedHashMap();

    private Beacon(BeaconType type, long duration, String mobileAppId, String sessionId, long errorCount, AppProfile appProfile, DeviceProfile deviceProfile, ConnectionProfile connectionProfile, UserProfile userProfile) {
        this.setAgentVersion("6.0.0");
        String string = appProfile.getAppVersion();
        if (string != null) {
            String $this$_init__u24lambda_u2d0 = string;
            boolean bl = false;
            this.setAppVersion($this$_init__u24lambda_u2d0);
        }
        String string2 = appProfile.getAppBuild();
        if (string2 != null) {
            String $this$_init__u24lambda_u2d1 = string2;
            boolean bl = false;
            this.setAppBuild($this$_init__u24lambda_u2d1);
        }
        String string3 = appProfile.getAppId();
        if (string3 != null) {
            String $this$_init__u24lambda_u2d2 = string3;
            boolean bl = false;
            this.setBundleIdentifier($this$_init__u24lambda_u2d2);
        }
        Platform platform = deviceProfile.getPlatform();
        if (platform != null) {
            Platform $this$_init__u24lambda_u2d3 = platform;
            boolean bl = false;
            this.setPlatform($this$_init__u24lambda_u2d3);
        }
        String string4 = deviceProfile.getOsName();
        if (string4 != null) {
            String $this$_init__u24lambda_u2d4 = string4;
            boolean bl = false;
            this.setOsName($this$_init__u24lambda_u2d4);
        }
        String string5 = deviceProfile.getOsVersion();
        if (string5 != null) {
            String $this$_init__u24lambda_u2d5 = string5;
            boolean bl = false;
            this.setOsVersion($this$_init__u24lambda_u2d5);
        }
        String string6 = deviceProfile.getDeviceManufacturer();
        if (string6 != null) {
            String $this$_init__u24lambda_u2d6 = string6;
            boolean bl = false;
            this.setDeviceManufacturer($this$_init__u24lambda_u2d6);
        }
        String string7 = deviceProfile.getDeviceModel();
        if (string7 != null) {
            String $this$_init__u24lambda_u2d7 = string7;
            boolean bl = false;
            this.setDeviceModel($this$_init__u24lambda_u2d7);
        }
        String string8 = deviceProfile.getDeviceHardware();
        if (string8 != null) {
            String $this$_init__u24lambda_u2d8 = string8;
            boolean bl = false;
            this.setDeviceHardware($this$_init__u24lambda_u2d8);
        }
        Boolean bl = deviceProfile.getGooglePlayServicesMissing();
        if (bl != null) {
            boolean $this$_init__u24lambda_u2d9 = bl;
            boolean bl2 = false;
            this.setGooglePlayServicesMissing($this$_init__u24lambda_u2d9);
        }
        List $this$_init__u24lambda_u2d10 = CollectionsKt.listOfNotNull((Object)deviceProfile.getLocale());
        boolean bl3 = false;
        this.setUserLanguages($this$_init__u24lambda_u2d10);
        Boolean bl4 = deviceProfile.getRooted();
        if (bl4 != null) {
            boolean $this$_init__u24lambda_u2d11 = bl4;
            boolean bl5 = false;
            this.setRooted($this$_init__u24lambda_u2d11);
        }
        Integer n = deviceProfile.getViewportWidth();
        if (n != null) {
            int $this$_init__u24lambda_u2d12 = ((Number)n).intValue();
            boolean bl6 = false;
            this.setViewportWidth($this$_init__u24lambda_u2d12);
        }
        Integer n2 = deviceProfile.getViewportHeight();
        if (n2 != null) {
            int $this$_init__u24lambda_u2d13 = ((Number)n2).intValue();
            boolean bl7 = false;
            this.setViewportHeight($this$_init__u24lambda_u2d13);
        }
        String string9 = connectionProfile.getCarrierName();
        if (string9 != null) {
            String $this$_init__u24lambda_u2d14 = string9;
            boolean bl8 = false;
            this.setCarrier($this$_init__u24lambda_u2d14);
        }
        ConnectionType connectionType = connectionProfile.getConnectionType();
        if (connectionType != null) {
            ConnectionType $this$_init__u24lambda_u2d15 = connectionType;
            boolean bl9 = false;
            this.setConnectionType($this$_init__u24lambda_u2d15);
        }
        EffectiveConnectionType effectiveConnectionType = connectionProfile.getEffectiveConnectionType();
        if (effectiveConnectionType != null) {
            EffectiveConnectionType $this$_init__u24lambda_u2d16 = effectiveConnectionType;
            boolean bl10 = false;
            this.setEffectiveConnectionType($this$_init__u24lambda_u2d16);
        }
        String string10 = userProfile.getUserId();
        if (string10 != null) {
            String $this$_init__u24lambda_u2d17 = string10;
            boolean bl11 = false;
            this.setUserId($this$_init__u24lambda_u2d17);
        }
        String string11 = userProfile.getUserName();
        if (string11 != null) {
            String $this$_init__u24lambda_u2d18 = string11;
            boolean bl12 = false;
            this.setUserName($this$_init__u24lambda_u2d18);
        }
        String string12 = userProfile.getUserEmail();
        if (string12 != null) {
            String $this$_init__u24lambda_u2d19 = string12;
            boolean bl13 = false;
            this.setUserEmail($this$_init__u24lambda_u2d19);
        }
        this.setTimestamp(System.currentTimeMillis());
        String string13 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"randomUUID().toString()");
        this.setBeaconId(string13);
        this.setMobileAppId(mobileAppId);
        this.setSessionId(sessionId);
        this.setType(type);
        this.setDuration(duration);
        this.setErrorCount(errorCount);
    }

    public final void setAgentVersion(@Size(max=128L) @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.stringMap.put("agv", this.truncate(value, 128, "Agent Version"));
    }

    public final void setMobileAppId(@Size(min=1L, max=64L) @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.stringMap.put("k", this.truncate(value, 64, "Mobile App ID"));
    }

    public final void setTimestamp(@IntRange(from=1L) long value) {
        Map<String, Long> map = this.longMap;
        String string = "ti";
        Long l = value;
        map.put(string, l);
    }

    public final void setDuration(@IntRange(from=0L) long value) {
        Map<String, Long> map = this.longMap;
        String string = "d";
        Long l = value;
        map.put(string, l);
    }

    public final void setBatchSize(@IntRange(from=1L) long value) {
        Map<String, Long> map = this.longMap;
        String string = "bs";
        Long l = value;
        map.put(string, l);
    }

    public final void setSessionId(@Size(min=1L, max=128L) @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.stringMap.put("sid", this.truncate(value, 128, "Session ID"));
    }

    public final void setBeaconId(@Size(min=1L, max=128L) @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.stringMap.put("bid", this.truncate(value, 128, "Beacon ID"));
    }

    @Nullable
    public final String getBeaconId() {
        return this.stringMap.get("bid");
    }

    public final void setBackendTraceId(@Size(max=128L) @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.stringMap.put("bt", this.truncate(value, 128, "Backend Trace ID"));
    }

    public final void setType(@NotNull BeaconType value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.stringMap.put("t", value.getInternalType());
    }

    public final void setView(@Size(max=256L) @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.stringMap.put("v", this.truncate(value, 256, "View Name"));
    }

    @Nullable
    public final String getView() {
        return this.stringMap.get("v");
    }

    public final void setCustomEventName(@Size(max=256L) @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.stringMap.put("cen", this.truncate(value, 256, "Custom Event Name"));
    }

    public final void setMeta(@Size(max=98L) @NotNull String key, @Size(max=1024L) @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.stringMap.put(Intrinsics.stringPlus((String)"m_", (Object)this.truncate(key, 98, "Meta Key")), this.truncate(value, 1024, "Meta Value"));
    }

    @Nullable
    public final String getMeta(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.stringMap.get(Intrinsics.stringPlus((String)"m_", (Object)key));
    }

    public final void setUserId(@Size(max=128L) @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.stringMap.put("ui", this.truncate(value, 128, "User ID"));
    }

    public final void setUserName(@Size(max=128L) @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.stringMap.put("un", this.truncate(value, 128, "User Name"));
    }

    public final void setUserEmail(@Size(max=128L) @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.stringMap.put("ue", this.truncate(value, 128, "User Email"));
    }

    public final void setUserLanguages(@Size(max=5L) @NotNull List<Locale> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.stringMap.put("ul", CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)value, (int)5), (CharSequence)",", null, null, (int)0, null, (Function1)((Function1)new Function1<Locale, CharSequence>(this){
            final /* synthetic */ Beacon this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull Locale it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Beacon.access$bcp47(this.this$0, it);
            }
        }), (int)30, null));
    }

    public final void setBundleIdentifier(@Size(max=128L) @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.stringMap.put("bi", this.truncate(value, 128, "Bundle Identifier"));
    }

    public final void setAppBuild(@Size(max=128L) @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.stringMap.put("ab", this.truncate(value, 128, "App Build"));
    }

    public final void setAppVersion(@Size(max=128L) @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.stringMap.put("av", this.truncate(value, 128, "App Version"));
    }

    public final void setPlatform(@NotNull Platform value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.stringMap.put("p", value.getInternalType());
    }

    public final void setOsName(@Size(max=128L) @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.stringMap.put("osn", this.truncate(value, 128, "OS Name"));
    }

    public final void setOsVersion(@Size(max=128L) @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.stringMap.put("osv", this.truncate(value, 128, "OS Version"));
    }

    public final void setDeviceManufacturer(@Size(max=128L) @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.stringMap.put("dma", this.truncate(value, 128, "Device Manufacturer"));
    }

    public final void setDeviceModel(@Size(max=128L) @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.stringMap.put("dmo", this.truncate(value, 128, "Device Model"));
    }

    public final void setDeviceHardware(@Size(max=128L) @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.stringMap.put("dh", this.truncate(value, 128, "Device Hardware"));
    }

    public final void setRooted(boolean value) {
        Map<String, Boolean> map = this.booleanMap;
        String string = "ro";
        Boolean bl = value;
        map.put(string, bl);
    }

    @Nullable
    public final Boolean getRooted() {
        return this.booleanMap.get("ro");
    }

    public final void setGooglePlayServicesMissing(boolean value) {
        Map<String, Boolean> map = this.booleanMap;
        String string = "gpsm";
        Boolean bl = value;
        map.put(string, bl);
    }

    @Nullable
    public final Boolean getGooglePlayServicesMissing() {
        return this.booleanMap.get("gpsm");
    }

    public final void setViewportWidth(@IntRange(from=1L) int value) {
        Map<String, Integer> map = this.intMap;
        String string = "vw";
        Integer n = value;
        map.put(string, n);
    }

    public final void setViewportHeight(@IntRange(from=1L) int value) {
        Map<String, Integer> map = this.intMap;
        String string = "vh";
        Integer n = value;
        map.put(string, n);
    }

    public final void setCarrier(@Size(max=256L) @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.stringMap.put("cn", this.truncate(value, 256, "Carrier Name"));
    }

    public final void setConnectionType(@NotNull ConnectionType value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.stringMap.put("ct", value.getInternalType());
    }

    public final void setEffectiveConnectionType(@NotNull EffectiveConnectionType value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.stringMap.put("ect", value.getInternalType());
    }

    public final void setHttpCallUrl(@Size(max=4096L) @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.stringMap.put("hu", this.truncate(value, 4096, "HTTP call URL"));
    }

    public final void setHttpCallMethod(@Size(max=16L) @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.stringMap.put("hm", this.truncate(value, 16, "HTTP call METHOD"));
    }

    public final void setHttpCallStatus(@IntRange(from=-1L, to=599L) int value) {
        Map<String, Integer> map = this.intMap;
        String string = "hs";
        Integer n = value;
        map.put(string, n);
    }

    public final void setHttpCallHeaders(@Size(max=98L) @NotNull String key, @Size(max=1024L) @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.stringMap.put(Intrinsics.stringPlus((String)"h_", (Object)this.truncate(key, 98, "Header Key")), this.truncate(value, 1024, "Header Value"));
    }

    public final void setEncodedBodySize(@IntRange(from=-1L) long value) {
        Map<String, Long> map = this.longMap;
        String string = "ebs";
        Long l = value;
        map.put(string, l);
    }

    public final void setDecodedBodySize(@IntRange(from=-1L) long value) {
        Map<String, Long> map = this.longMap;
        String string = "dbs";
        Long l = value;
        map.put(string, l);
    }

    public final void setTransferSize(@IntRange(from=-1L) long value) {
        Map<String, Long> map = this.longMap;
        String string = "trs";
        Long l = value;
        map.put(string, l);
    }

    public final void setErrorCount(@IntRange(from=0L) long value) {
        Map<String, Long> map = this.longMap;
        String string = "ec";
        Long l = value;
        map.put(string, l);
    }

    public final void setErrorMessage(@Size(max=16384L) @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String it = this.truncate(value, 16384, "Error Message");
        boolean bl = false;
        Map<String, String> map = this.stringMap;
        String string = "em";
        map.put(string, it);
        this.setErrorId(this.md5(it));
    }

    private final void setErrorId(@Size(max=128L) String value) {
        this.stringMap.put("ei", this.truncate(value, 128, "Error ID"));
    }

    public final void setErrorType(@Size(max=1024L) @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.stringMap.put("et", this.truncate(value, 1024, "Error Type"));
    }

    public final void setStackTrace(@Size(max=16384L) @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.stringMap.put("st", this.truncate(value, 16384, "StackTrace"));
    }

    public final void setAllStackTraces(@Size(max=0x500000L) @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.stringMap.put("ast", this.truncate(value, 0x500000, "AllStackTraces"));
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Boolean> entry : this.booleanMap.entrySet()) {
            sb.append(entry.getKey()).append("\t").append(entry.getValue()).append("\n");
        }
        for (Map.Entry<String, Comparable<Boolean>> entry : this.intMap.entrySet()) {
            sb.append(entry.getKey()).append("\t").append(((Number)((Object)entry.getValue())).intValue()).append("\n");
        }
        for (Map.Entry<String, Comparable<Boolean>> entry : this.longMap.entrySet()) {
            sb.append(entry.getKey()).append("\t").append(((Number)((Object)entry.getValue())).longValue()).append("\n");
        }
        for (Map.Entry<String, Object> entry : this.stringMap.entrySet()) {
            sb.append(entry.getKey()).append("\t").append(this.escape((String)entry.getValue())).append("\n");
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    private final String truncate(String $this$truncate, int maxLength, String humanReadableDescription) {
        if ($this$truncate.length() > maxLength) {
            Logger.e(humanReadableDescription + " cannot be longer than " + maxLength + " characters. Provided value will be truncated to allowed max length: '" + $this$truncate + '\'');
        }
        return StringsKt.take((String)$this$truncate, (int)maxLength);
    }

    @VisibleForTesting
    private final String bcp47(Locale $this$bcp47) {
        return $this$bcp47.getLanguage() + '-' + $this$bcp47.getCountry();
    }

    @VisibleForTesting
    private final String md5(String $this$md5) {
        MessageDigest md = MessageDigest.getInstance("MD5");
        String string = $this$md5;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        String string2 = new BigInteger(1, md.digest(byArray)).toString(16);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"BigInteger(1, md.digest(\u2026yteArray())).toString(16)");
        return StringsKt.padStart((String)string2, (int)32, (char)'0');
    }

    @VisibleForTesting
    private final String escape(String $this$escape) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)$this$escape, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null), (String)"\n", (String)"\\n", (boolean)false, (int)4, null), (String)"\t", (String)"\\t", (boolean)false, (int)4, null);
    }

    public static final /* synthetic */ String access$bcp47(Beacon $this, Locale $receiver) {
        return $this.bcp47($receiver);
    }

    public /* synthetic */ Beacon(BeaconType type, long duration, String mobileAppId, String sessionId, long errorCount, AppProfile appProfile, DeviceProfile deviceProfile, ConnectionProfile connectionProfile, UserProfile userProfile, DefaultConstructorMarker $constructor_marker) {
        this(type, duration, mobileAppId, sessionId, errorCount, appProfile, deviceProfile, connectionProfile, userProfile);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jr\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u0006J\u0080\u0001\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001b\u001a\u00020\u0006J\u00c3\u0001\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00122\u0006\u0010\u0019\u001a\u00020\u00182\b\u0010\u001d\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001e\u001a\u00020\u00062\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00122\b\u0010\u001a\u001a\u0004\u0018\u00010\u00062\b\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010\u00182\b\u0010#\u001a\u0004\u0018\u00010\u00182\b\u0010$\u001a\u0004\u0018\u00010\u00182\b\u0010\u0013\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010%JT\u0010&\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0012JR\u0010'\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0012\u00a8\u0006("}, d2={"Lcom/instana/android/core/event/models/Beacon$Companion;", "", "()V", "newCrash", "Lcom/instana/android/core/event/models/Beacon;", "appKey", "", "appProfile", "Lcom/instana/android/core/event/models/AppProfile;", "deviceProfile", "Lcom/instana/android/core/event/models/DeviceProfile;", "connectionProfile", "Lcom/instana/android/core/event/models/ConnectionProfile;", "userProfile", "Lcom/instana/android/core/event/models/UserProfile;", "sessionId", "view", "meta", "", "error", "stackTrace", "allStackTraces", "newCustomEvent", "startTime", "", "duration", "backendTraceId", "name", "newHttpRequest", "method", "url", "headers", "responseCode", "", "requestSizeBytes", "encodedResponseSizeBytes", "decodedResponseSizeBytes", "(Ljava/lang/String;Lcom/instana/android/core/event/models/AppProfile;Lcom/instana/android/core/event/models/DeviceProfile;Lcom/instana/android/core/event/models/ConnectionProfile;Lcom/instana/android/core/event/models/UserProfile;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;JLjava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/String;)Lcom/instana/android/core/event/models/Beacon;", "newSessionStart", "newViewChange", "runtime_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Beacon newSessionStart(@NotNull String appKey, @NotNull AppProfile appProfile, @NotNull DeviceProfile deviceProfile, @NotNull ConnectionProfile connectionProfile, @NotNull UserProfile userProfile, @NotNull String sessionId, @Nullable String view, @NotNull Map<String, String> meta) {
            Beacon beacon;
            Intrinsics.checkNotNullParameter((Object)appKey, (String)"appKey");
            Intrinsics.checkNotNullParameter((Object)appProfile, (String)"appProfile");
            Intrinsics.checkNotNullParameter((Object)deviceProfile, (String)"deviceProfile");
            Intrinsics.checkNotNullParameter((Object)connectionProfile, (String)"connectionProfile");
            Intrinsics.checkNotNullParameter((Object)userProfile, (String)"userProfile");
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            Intrinsics.checkNotNullParameter(meta, (String)"meta");
            Beacon $this$newSessionStart_u24lambda_u2d1 = beacon = new Beacon(BeaconType.SESSION_START, 0L, appKey, sessionId, 0L, appProfile, deviceProfile, connectionProfile, userProfile, null);
            boolean bl = false;
            String string = view;
            if (string != null) {
                String $this$newSessionStart_u24lambda_u2d1_u24lambda_u2d0 = string;
                boolean bl2 = false;
                $this$newSessionStart_u24lambda_u2d1.setView($this$newSessionStart_u24lambda_u2d1_u24lambda_u2d0);
            }
            for (Map.Entry<String, String> it : meta.entrySet()) {
                $this$newSessionStart_u24lambda_u2d1.setMeta(it.getKey(), it.getValue());
            }
            return beacon;
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final Beacon newHttpRequest(@NotNull String appKey, @NotNull AppProfile appProfile, @NotNull DeviceProfile deviceProfile, @NotNull ConnectionProfile connectionProfile, @NotNull UserProfile userProfile, @NotNull String sessionId, @Nullable String view, @NotNull Map<String, String> meta, long duration, @Nullable String method, @NotNull String url, @NotNull Map<String, String> headers, @Nullable String backendTraceId, @Nullable Integer responseCode, @Nullable Long requestSizeBytes, @Nullable Long encodedResponseSizeBytes, @Nullable Long decodedResponseSizeBytes, @Nullable String error) {
            Intrinsics.checkNotNullParameter((Object)appKey, (String)"appKey");
            Intrinsics.checkNotNullParameter((Object)appProfile, (String)"appProfile");
            Intrinsics.checkNotNullParameter((Object)deviceProfile, (String)"deviceProfile");
            Intrinsics.checkNotNullParameter((Object)connectionProfile, (String)"connectionProfile");
            Intrinsics.checkNotNullParameter((Object)userProfile, (String)"userProfile");
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            Intrinsics.checkNotNullParameter(meta, (String)"meta");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            if (error != null) ** GOTO lbl-1000
            var22_19 = new kotlin.ranges.IntRange(400, 599);
            if (responseCode != null && var22_19.contains(responseCode.intValue()) != false) lbl-1000:
            // 2 sources

            {
                v0 = 1L;
            } else {
                v0 = 0L;
            }
            errorCount = v0;
            $this$newHttpRequest_u24lambda_u2d9 = var22_19 = new Beacon(BeaconType.HTTP_REQUEST, duration, appKey, sessionId, errorCount, appProfile, deviceProfile, connectionProfile, userProfile, null);
            $i$a$-apply-Beacon$Companion$newHttpRequest$1 = false;
            v1 = view;
            if (v1 != null) {
                $this$newHttpRequest_u24lambda_u2d9_u24lambda_u2d2 = v1;
                $i$a$-run-Beacon$Companion$newHttpRequest$1$1 = false;
                $this$newHttpRequest_u24lambda_u2d9.setView($this$newHttpRequest_u24lambda_u2d9_u24lambda_u2d2);
            }
            for (Map.Entry<String, String> it : meta.entrySet()) {
                $this$newHttpRequest_u24lambda_u2d9.setMeta(it.getKey(), it.getValue());
            }
            v2 = method;
            if (v2 != null) {
                $this$newHttpRequest_u24lambda_u2d9_u24lambda_u2d3 = v2;
                $i$a$-run-Beacon$Companion$newHttpRequest$1$2 = false;
                $this$newHttpRequest_u24lambda_u2d9.setHttpCallMethod($this$newHttpRequest_u24lambda_u2d9_u24lambda_u2d3);
            }
            $this$newHttpRequest_u24lambda_u2d9.setHttpCallUrl(url);
            for (Map.Entry<String, String> it : headers.entrySet()) {
                $this$newHttpRequest_u24lambda_u2d9.setHttpCallHeaders(it.getKey(), it.getValue());
            }
            v3 = responseCode;
            if (v3 != null) {
                $this$newHttpRequest_u24lambda_u2d9_u24lambda_u2d4 = ((Number)v3).intValue();
                $i$a$-run-Beacon$Companion$newHttpRequest$1$3 = false;
                $this$newHttpRequest_u24lambda_u2d9.setHttpCallStatus($this$newHttpRequest_u24lambda_u2d9_u24lambda_u2d4);
            }
            v4 = encodedResponseSizeBytes;
            if (v4 != null) {
                $this$newHttpRequest_u24lambda_u2d9_u24lambda_u2d5 = ((Number)v4).longValue();
                $i$a$-run-Beacon$Companion$newHttpRequest$1$4 = false;
                $this$newHttpRequest_u24lambda_u2d9.setEncodedBodySize($this$newHttpRequest_u24lambda_u2d9_u24lambda_u2d5);
            }
            v5 = decodedResponseSizeBytes;
            if (v5 != null) {
                $this$newHttpRequest_u24lambda_u2d9_u24lambda_u2d6 = ((Number)v5).longValue();
                $i$a$-run-Beacon$Companion$newHttpRequest$1$5 = false;
                $this$newHttpRequest_u24lambda_u2d9.setDecodedBodySize($this$newHttpRequest_u24lambda_u2d9_u24lambda_u2d6);
            }
            v6 = backendTraceId;
            if (v6 != null) {
                $this$newHttpRequest_u24lambda_u2d9_u24lambda_u2d7 = v6;
                $i$a$-run-Beacon$Companion$newHttpRequest$1$6 = false;
                $this$newHttpRequest_u24lambda_u2d9.setBackendTraceId(backendTraceId);
            }
            v7 = error;
            if (v7 != null) {
                $this$newHttpRequest_u24lambda_u2d9_u24lambda_u2d8 = v7;
                $i$a$-run-Beacon$Companion$newHttpRequest$1$7 = false;
                $this$newHttpRequest_u24lambda_u2d9.setErrorMessage($this$newHttpRequest_u24lambda_u2d9_u24lambda_u2d8);
            }
            return var22_19;
        }

        @NotNull
        public final Beacon newViewChange(@NotNull String appKey, @NotNull AppProfile appProfile, @NotNull DeviceProfile deviceProfile, @NotNull ConnectionProfile connectionProfile, @NotNull UserProfile userProfile, @NotNull String sessionId, @NotNull String view, @NotNull Map<String, String> meta) {
            Beacon beacon;
            Intrinsics.checkNotNullParameter((Object)appKey, (String)"appKey");
            Intrinsics.checkNotNullParameter((Object)appProfile, (String)"appProfile");
            Intrinsics.checkNotNullParameter((Object)deviceProfile, (String)"deviceProfile");
            Intrinsics.checkNotNullParameter((Object)connectionProfile, (String)"connectionProfile");
            Intrinsics.checkNotNullParameter((Object)userProfile, (String)"userProfile");
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter(meta, (String)"meta");
            Beacon $this$newViewChange_u24lambda_u2d10 = beacon = new Beacon(BeaconType.VIEW_CHANGE, 0L, appKey, sessionId, 0L, appProfile, deviceProfile, connectionProfile, userProfile, null);
            boolean bl = false;
            $this$newViewChange_u24lambda_u2d10.setView(view);
            for (Map.Entry<String, String> it : meta.entrySet()) {
                $this$newViewChange_u24lambda_u2d10.setMeta(it.getKey(), it.getValue());
            }
            return beacon;
        }

        @NotNull
        public final Beacon newCustomEvent(@NotNull String appKey, @NotNull AppProfile appProfile, @NotNull DeviceProfile deviceProfile, @NotNull ConnectionProfile connectionProfile, @NotNull UserProfile userProfile, @NotNull String sessionId, @Nullable String view, @NotNull Map<String, String> meta, long startTime, long duration, @Nullable String backendTraceId, @Nullable String error, @NotNull String name) {
            Beacon beacon;
            Intrinsics.checkNotNullParameter((Object)appKey, (String)"appKey");
            Intrinsics.checkNotNullParameter((Object)appProfile, (String)"appProfile");
            Intrinsics.checkNotNullParameter((Object)deviceProfile, (String)"deviceProfile");
            Intrinsics.checkNotNullParameter((Object)connectionProfile, (String)"connectionProfile");
            Intrinsics.checkNotNullParameter((Object)userProfile, (String)"userProfile");
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            Intrinsics.checkNotNullParameter(meta, (String)"meta");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            long errorCount = error != null ? 1L : 0L;
            Beacon $this$newCustomEvent_u24lambda_u2d14 = beacon = new Beacon(BeaconType.CUSTOM, duration, appKey, sessionId, errorCount, appProfile, deviceProfile, connectionProfile, userProfile, null);
            boolean bl = false;
            String string = view;
            if (string != null) {
                String $this$newCustomEvent_u24lambda_u2d14_u24lambda_u2d11 = string;
                boolean bl2 = false;
                $this$newCustomEvent_u24lambda_u2d14.setView($this$newCustomEvent_u24lambda_u2d14_u24lambda_u2d11);
            }
            for (Map.Entry<String, String> it : meta.entrySet()) {
                $this$newCustomEvent_u24lambda_u2d14.setMeta(it.getKey(), it.getValue());
            }
            $this$newCustomEvent_u24lambda_u2d14.setCustomEventName(name);
            $this$newCustomEvent_u24lambda_u2d14.setTimestamp(startTime);
            String string2 = backendTraceId;
            if (string2 != null) {
                String $this$newCustomEvent_u24lambda_u2d14_u24lambda_u2d12 = string2;
                boolean bl3 = false;
                $this$newCustomEvent_u24lambda_u2d14.setBackendTraceId(backendTraceId);
            }
            String string3 = error;
            if (string3 != null) {
                String $this$newCustomEvent_u24lambda_u2d14_u24lambda_u2d13 = string3;
                boolean bl4 = false;
                $this$newCustomEvent_u24lambda_u2d14.setErrorMessage($this$newCustomEvent_u24lambda_u2d14_u24lambda_u2d13);
            }
            return beacon;
        }

        @NotNull
        public final Beacon newCrash(@NotNull String appKey, @NotNull AppProfile appProfile, @NotNull DeviceProfile deviceProfile, @NotNull ConnectionProfile connectionProfile, @NotNull UserProfile userProfile, @NotNull String sessionId, @Nullable String view, @NotNull Map<String, String> meta, @Nullable String error, @Nullable String stackTrace, @Nullable String allStackTraces) {
            Beacon beacon;
            Intrinsics.checkNotNullParameter((Object)appKey, (String)"appKey");
            Intrinsics.checkNotNullParameter((Object)appProfile, (String)"appProfile");
            Intrinsics.checkNotNullParameter((Object)deviceProfile, (String)"deviceProfile");
            Intrinsics.checkNotNullParameter((Object)connectionProfile, (String)"connectionProfile");
            Intrinsics.checkNotNullParameter((Object)userProfile, (String)"userProfile");
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            Intrinsics.checkNotNullParameter(meta, (String)"meta");
            Beacon $this$newCrash_u24lambda_u2d19 = beacon = new Beacon(BeaconType.CRASH, 0L, appKey, sessionId, 0L, appProfile, deviceProfile, connectionProfile, userProfile, null);
            boolean bl = false;
            String string = view;
            if (string != null) {
                String $this$newCrash_u24lambda_u2d19_u24lambda_u2d15 = string;
                boolean bl2 = false;
                $this$newCrash_u24lambda_u2d19.setView($this$newCrash_u24lambda_u2d19_u24lambda_u2d15);
            }
            for (Map.Entry<String, String> it : meta.entrySet()) {
                $this$newCrash_u24lambda_u2d19.setMeta(it.getKey(), it.getValue());
            }
            String string2 = error;
            if (string2 != null) {
                String $this$newCrash_u24lambda_u2d19_u24lambda_u2d16 = string2;
                boolean bl3 = false;
                $this$newCrash_u24lambda_u2d19.setErrorMessage($this$newCrash_u24lambda_u2d19_u24lambda_u2d16);
            }
            String string3 = stackTrace;
            if (string3 != null) {
                String $this$newCrash_u24lambda_u2d19_u24lambda_u2d17 = string3;
                boolean bl4 = false;
                $this$newCrash_u24lambda_u2d19.setStackTrace($this$newCrash_u24lambda_u2d19_u24lambda_u2d17);
            }
            String string4 = allStackTraces;
            if (string4 != null) {
                String $this$newCrash_u24lambda_u2d19_u24lambda_u2d18 = string4;
                boolean bl5 = false;
                $this$newCrash_u24lambda_u2d19.setAllStackTraces($this$newCrash_u24lambda_u2d19_u24lambda_u2d18);
            }
            return beacon;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

