/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.cache;

import androidx.annotation.Nullable;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.survey.cache.a;
import com.instabug.survey.models.Survey;
import java.util.Iterator;
import java.util.List;

public class SurveysCacheManager {
    public static final String SURVEYS_DISK_CACHE_FILE_NAME = "/surveys.cache";
    public static final String SURVEYS_DISK_CACHE_KEY = "surveys_disk_cache";
    public static final String SURVEYS_MEMORY_CACHE_KEY = "surveys_memory_cache";

    @Nullable
    public static InMemoryCache<Long, Survey> getCache() throws IllegalArgumentException {
        if (!CacheManager.getInstance().cacheExists(SURVEYS_MEMORY_CACHE_KEY)) {
            CacheManager.KeyExtractor<Long, Survey> keyExtractor;
            InstabugSDKLogger.d(SurveysCacheManager.class, (String)("In-memory Surveys cache not found, loading it from disk " + CacheManager.getInstance().getCache(SURVEYS_MEMORY_CACHE_KEY)));
            CacheManager.KeyExtractor<Long, Survey> keyExtractor2 = keyExtractor;
            keyExtractor = new CacheManager.KeyExtractor<Long, Survey>(){

                public Long a(Survey survey) {
                    return survey.getId();
                }
            };
            CacheManager.getInstance().migrateCache(SURVEYS_DISK_CACHE_KEY, SURVEYS_MEMORY_CACHE_KEY, (CacheManager.KeyExtractor)keyExtractor2);
            keyExtractor2 = CacheManager.getInstance().getCache(SURVEYS_MEMORY_CACHE_KEY);
            if (keyExtractor2 != null) {
                InstabugSDKLogger.d(SurveysCacheManager.class, (String)("In-memory Surveys cache restored from disk, " + keyExtractor2.size() + " elements restored"));
            }
        }
        InstabugSDKLogger.d(SurveysCacheManager.class, (String)"In-memory Surveys cache found");
        return (InMemoryCache)CacheManager.getInstance().getCache(SURVEYS_MEMORY_CACHE_KEY);
    }

    public static void migrateOldCacheToDb() {
        if (SurveysCacheManager.getCache() == null) {
            return;
        }
        List list = SurveysCacheManager.getCache().getValues();
        for (Survey survey : list) {
            survey.getTarget().d().b(1);
            if (!survey.isLastEventDismiss()) continue;
            survey.setCancelled(true);
        }
        SurveysCacheManager.addSurveys(list);
        if (CacheManager.getInstance().getCache(SURVEYS_MEMORY_CACHE_KEY) != null) {
            CacheManager.getInstance().deleteCache(CacheManager.getInstance().getCache(SURVEYS_MEMORY_CACHE_KEY).getId());
        }
        if ((list = CacheManager.getInstance().getCache(SURVEYS_DISK_CACHE_KEY)) != null) {
            CacheManager.getInstance().deleteCache(list.getId());
            CacheManager.getInstance().invalidateCache((Cache)list);
        }
    }

    public static void addSurvey(Survey survey) {
        a.a(survey);
    }

    public static void addSurveys(List<Survey> surveys) {
        Iterator<Survey> iterator = surveys.iterator();
        while (iterator.hasNext()) {
            SurveysCacheManager.addSurvey((Survey)iterator.next());
        }
    }

    public static List<Survey> getSurveys() {
        return a.a();
    }

    public static List<Survey> getTimeTriggeredSurveys() {
        return a.e();
    }

    public static List<Survey> getEventTriggeredSurveys() {
        return a.b();
    }

    public static List<Survey> getNotAnsweredSurveys() {
        return a.c();
    }

    public static List<Survey> getReadyToSendSurveys() {
        return a.d();
    }

    public static void update(final Survey survey) {
        PoolProvider.postIOTask((Runnable)new Runnable(){

            @Override
            public void run() {
                a.b(survey);
            }
        });
    }

    public static void updateSessions(final Survey survey) {
        PoolProvider.postIOTask((Runnable)new Runnable(){

            @Override
            public void run() {
                a.c(survey);
            }
        });
    }

    public static void insertOrUpdatePausedOrLocale(final Survey survey, final boolean publishStatusChanged, final boolean localeChanged) {
        PoolProvider.postIOTask((Runnable)new Runnable(){

            @Override
            public void run() {
                a.a(survey, publishStatusChanged, localeChanged);
            }
        });
    }

    public static Survey getSurveyById(long id2) {
        return a.b(id2);
    }

    public static boolean isSurveyExisting(long id2) {
        return a.b(id2) != null;
    }

    public static void resetSurveyUserInteraction(List<Survey> surveys) {
        List<Survey> list;
        for (Survey survey : surveys) {
            survey.resetUserInteractions();
            survey.resetUserAnswers();
        }
        a.a(list);
    }

    public static void delete(final long id2) {
        PoolProvider.postIOTask((Runnable)new Runnable(){

            @Override
            public void run() {
                a.a(id2);
            }
        });
    }

    public static void updateBulk(final List<Survey> surveys) {
        PoolProvider.postIOTask((Runnable)new Runnable(){

            @Override
            public void run() {
                a.a(surveys);
            }
        });
    }
}

