/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey;

import android.content.Context;
import android.content.Intent;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.Feature;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.coreeventbus.SDKCoreEvent;
import com.instabug.library.core.eventbus.coreeventbus.SDKCoreEventSubscriber;
import com.instabug.library.core.plugin.Plugin;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.storage.cache.OnDiskCache;
import com.instabug.library.network.NetworkManager;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.survey.announcements.cache.AnnouncementCacheManager;
import com.instabug.survey.announcements.network.InstabugAnnouncementSubmitterService;
import com.instabug.survey.cache.SurveysCacheManager;
import com.instabug.survey.d.a;
import com.instabug.survey.h.d;
import com.instabug.survey.h.g;
import com.instabug.survey.models.Survey;
import com.instabug.survey.network.service.InstabugSurveysSubmitterService;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Locale;

public class SurveyPlugin
extends Plugin {
    private Disposable subscribe;
    private Disposable userTypeDisposable;
    private a announcementManager;

    private void initAnnouncementSettings(Context context) {
        this.announcementManager = a.a(context);
        com.instabug.survey.d.d.b.a(context);
    }

    private void startSubmittingPendingAnnouncements() {
        if (InstabugCore.getFeatureState((Feature)Feature.ANNOUNCEMENTS) == Feature.State.ENABLED) {
            WeakReference weakReference = this.contextWeakReference;
            if (weakReference != null) {
                if ((weakReference = (Context)weakReference.get()) != null) {
                    PoolProvider.postIOTask((Runnable)new Runnable(this, (Context)weakReference){
                        final /* synthetic */ Context a;
                        {
                            this.a = context;
                        }

                        @Override
                        public void run() {
                            List<com.instabug.survey.d.c.a> list = AnnouncementCacheManager.getReadyToBeSend();
                            if (list != null && !list.isEmpty() && NetworkManager.isOnline((Context)c2.a)) {
                                c c2 = c2.a;
                                InstabugAnnouncementSubmitterService.a((Context)c2, new Intent((Context)c2, InstabugAnnouncementSubmitterService.class));
                            }
                        }
                    });
                } else {
                    InstabugSDKLogger.e((Object)((Object)this), (String)"Context is null.");
                }
            } else {
                InstabugSDKLogger.e((Object)((Object)this), (String)"Context WeakReference is null.");
            }
        }
    }

    private void unSubscribeOnSDKEvents() {
        Disposable disposable = this.subscribe;
        if (disposable != null && !disposable.isDisposed()) {
            this.subscribe.dispose();
        }
    }

    private void startSubmittingPendingSurveys() {
        if (InstabugCore.getFeatureState((Feature)Feature.SURVEYS) == Feature.State.ENABLED) {
            WeakReference weakReference = this.contextWeakReference;
            if (weakReference != null) {
                if ((weakReference = (Context)weakReference.get()) != null) {
                    PoolProvider.postIOTask((Runnable)new Runnable((Context)weakReference){
                        final /* synthetic */ Context a;
                        {
                            this.a = context;
                        }

                        @Override
                        public void run() {
                            Intent intent = SurveysCacheManager.getReadyToSendSurveys();
                            if (SurveyPlugin.this.contextWeakReference != null && intent != null && !intent.isEmpty() && NetworkManager.isOnline((Context)this.a)) {
                                Intent intent2;
                                intent = intent2;
                                intent2 = new Intent(this.a, InstabugSurveysSubmitterService.class);
                                InstabugSurveysSubmitterService.a(this.a, intent);
                            }
                        }
                    });
                } else {
                    InstabugSDKLogger.e((Object)((Object)this), (String)"Context is null.");
                }
            } else {
                InstabugSDKLogger.e((Object)((Object)this), (String)"Context WeakReference is null.");
            }
        }
    }

    private static void clearUserActivities() {
        com.instabug.survey.g.b.j().d(0L);
        com.instabug.survey.g.b.j().a(0L);
    }

    private void migrateOldSurveysCacheToDb() {
        PoolProvider.postIOTask((Runnable)new Runnable(){

            @Override
            public void run() {
                e e2 = this;
                InstabugSDKLogger.v((Object)e2, (String)"Creating Surveys disk cache");
                if (e2.SurveyPlugin.this.contextWeakReference != null && SurveyPlugin.this.contextWeakReference.get() != null) {
                    OnDiskCache onDiskCache;
                    OnDiskCache onDiskCache2 = onDiskCache;
                    onDiskCache = new OnDiskCache((Context)SurveyPlugin.this.contextWeakReference.get(), "surveys_disk_cache", "/surveys.cache", Survey.class);
                    CacheManager.getInstance().addCache((Cache)onDiskCache2);
                    if (CacheManager.getInstance().cacheExists(onDiskCache2.getId())) {
                        SurveysCacheManager.migrateOldCacheToDb();
                    }
                }
            }
        });
    }

    private void checkAppStatus() {
        SurveyPlugin this_ = (Context)this_.contextWeakReference.get();
        if (this_ != null) {
            d.a((Context)this_);
        }
    }

    private String getLocaleResolved() {
        return LocaleUtils.getCurrentLocaleResolved((Context)this.getAppContext());
    }

    public void init(Context context) {
        super.init(context);
        this.start(context);
    }

    public void stop() {
        com.instabug.survey.g.b.k();
        com.instabug.survey.g.a.j();
        this.unSubscribeOnSDKEvents();
    }

    public void start(Context context) {
        com.instabug.survey.g.b.a(context);
        com.instabug.survey.g.a.i();
        this.subscribeOnSDKEvents();
        this.initAnnouncementSettings(context);
    }

    public void wake() {
        SurveyPlugin surveyPlugin = this;
        surveyPlugin.migrateOldSurveysCacheToDb();
        com.instabug.survey.c.j();
        com.instabug.survey.c.i().g();
        surveyPlugin.resolveCountryInfo(new com.instabug.survey.models.a());
        surveyPlugin.startFetchingAnnouncements(surveyPlugin.getLocaleResolved());
        surveyPlugin.startFetchingSurveys(surveyPlugin.getLocaleResolved());
        surveyPlugin.checkAppStatus();
        surveyPlugin.startSubmittingPendingSurveys();
        surveyPlugin.startSubmittingPendingAnnouncements();
        surveyPlugin.userTypeDisposable = SDKCoreEventSubscriber.subscribe((Consumer)new Consumer<SDKCoreEvent>(){

            public void a(SDKCoreEvent sDKCoreEvent) {
                if (sDKCoreEvent.getType().equals("user") && sDKCoreEvent.getValue().equals("logged_out")) {
                    com.instabug.survey.c.i().c();
                    a.a((Context)SurveyPlugin.this.contextWeakReference.get()).a();
                } else if (sDKCoreEvent.getType().equals("user") && sDKCoreEvent.getValue().equals("logged_in")) {
                    com.instabug.survey.c.i().d();
                    a.a((Context)SurveyPlugin.this.contextWeakReference.get()).b();
                }
            }
        });
    }

    public void sleep() {
        SurveyPlugin surveyPlugin = this_;
        surveyPlugin.announcementManager.c();
        com.instabug.survey.c.i().e();
        SurveyPlugin this_ = surveyPlugin.userTypeDisposable;
        if (this_ != null) {
            this_.dispose();
        }
    }

    public long getLastActivityTime() {
        return com.instabug.survey.g.b.j().f();
    }

    /*
     * WARNING - void declaration
     */
    public void onLocaleChanged(Locale oldLocale, Locale newLocale) {
        SurveyPlugin surveyPlugin = this;
        super.onLocaleChanged(oldLocale, newLocale);
        if (surveyPlugin.shouldReFetch()) {
            void var2_2;
            SurveyPlugin surveyPlugin2 = this;
            String string = LocaleUtils.resolveLocale((Context)surveyPlugin2.getAppContext(), (Locale)var2_2);
            this.startFetchingAnnouncements(string);
            surveyPlugin2.startFetchingSurveys(string);
        }
    }

    @VisibleForTesting
    void subscribeOnSDKEvents() {
        if (this.subscribe == null) {
            this.subscribe = SDKCoreEventSubscriber.subscribe((Consumer)new Consumer<SDKCoreEvent>(){

                public void a(SDKCoreEvent sDKCoreEvent) {
                    if (g.d()) {
                        String string = sDKCoreEvent.getType();
                        int n = -1;
                        int n2 = string.hashCode();
                        if (n2 != -290659267) {
                            if (n2 != 3599307) {
                                if (n2 == 1843485230 && string.equals("network")) {
                                    n = 2;
                                }
                            } else if (string.equals("user")) {
                                n = 0;
                            }
                        } else if (string.equals("features")) {
                            n = 1;
                        }
                        if (n != 0) {
                            if (n != 1) {
                                if (n == 2 && sDKCoreEvent.getValue().equals("activated")) {
                                    b b2 = this;
                                    b2.SurveyPlugin.this.startSubmittingPendingSurveys();
                                    b2.SurveyPlugin.this.startSubmittingPendingAnnouncements();
                                }
                            } else if (sDKCoreEvent.getValue().equals("fetched")) {
                                SurveyPlugin surveyPlugin = SurveyPlugin.this;
                                surveyPlugin.startFetchingSurveys(surveyPlugin.getLocaleResolved());
                            }
                        } else if (sDKCoreEvent.getValue().equals("logged_out")) {
                            SurveyPlugin.clearUserActivities();
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    void resolveCountryInfo(com.instabug.survey.models.a countryInfo) {
        WeakReference weakReference;
        if (g.c() && (weakReference = this.contextWeakReference) != null && weakReference.get() != null) {
            void var1_1;
            InstabugSDKLogger.d((Object)((Object)this), (String)"Getting Country Code...");
            com.instabug.survey.c.i().b((com.instabug.survey.models.a)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    void startFetchingSurveys(String locale) {
        WeakReference weakReference;
        if (InstabugCore.isAppOnForeground() && InstabugCore.isFeaturesFetchedBefore() && g.d() && (weakReference = this.contextWeakReference) != null && weakReference.get() != null) {
            void var1_1;
            InstabugSDKLogger.v((Object)((Object)this), (String)"initialize Instabug Surveys Manager");
            com.instabug.survey.c.i().d((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    void startFetchingAnnouncements(String locale) {
        WeakReference weakReference = this.contextWeakReference;
        if (weakReference != null && weakReference.get() != null && InstabugCore.getFeatureState((Feature)Feature.ANNOUNCEMENTS) == Feature.State.ENABLED) {
            void var1_1;
            SurveyPlugin surveyPlugin = this;
            InstabugSDKLogger.v((Object)((Object)surveyPlugin), (String)"initialize Instabug Announcement Manager");
            a.a((Context)surveyPlugin.contextWeakReference.get()).a((String)var1_1);
        }
    }

    @VisibleForTesting
    boolean shouldReFetch() {
        return this.getLocaleResolved().equals(com.instabug.survey.g.c.f()) ^ true;
    }
}

