/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.models;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.internal.storage.cache.Cacheable;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.ListUtils;
import com.instabug.survey.e.c.a;
import com.instabug.survey.e.c.e;
import com.instabug.survey.e.c.f;
import com.instabug.survey.e.c.g;
import com.instabug.survey.e.c.i;
import com.instabug.survey.models.b;
import com.instabug.survey.models.c;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class Survey
implements Cacheable,
Serializable,
e {
    private static final String KEY_PUBLISHED = "published";
    private static final String KEY_PAUSED = "paused";
    private static final String KEY_ID = "id";
    private static final String KEY_TITLE = "title";
    private static final String KEY_TOKEN = "token";
    private static final String HAS_RESPOND = "has_respond";
    private static final String KEY_QUESTIONS = "questions";
    private static final String KEY_TARGET = "target";
    private static final String KEY_TARGET_AUDIENCE = "primitive_types";
    private static final String KEY_CUSTOM_ATTRIBUTES = "custom_attributes";
    private static final String KEY_USER_EVENTS = "user_events";
    private static final String KEY_CONDITIONS_OPERATOR = "operator";
    private static final String KEY_ANSWERED = "answered";
    private static final String KEY_DISMISSED_AT = "dismissed_at";
    private static final String KEY_IS_CANCELLED = "is_cancelled";
    private static final String KEY_SURVEY_EVENTS = "events";
    private static final String KEY_SURVEY_STATE = "survey_state";
    private static final String KEY_SHOULD_SHOW_AGAIN = "should_show_again";
    private static final String KEY_SESSION_COUNTER = "session_counter";
    private static final String KEY_WELCOME_SCREEN = "welcome_screen";
    private static final String KEY_TYPE = "type";
    private static final String KEY_THANKS_LIST = "thanks_list";
    private static final String KEY_SHOW_AT = "show_at";
    private long id;
    private String title;
    private int type;
    private String token;
    private ArrayList<b> questions;
    private i userInteraction;
    private boolean paused = false;
    private ArrayList<c> thankYouItems;
    private com.instabug.survey.e.c.b localization = new com.instabug.survey.e.c.b();

    public Survey() {
        this.userInteraction = new i(0);
    }

    public static List<Survey> getPausedSurveysFromJson(JSONObject response) throws JSONException {
        JSONObject jSONObject;
        ArrayList<Survey> arrayList;
        response = response.getJSONArray(KEY_PAUSED);
        ArrayList<Survey> arrayList2 = arrayList;
        arrayList = new ArrayList<Survey>(response.length());
        for (int j = 0; j < jSONObject.length(); ++j) {
            Survey survey;
            Survey survey2 = survey;
            survey2();
            survey.setId(jSONObject.getLong(j));
            survey.setPaused(true);
            arrayList2.add(survey);
        }
        return arrayList2;
    }

    public static List<Survey> fromJson(JSONObject surveysJsonObject) throws JSONException {
        JSONObject jSONObject;
        ArrayList<Survey> arrayList;
        surveysJsonObject = surveysJsonObject.getJSONArray(KEY_PUBLISHED);
        ArrayList<Survey> arrayList2 = arrayList;
        arrayList = new ArrayList<Survey>();
        for (int j = 0; j < jSONObject.length(); ++j) {
            JSONObject jSONObject2 = jSONObject.getJSONObject(j);
            Survey survey = new Survey();
            survey.fromJson(jSONObject2.toString());
            arrayList2.add(survey);
        }
        return arrayList2;
    }

    private boolean hasNPSSubmitted() {
        if (((Survey)((Object)this_)).userInteraction.i().a() != null) {
            Iterator<a> this_ = ((Survey)((Object)this_)).userInteraction.i().a().iterator();
            while (this_.hasNext()) {
                if (((a)this_.next()).a() != a.a.SUBMIT) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isPromoter() {
        return this.getNPSAnswerValue() > 8;
    }

    private boolean isPassive() {
        return this.getNPSAnswerValue() > 6 && this.getNPSAnswerValue() <= 8;
    }

    private boolean isDetractor() {
        return this.getNPSAnswerValue() <= 6;
    }

    private int getNPSAnswerValue() {
        try {
            return Integer.parseInt(((b)ListUtils.safeGet(this.questions, (int)0)).a());
        }
        catch (Exception exception) {
            InstabugSDKLogger.e((Object)this, (String)("NPS score parsing failed du to: " + exception.getMessage()));
            return 0;
        }
    }

    private String getNPSThankYouTitle() {
        Serializable serializable = this.getThankYouItems();
        if (((ArrayList)serializable).size() > 0) {
            ArrayList<c> arrayList = serializable;
            serializable = (c)ListUtils.safeGet(arrayList, (int)0);
            c c2 = (c)ListUtils.safeGet(arrayList, (int)1);
            c c3 = (c)ListUtils.safeGet(arrayList, (int)2);
            if (this.isPromoter() && serializable != null) {
                return ((c)serializable).c();
            }
            if (this.isPassive() && c2 != null) {
                return c2.c();
            }
            if (this.isDetractor() && c3 != null) {
                return c3.c();
            }
        }
        return null;
    }

    private String getCustomThankYouTitle() {
        if (((ArrayList)(this = ((Survey)this).getThankYouItems())).size() > 0 && (this = (c)ListUtils.safeGet((List)((Object)this), (int)0)) != null) {
            return ((c)this).c();
        }
        return null;
    }

    private String getNPSThankYouMessage() {
        Serializable serializable = this.getThankYouItems();
        if (((ArrayList)serializable).size() > 0) {
            ArrayList<c> arrayList = serializable;
            serializable = (c)ListUtils.safeGet(arrayList, (int)0);
            c c2 = (c)ListUtils.safeGet(arrayList, (int)1);
            c c3 = (c)ListUtils.safeGet(arrayList, (int)2);
            if (this.isPromoter() && serializable != null) {
                return ((c)serializable).b();
            }
            if (this.isPassive() && c2 != null) {
                return c2.b();
            }
            if (this.isDetractor() && c3 != null) {
                return c3.b();
            }
        }
        return null;
    }

    private String getCustomThankYouMessage() {
        if (((ArrayList)(this = ((Survey)this).getThankYouItems())).size() > 0 && (this = (c)ListUtils.safeGet((List)((Object)this), (int)0)) != null) {
            return ((c)this).b();
        }
        return null;
    }

    private void setSessionCounter(int sessionCounter) {
        this.userInteraction.c(sessionCounter);
    }

    public g getTarget() {
        return this.userInteraction.i();
    }

    public void setTarget(g target) {
        this.userInteraction.a(target);
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    @Override
    public long getSurveyId() {
        return this.id;
    }

    @Override
    public i getUserInteraction() {
        return this.userInteraction;
    }

    public void setUserInteraction(i userInteraction) {
        this.userInteraction = userInteraction;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSubmitted() {
        a a2;
        Survey survey = this_;
        survey.setCancelled(false);
        survey.setAnswered(true);
        if (survey.isNPSSurvey() && this_.isAnswered() && this_.hasNPSSubmitted() && this_.hasPositiveNpsAnswer()) {
            a a3;
            a2 = a3;
            a3 = new a(a.a.RATE, System.currentTimeMillis() / 1000L, this_.getEventIndex());
        } else {
            a a4;
            a2 = a4;
            a4 = new a(a.a.SUBMIT, System.currentTimeMillis() / 1000L, this_.getEventIndex());
            if (this_.isOptInSurvey()) {
                this_.userInteraction.a(0);
            }
        }
        Survey survey2 = this_;
        survey2.setSurveyState(f.READY_TO_SEND);
        Cacheable this_ = survey2.userInteraction.i();
        if (this_.a().size() > 0 && this_.a().get(this_.a().size() - 1).a() == a.a.SUBMIT && a2.a() == a.a.SUBMIT) {
            return;
        }
        this_.a().add(a2);
    }

    public boolean isNPSSurvey() {
        return this.getType() == 1;
    }

    public boolean isStoreRatingSurvey() {
        return this.getType() == 2;
    }

    public ArrayList<b> getQuestions() {
        return this.questions;
    }

    public void setQuestions(ArrayList<b> question) {
        this.questions = question;
    }

    public ArrayList<com.instabug.survey.e.c.c> getTargetAudiences() {
        return this.userInteraction.i().e();
    }

    public void setTargetAudiences(ArrayList<com.instabug.survey.e.c.c> targetAudiences) {
        this.userInteraction.i().c(targetAudiences);
    }

    public ArrayList<com.instabug.survey.e.c.c> getCustomAttributes() {
        return this.userInteraction.i().c();
    }

    public void setCustomAttributes(ArrayList<com.instabug.survey.e.c.c> customAttributes) {
        this.userInteraction.i().b(customAttributes);
    }

    public ArrayList<com.instabug.survey.e.c.c> getUserEvents() {
        return this.userInteraction.i().g();
    }

    public void setUserEvents(ArrayList<com.instabug.survey.e.c.c> userEvents) {
        this.userInteraction.i().d(userEvents);
    }

    public ArrayList<a> getSurveyEvents() {
        return this.userInteraction.i().a();
    }

    public void setSurveyEvents(ArrayList<a> actionEvents) {
        this.userInteraction.i().a(actionEvents);
    }

    public String getConditionsOperator() {
        return this.userInteraction.i().b();
    }

    public void setConditionsOperator(String conditionOperator) {
        this.userInteraction.i().a(conditionOperator);
    }

    public boolean hasPositiveNpsAnswer() {
        return this.isNPSSurvey() && (this.isPromoter() || this.isPassive());
    }

    public int getEventIndex() {
        return this.userInteraction.d();
    }

    public void setEventIndex(int eventIndex) {
        this.userInteraction.b(eventIndex);
    }

    public boolean isOptInSurvey() {
        return this.getToken() != null && !String.valueOf(this.getToken()).equals("null");
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setDismissed() {
        a a2;
        Survey survey = this;
        survey.setSurveyState(f.READY_TO_SEND);
        if (survey.isNPSSurvey() && this.hasPositiveNpsAnswer() && this.hasNPSSubmitted()) {
            return;
        }
        boolean bl = this.isOptInSurvey() || this.userInteraction.c() == 0L;
        Survey survey2 = this;
        survey2.setShouldShowAgain(bl);
        survey2.userInteraction.a(System.currentTimeMillis() / 1000L);
        survey2.setCancelled(true);
        if (survey2.userInteraction.i().a().size() > 0 && this.userInteraction.i().a().get(this.userInteraction.i().a().size() - 1).a() == a.a.DISMISS) {
            return;
        }
        a a3 = a2;
        a2 = new a(a.a.DISMISS, this.userInteraction.c(), this.getEventIndex());
        this.userInteraction.i().a().add(a3);
    }

    public void addShowEvent() {
        a a2;
        Survey survey = this;
        survey.userInteraction.b(System.currentTimeMillis() / 1000L);
        survey.userInteraction.k();
        a a3 = a2;
        a2 = new a(a.a.SHOW, this.userInteraction.f(), this.userInteraction.l());
        survey.userInteraction.i().a().add(a3);
    }

    public void addRateEvent() {
        a a2;
        a a3 = a2;
        a2 = new a(a.a.RATE, System.currentTimeMillis() / 1000L, this.getAttemptCount());
        this.userInteraction.i().a().add(a3);
    }

    public long getShownAt() {
        return this.userInteraction.f();
    }

    public void setShowAt(long shownAt) {
        this.userInteraction.b(shownAt);
    }

    public int getAttemptCount() {
        return this.userInteraction.b();
    }

    public void setAttemptCount(int attemptsCount) {
        this.userInteraction.a(attemptsCount);
    }

    public void setSessionCount(int sessionCount) {
        this.userInteraction.c(sessionCount);
    }

    @Nullable
    public String getThankYouTitle() {
        return this.isNPSSurvey() ? this.getNPSThankYouTitle() : this.getCustomThankYouTitle();
    }

    @Nullable
    public String getThankYouMessage() {
        return this.isNPSSurvey() ? this.getNPSThankYouMessage() : this.getCustomThankYouMessage();
    }

    public boolean isAppStoreRatingEnabled() {
        Serializable serializable = this.getThankYouItems();
        if (((ArrayList)serializable).size() > 0) {
            ArrayList<c> arrayList = serializable;
            serializable = (c)ListUtils.safeGet(arrayList, (int)0);
            c c2 = (c)ListUtils.safeGet(arrayList, (int)1);
            if (this.isPromoter() && serializable != null) {
                return ((c)serializable).d();
            }
            if (this.isPassive() && c2 != null) {
                return c2.d();
            }
        }
        return false;
    }

    @Nullable
    public String getRatingCTATitle() {
        Serializable serializable;
        if (this.isAppStoreRatingEnabled() && ((ArrayList)(serializable = this.getThankYouItems())).size() > 0) {
            ArrayList<c> arrayList = serializable;
            serializable = (c)ListUtils.safeGet(arrayList, (int)0);
            c c2 = (c)ListUtils.safeGet(arrayList, (int)1);
            if (this.isPromoter() && serializable != null) {
                return ((c)serializable).a();
            }
            if (this.isPassive() && c2 != null) {
                return c2.a();
            }
        }
        return null;
    }

    public void incrementSessionCount() {
        this.userInteraction.m();
    }

    public boolean isCancelled() {
        return this.userInteraction.p();
    }

    public void setCancelled(boolean cancelled) {
        this.userInteraction.c(cancelled);
    }

    public void resetSessionsCounter() {
        this.userInteraction.c(0);
    }

    public void resetUserInteractions() {
        Survey survey = this_;
        Cacheable this_ = survey.userInteraction.i();
        ((g)this_).a(new ArrayList<a>());
        survey.userInteraction = new i(0);
        survey.userInteraction.a((g)this_);
    }

    public void resetUserAnswers() {
        Iterator<b> this_ = ((Survey)((Object)this_)).questions.iterator();
        while (this_.hasNext()) {
            ((b)this_.next()).g();
        }
    }

    public long getRespondedAt() {
        if (this.isLastEventDismiss()) {
            return 0L;
        }
        if (this.userInteraction.i().a() != null && this.userInteraction.i().a().size() > 0) {
            for (a a2 : this.userInteraction.i().a()) {
                if (a2.a() != a.a.SUBMIT) continue;
                return a2.c();
            }
        }
        if (this.getQuestions() != null && this.getQuestions().size() > 0) {
            for (int j = this.getQuestions().size() - 1; j >= 0; --j) {
                if (this.getQuestions().get(j).b() <= 0L) continue;
                return this.getQuestions().get(j).b();
            }
        }
        return 0L;
    }

    public boolean isLastEventDismiss() {
        return this.userInteraction.i().a() != null && this.userInteraction.i().a().size() > 0 && this.userInteraction.i().a().get(this.userInteraction.i().a().size() - 1).a() == a.a.DISMISS;
    }

    public String toJson() throws JSONException {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject2();
        long l = this.id;
        JSONObject jSONObject3 = jSONObject2.put(KEY_ID, l).put(KEY_TYPE, this.type).put(KEY_TITLE, (Object)this.title).put(KEY_TOKEN, (Object)this.token).put(KEY_QUESTIONS, (Object)b.b(this.questions)).put(KEY_TARGET, (Object)g.a(this.userInteraction.i())).put(KEY_SURVEY_EVENTS, (Object)a.a(this.userInteraction.i().a())).put(KEY_ANSWERED, this.userInteraction.o());
        l = this.userInteraction.f();
        JSONObject jSONObject4 = jSONObject3.put(KEY_SHOW_AT, l);
        l = this.getDismissedAt();
        jSONObject4.put(KEY_DISMISSED_AT, l).put(KEY_IS_CANCELLED, this.userInteraction.p()).put(KEY_SURVEY_STATE, (Object)this.getSurveyState().toString()).put(KEY_SHOULD_SHOW_AGAIN, this.shouldShowAgain()).put(KEY_THANKS_LIST, (Object)c.a(this.thankYouItems)).put(KEY_SESSION_COUNTER, this.getSessionCounter());
        this.localization.b(jSONObject2);
        return jSONObject.toString();
    }

    public boolean shouldShowAgain() {
        return this.userInteraction.q();
    }

    public long getDismissedAt() {
        return this.userInteraction.c();
    }

    public void setDismissedAt(long dismissedAt) {
        this.userInteraction.a(dismissedAt);
    }

    public f getSurveyState() {
        return this.userInteraction.h();
    }

    public void setSurveyState(f surveyState) {
        this.userInteraction.a(surveyState);
    }

    public int getSessionCounter() {
        return this.userInteraction.e();
    }

    public void fromJson(String modelAsJson) throws JSONException {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        if (new JSONObject(modelAsJson).has(KEY_ID)) {
            this.setId(jSONObject2.getLong(KEY_ID));
        }
        if (jSONObject2.has(KEY_TYPE)) {
            this.setType(jSONObject2.getInt(KEY_TYPE));
        }
        if (jSONObject2.has(KEY_TITLE)) {
            this.setTitle(jSONObject2.getString(KEY_TITLE));
        }
        if (jSONObject2.has(KEY_TOKEN) && jSONObject2.get(KEY_TOKEN) != JSONObject.NULL) {
            this.setToken(jSONObject2.getString(KEY_TOKEN));
        }
        if (jSONObject2.has(KEY_SURVEY_EVENTS)) {
            this.userInteraction.i().a(a.a(jSONObject2.getJSONArray(KEY_SURVEY_EVENTS)));
        }
        if (jSONObject2.has(KEY_QUESTIONS)) {
            this.setQuestions(b.a(jSONObject2.getJSONArray(KEY_QUESTIONS)));
        }
        if (jSONObject2.has(KEY_TARGET)) {
            JSONObject jSONObject3 = jSONObject2.getJSONObject(KEY_TARGET);
            this.userInteraction.i().fromJson(jSONObject3.toString().replace("\\", ""));
        }
        if (jSONObject2.has(KEY_ANSWERED)) {
            this.setAnswered(jSONObject2.getBoolean(KEY_ANSWERED));
        }
        if (jSONObject2.has(KEY_IS_CANCELLED)) {
            this.setCancelled(jSONObject2.getBoolean(KEY_IS_CANCELLED));
        }
        if (jSONObject2.has(KEY_SURVEY_STATE)) {
            this.setSurveyState(f.valueOf(jSONObject2.getString(KEY_SURVEY_STATE)));
        }
        if (jSONObject2.has(KEY_SHOULD_SHOW_AGAIN)) {
            this.setShouldShowAgain(jSONObject2.getBoolean(KEY_SHOULD_SHOW_AGAIN));
        }
        if (jSONObject2.has(KEY_SESSION_COUNTER)) {
            this.setSessionCounter(jSONObject2.getInt(KEY_SESSION_COUNTER));
        }
        if (jSONObject2.has(KEY_DISMISSED_AT)) {
            this.setDismissedAt(jSONObject2.getInt(KEY_DISMISSED_AT));
        }
        if (jSONObject2.has(KEY_SHOW_AT)) {
            this.setShowAt(jSONObject2.getInt(KEY_SHOW_AT));
        }
        if (jSONObject2.has(KEY_THANKS_LIST)) {
            this.setThankYouItems(c.a(jSONObject2.getJSONArray(KEY_THANKS_LIST)));
        }
        this.localization.a(jSONObject2);
    }

    public long getId() {
        return this.id;
    }

    public Survey setId(long id2) {
        this.id = id2;
        return this;
    }

    public void setThankYouItems(ArrayList<c> thankYouItems) {
        this.thankYouItems = thankYouItems;
    }

    public ArrayList<c> getThankYouItems() {
        return this.thankYouItems;
    }

    public boolean isAnswered() {
        return this.userInteraction.o();
    }

    public void setAnswered(boolean answered) {
        this.userInteraction.b(answered);
    }

    public void setShouldShowAgain(boolean shouldShowAgain) {
        this.userInteraction.d(shouldShowAgain);
    }

    public com.instabug.survey.e.c.b getLocalization() {
        return this.localization;
    }

    public void setLocalization(com.instabug.survey.e.c.b localization) {
        this.localization = localization;
    }

    public void clearAnswers() {
        Iterator<b> this_ = ((Survey)((Object)this_)).questions.iterator();
        while (this_.hasNext()) {
            ((b)this_.next()).a((String)null);
        }
    }

    public boolean isLastEventSubmit() {
        return this.userInteraction.i().a() != null && this.userInteraction.i().a().size() > 0 && this.userInteraction.i().a().get(this.userInteraction.i().a().size() - 1).a() == a.a.SUBMIT;
    }

    public int hashCode() {
        return String.valueOf(this.getId()).hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object survey) {
        if (survey instanceof Survey) {
            void var1_1;
            return ((Survey)var1_1).getId() == this.getId();
        }
        return false;
    }

    @NonNull
    public String toString() {
        try {
            return this.toJson();
        }
        catch (JSONException jSONException) {
            InstabugSDKLogger.e((Object)"Survey", (String)jSONException.getMessage(), (Throwable)jSONException);
            return super.toString();
        }
    }
}

