/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.cache;

import android.support.annotation.Nullable;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.survey.cache.a;
import com.instabug.survey.common.a.d;
import com.instabug.survey.models.Survey;
import java.util.List;

public class SurveysCacheManager {
    public static final String SURVEYS_DISK_CACHE_FILE_NAME = "/surveys.cache";
    public static final String SURVEYS_DISK_CACHE_KEY = "surveys_disk_cache";
    public static final String SURVEYS_MEMORY_CACHE_KEY = "surveys_memory_cache";

    @Nullable
    public static InMemoryCache<Long, Survey> getCache() throws IllegalArgumentException {
        if (!CacheManager.getInstance().cacheExists(SURVEYS_MEMORY_CACHE_KEY)) {
            InstabugSDKLogger.d(SurveysCacheManager.class, (String)("In-memory Surveys cache not found, loading it from disk " + CacheManager.getInstance().getCache(SURVEYS_MEMORY_CACHE_KEY)));
            CacheManager.getInstance().migrateCache(SURVEYS_DISK_CACHE_KEY, SURVEYS_MEMORY_CACHE_KEY, (CacheManager.KeyExtractor)new CacheManager.KeyExtractor<Long, Survey>(){

                public Long a(Survey survey) {
                    return survey.getId();
                }

                public /* synthetic */ Object extractKey(Object object) {
                    return this.a((Survey)object);
                }
            });
            Cache cache = CacheManager.getInstance().getCache(SURVEYS_MEMORY_CACHE_KEY);
            if (cache != null) {
                InstabugSDKLogger.d(SurveysCacheManager.class, (String)("In-memory Surveys cache restored from disk, " + cache.size() + " elements restored"));
            }
        }
        InstabugSDKLogger.d(SurveysCacheManager.class, (String)"In-memory Surveys cache found");
        return (InMemoryCache)CacheManager.getInstance().getCache(SURVEYS_MEMORY_CACHE_KEY);
    }

    public static void migrateOldCacheToDb() {
        if (SurveysCacheManager.getCache() == null) {
            return;
        }
        List list = SurveysCacheManager.getCache().getValues();
        Cache cache = list.iterator();
        while (cache.hasNext()) {
            Survey survey = (Survey)cache.next();
            d d2 = survey.getTarget().g();
            d2.a(1);
            if (!survey.isLastEventDismiss()) continue;
            survey.setCancelled(true);
        }
        SurveysCacheManager.addSurveys(list);
        if (CacheManager.getInstance().getCache(SURVEYS_MEMORY_CACHE_KEY) != null) {
            CacheManager.getInstance().deleteCache(CacheManager.getInstance().getCache(SURVEYS_MEMORY_CACHE_KEY).getId());
        }
        if ((cache = CacheManager.getInstance().getCache(SURVEYS_DISK_CACHE_KEY)) != null) {
            CacheManager.getInstance().deleteCache(cache.getId());
            CacheManager.getInstance().invalidateCache(cache);
        }
    }

    public static void addSurvey(Survey survey) {
        a.a(survey);
    }

    public static void addSurveys(List<Survey> surveys) {
        for (Survey survey : surveys) {
            SurveysCacheManager.addSurvey(survey);
        }
    }

    public static List<Survey> getSurveys() {
        return a.e();
    }

    public static List<Survey> getTimeTriggeredSurveys() {
        return a.c();
    }

    public static List<Survey> getEventTriggeredSurveys() {
        return a.d();
    }

    public static List<Survey> getNotAnsweredSurveys() {
        return a.b();
    }

    public static List<Survey> getReadyToSendSurveys() {
        return a.a();
    }

    public static void update(final Survey survey) {
        PoolProvider.postIOTask((Runnable)new Runnable(){

            @Override
            public void run() {
                a.b(survey);
            }
        });
    }

    public static void updateSessions(final Survey survey) {
        PoolProvider.postIOTask((Runnable)new Runnable(){

            @Override
            public void run() {
                a.c(survey);
            }
        });
    }

    public static void insertOrUpdatePausedOrLocale(final Survey survey, final boolean publishStatusChanged, final boolean localeChanged) {
        PoolProvider.postIOTask((Runnable)new Runnable(){

            @Override
            public void run() {
                a.a(survey, publishStatusChanged, localeChanged);
            }
        });
    }

    public static Survey getSurveyById(long id2) {
        return a.a(id2);
    }

    public static boolean isSurveyExisting(long id2) {
        return a.a(id2) != null;
    }

    public static void resetSurveyUserInteraction(List<Survey> surveys) {
        for (Survey survey : surveys) {
            survey.resetUserInteractions();
            survey.resetUserAnswers();
        }
        a.a(surveys);
    }

    public static void delete(final long id2) {
        PoolProvider.postIOTask((Runnable)new Runnable(){

            @Override
            public void run() {
                a.b(id2);
            }
        });
    }

    public static void updateBulk(final List<Survey> surveys) {
        PoolProvider.postIOTask((Runnable)new Runnable(){

            @Override
            public void run() {
                a.a(surveys);
            }
        });
    }
}

