/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.models;

import com.instabug.library.internal.storage.cache.Cacheable;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.ListUtils;
import com.instabug.survey.a.a.a;
import com.instabug.survey.a.a.e;
import com.instabug.survey.models.b;
import com.instabug.survey.models.c;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Survey
implements Cacheable,
Serializable {
    private static final String KEY_PUBLISHED = "published";
    private static final String KEY_PAUSED = "paused";
    private static final String KEY_ID = "id";
    private static final String KEY_TITLE = "title";
    private static final String KEY_TOKEN = "token";
    private static final String HAS_RESPOND = "has_respond";
    private static final String KEY_QUESTIONS = "questions";
    private static final String KEY_TARGET = "target";
    private static final String KEY_TARGET_AUDIENCE = "primitive_types";
    private static final String KEY_CUSTOM_ATTRIBUTES = "custom_attributes";
    private static final String KEY_USER_EVENTS = "user_events";
    private static final String KEY_CONDITIONS_OPERATOR = "operator";
    private static final String KEY_ANSWERED = "answered";
    private static final String KEY_DISMISSED_AT = "dismissed_at";
    private static final String KEY_IS_CANCELLED = "is_cancelled";
    private static final String KEY_SURVEY_EVENTS = "events";
    private static final String KEY_SURVEY_STATE = "survey_state";
    private static final String KEY_SHOULD_SHOW_AGAIN = "should_show_again";
    private static final String KEY_SESSION_COUNTER = "session_counter";
    private static final String KEY_WELCOME_SCREEN = "welcome_screen";
    private static final String KEY_TYPE = "type";
    private static final String KEY_THANKS_LIST = "thanks_list";
    private static final String KEY_SHOW_AT = "show_at";
    private long id;
    private String title;
    private int type;
    private String token;
    private ArrayList<b> questions;
    private e target;
    private boolean answered = false;
    private long dismissedAt;
    private long shownAt;
    private boolean isCancelled = false;
    private int attemptCount = -1;
    private int eventIndex = -1;
    private a surveyState = a.NOT_AVAILABLE;
    private boolean shouldShowAgain = true;
    private boolean paused = false;
    private ArrayList<c> thankYouItems;
    private com.instabug.survey.a.a.b localization;
    private int sessionCounter = 0;

    public Survey() {
        this.target = new e();
        this.localization = new com.instabug.survey.a.a.b();
    }

    public static List<Survey> getPausedSurveysFromJson(JSONObject response) throws JSONException {
        JSONArray jSONArray = response.getJSONArray(KEY_PAUSED);
        ArrayList<Survey> arrayList = new ArrayList<Survey>(jSONArray.length());
        for (int j = 0; j < jSONArray.length(); ++j) {
            Survey survey = new Survey();
            survey.setId(jSONArray.getLong(j));
            survey.setPaused(true);
            arrayList.add(survey);
        }
        return arrayList;
    }

    public static List<Survey> fromJson(JSONObject surveysJsonObject) throws JSONException {
        JSONArray jSONArray = surveysJsonObject.getJSONArray(KEY_PUBLISHED);
        ArrayList<Survey> arrayList = new ArrayList<Survey>();
        for (int j = 0; j < jSONArray.length(); ++j) {
            JSONObject jSONObject = jSONArray.getJSONObject(j);
            Survey survey = new Survey();
            survey.fromJson(jSONObject.toString());
            arrayList.add(survey);
        }
        return arrayList;
    }

    public e getTarget() {
        return this.target;
    }

    public void setTarget(e target) {
        this.target = target;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSubmitted() {
        com.instabug.survey.a.a.a a2;
        this.setCancelled(false);
        this.setAnswered(true);
        if (this.isNPSSurvey() && this.isAnswered() && this.hasNPSSubmitted() && this.hasPositiveNpsAnswer()) {
            a2 = new com.instabug.survey.a.a.a(a.a.RATE, System.currentTimeMillis() / 1000L, this.getEventIndex());
        } else {
            a2 = new com.instabug.survey.a.a.a(a.a.SUBMIT, System.currentTimeMillis() / 1000L, this.getEventIndex());
            if (this.isOptInSurvey()) {
                this.attemptCount = 0;
            }
        }
        this.setSurveyState(a.READY_TO_SEND);
        if (this.target.d().size() > 0 && this.target.d().get(this.target.d().size() - 1).a() == a.a.SUBMIT && a2.a() == a.a.SUBMIT) {
            return;
        }
        this.target.d().add(a2);
    }

    public boolean isNPSSurvey() {
        return this.getType() == 1;
    }

    public boolean isStoreRatingSurvey() {
        return this.getType() == 2;
    }

    public ArrayList<b> getQuestions() {
        return this.questions;
    }

    public void setQuestions(ArrayList<b> question) {
        this.questions = question;
    }

    public ArrayList<com.instabug.survey.a.a.c> getTargetAudiences() {
        return this.target.a();
    }

    public void setTargetAudiences(ArrayList<com.instabug.survey.a.a.c> targetAudiences) {
        this.target.a(targetAudiences);
    }

    public ArrayList<com.instabug.survey.a.a.c> getCustomAttributes() {
        return this.target.b();
    }

    public void setCustomAttributes(ArrayList<com.instabug.survey.a.a.c> customAttributes) {
        this.target.b(customAttributes);
    }

    public ArrayList<com.instabug.survey.a.a.c> getUserEvents() {
        return this.target.c();
    }

    public void setUserEvents(ArrayList<com.instabug.survey.a.a.c> userEvents) {
        this.target.c(userEvents);
    }

    public ArrayList<com.instabug.survey.a.a.a> getSurveyEvents() {
        return this.target.d();
    }

    public void setSurveyEvents(ArrayList<com.instabug.survey.a.a.a> actionEvents) {
        this.target.d(actionEvents);
    }

    public String getConditionsOperator() {
        return this.target.e();
    }

    public void setConditionsOperator(String conditionOperator) {
        this.target.b(conditionOperator);
    }

    public boolean hasPositiveNpsAnswer() {
        return this.isNPSSurvey() && (this.isPromoter() || this.isPassive());
    }

    private boolean hasNPSSubmitted() {
        if (this.target.d() != null) {
            for (com.instabug.survey.a.a.a a2 : this.target.d()) {
                if (a2.a() != a.a.SUBMIT) continue;
                return true;
            }
        }
        return false;
    }

    public int getEventIndex() {
        return this.eventIndex;
    }

    public void setEventIndex(int eventIndex) {
        this.eventIndex = eventIndex;
    }

    public boolean isOptInSurvey() {
        return this.getToken() != null && !String.valueOf(this.getToken()).equals("null");
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setDismissed() {
        this.setSurveyState(a.READY_TO_SEND);
        if (this.isNPSSurvey() && this.hasPositiveNpsAnswer() && this.hasNPSSubmitted()) {
            return;
        }
        this.setShouldShowAgain(this.dismissedAt == 0L);
        this.dismissedAt = System.currentTimeMillis() / 1000L;
        this.setCancelled(true);
        if (this.target.d().size() > 0 && this.target.d().get(this.target.d().size() - 1).a() == a.a.DISMISS) {
            return;
        }
        com.instabug.survey.a.a.a a2 = new com.instabug.survey.a.a.a(a.a.DISMISS, this.dismissedAt, this.getEventIndex());
        this.target.d().add(a2);
    }

    public void addShowEvent() {
        this.shownAt = System.currentTimeMillis() / 1000L;
        com.instabug.survey.a.a.a a2 = new com.instabug.survey.a.a.a(a.a.SHOW, this.shownAt, this.incrementEventIndex());
        this.target.d().add(a2);
    }

    public void addRateEvent() {
        com.instabug.survey.a.a.a a2 = new com.instabug.survey.a.a.a(a.a.RATE, System.currentTimeMillis() / 1000L, this.getAttemptCount());
        this.target.d().add(a2);
    }

    public long getShownAt() {
        return this.shownAt;
    }

    public void setShowAt(long shownAt) {
        this.shownAt = shownAt;
    }

    public int incrementEventIndex() {
        ++this.attemptCount;
        return ++this.eventIndex;
    }

    public int getAttemptCount() {
        return this.attemptCount;
    }

    public void setAttemptCount(int attemptsCount) {
        this.attemptCount = attemptsCount;
    }

    public void setSessionCount(int sessionCount) {
        this.sessionCounter = sessionCount;
    }

    private int getAttempt() {
        return this.attemptCount++;
    }

    private boolean isPromoter() {
        return this.getNPSAnswerValue() > 8;
    }

    private boolean isPassive() {
        return this.getNPSAnswerValue() > 6 && this.getNPSAnswerValue() <= 8;
    }

    private boolean isDetractor() {
        return this.getNPSAnswerValue() <= 6;
    }

    private int getNPSAnswerValue() {
        try {
            return Integer.parseInt(((b)ListUtils.safeGet(this.questions, (int)0)).e());
        }
        catch (Exception exception) {
            InstabugSDKLogger.e((Object)this, (String)("NPS score parsing failed du to: " + exception.getMessage()));
            return 0;
        }
    }

    @Nullable
    public String getThankYouTitle() {
        ArrayList<c> arrayList = this.getThankYouItems();
        if (arrayList.size() > 0) {
            c c2 = (c)ListUtils.safeGet(arrayList, (int)0);
            c c3 = (c)ListUtils.safeGet(arrayList, (int)1);
            c c4 = (c)ListUtils.safeGet(arrayList, (int)2);
            if (this.isPromoter() && c2 != null) {
                return c2.a();
            }
            if (this.isPassive() && c3 != null) {
                return c3.a();
            }
            if (this.isDetractor() && c4 != null) {
                return c4.a();
            }
        }
        return null;
    }

    @Nullable
    public String getThankYouMessage() {
        ArrayList<c> arrayList = this.getThankYouItems();
        if (arrayList.size() > 0) {
            c c2 = (c)ListUtils.safeGet(arrayList, (int)0);
            c c3 = (c)ListUtils.safeGet(arrayList, (int)1);
            c c4 = (c)ListUtils.safeGet(arrayList, (int)2);
            if (this.isPromoter() && c2 != null) {
                return c2.b();
            }
            if (this.isPassive() && c3 != null) {
                return c3.b();
            }
            if (this.isDetractor() && c4 != null) {
                return c4.b();
            }
        }
        return null;
    }

    public boolean isAppStoreRatingEnabled() {
        ArrayList<c> arrayList = this.getThankYouItems();
        if (arrayList.size() > 0) {
            c c2 = (c)ListUtils.safeGet(arrayList, (int)0);
            c c3 = (c)ListUtils.safeGet(arrayList, (int)1);
            if (this.isPromoter() && c2 != null) {
                return c2.d();
            }
            if (this.isPassive() && c3 != null) {
                return c3.d();
            }
        }
        return false;
    }

    @Nullable
    public String getRatingCTATitle() {
        ArrayList<c> arrayList;
        if (this.isAppStoreRatingEnabled() && (arrayList = this.getThankYouItems()).size() > 0) {
            c c2 = (c)ListUtils.safeGet(arrayList, (int)0);
            c c3 = (c)ListUtils.safeGet(arrayList, (int)1);
            if (this.isPromoter() && c2 != null) {
                return c2.c();
            }
            if (this.isPassive() && c3 != null) {
                return c3.c();
            }
        }
        return null;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.isCancelled = cancelled;
    }

    public void incrementSessionCount() {
        this.setSessionCounter(++this.sessionCounter);
    }

    public void resetSessionsCounter() {
        this.sessionCounter = 0;
    }

    public long getRespondedAt() {
        if (this.isLastEventDismiss()) {
            return 0L;
        }
        if (this.target.d() != null && this.target.d().size() > 0) {
            for (com.instabug.survey.a.a.a a2 : this.target.d()) {
                if (a2.a() != a.a.SUBMIT) continue;
                return a2.b();
            }
        }
        if (this.getQuestions() != null && this.getQuestions().size() > 0) {
            for (int j = this.getQuestions().size() - 1; j >= 0; --j) {
                if (this.getQuestions().get(j).f() <= 0L) continue;
                return this.getQuestions().get(j).f();
            }
        }
        return 0L;
    }

    public boolean isLastEventDismiss() {
        return this.target.d() != null && this.target.d().size() > 0 && this.target.d().get(this.target.d().size() - 1).a() == a.a.DISMISS;
    }

    public String toJson() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(KEY_ID, this.id).put(KEY_TYPE, this.type).put(KEY_TITLE, (Object)this.title).put(KEY_TOKEN, (Object)this.token).put(KEY_QUESTIONS, (Object)b.a(this.questions)).put(KEY_TARGET, (Object)e.a(this.target)).put(KEY_SURVEY_EVENTS, (Object)com.instabug.survey.a.a.a.a(this.target.d())).put(KEY_ANSWERED, this.answered).put(KEY_SHOW_AT, this.shownAt).put(KEY_DISMISSED_AT, this.getDismissedAt()).put(KEY_IS_CANCELLED, this.isCancelled).put(KEY_SURVEY_STATE, (Object)this.getSurveyState().toString()).put(KEY_SHOULD_SHOW_AGAIN, this.shouldShowAgain()).put(KEY_THANKS_LIST, (Object)c.a(this.thankYouItems)).put(KEY_SESSION_COUNTER, this.getSessionCounter());
        this.localization.a(jSONObject);
        return jSONObject.toString();
    }

    public boolean shouldShowAgain() {
        return this.shouldShowAgain;
    }

    public long getDismissedAt() {
        return this.dismissedAt;
    }

    public void setDismissedAt(long dismissedAt) {
        this.dismissedAt = dismissedAt;
    }

    public a getSurveyState() {
        return this.surveyState;
    }

    public void setSurveyState(a surveyState) {
        this.surveyState = surveyState;
    }

    public int getSessionCounter() {
        return this.sessionCounter;
    }

    private void setSessionCounter(int sessionCounter) {
        this.sessionCounter = sessionCounter;
    }

    public void fromJson(String modelAsJson) throws JSONException {
        JSONObject jSONObject = new JSONObject(modelAsJson);
        if (jSONObject.has(KEY_ID)) {
            this.setId(jSONObject.getLong(KEY_ID));
        }
        if (jSONObject.has(KEY_TYPE)) {
            int n = jSONObject.getInt(KEY_TYPE);
            this.setType(n);
        }
        if (jSONObject.has(KEY_TITLE)) {
            this.setTitle(jSONObject.getString(KEY_TITLE));
        }
        if (jSONObject.has(KEY_TOKEN)) {
            this.setToken(jSONObject.getString(KEY_TOKEN));
        }
        if (jSONObject.has(KEY_SURVEY_EVENTS)) {
            this.target.d(com.instabug.survey.a.a.a.a(jSONObject.getJSONArray(KEY_SURVEY_EVENTS)));
        }
        if (jSONObject.has(KEY_QUESTIONS)) {
            this.setQuestions(b.a(jSONObject.getJSONArray(KEY_QUESTIONS)));
        }
        if (jSONObject.has(KEY_TARGET)) {
            JSONObject jSONObject2 = jSONObject.getJSONObject(KEY_TARGET);
            this.target.fromJson(jSONObject2.toString().replace("\\", ""));
        }
        if (jSONObject.has(KEY_ANSWERED)) {
            this.setAnswered(jSONObject.getBoolean(KEY_ANSWERED));
        }
        if (jSONObject.has(KEY_IS_CANCELLED)) {
            this.setCancelled(jSONObject.getBoolean(KEY_IS_CANCELLED));
        }
        if (jSONObject.has(KEY_SURVEY_STATE)) {
            this.setSurveyState(a.valueOf(jSONObject.getString(KEY_SURVEY_STATE)));
        }
        if (jSONObject.has(KEY_SHOULD_SHOW_AGAIN)) {
            this.setShouldShowAgain(jSONObject.getBoolean(KEY_SHOULD_SHOW_AGAIN));
        }
        if (jSONObject.has(KEY_SESSION_COUNTER)) {
            this.setSessionCounter(jSONObject.getInt(KEY_SESSION_COUNTER));
        }
        if (jSONObject.has(KEY_DISMISSED_AT)) {
            this.setDismissedAt(jSONObject.getInt(KEY_DISMISSED_AT));
        }
        if (jSONObject.has(KEY_SHOW_AT)) {
            this.setShowAt(jSONObject.getInt(KEY_SHOW_AT));
        }
        if (jSONObject.has(KEY_THANKS_LIST)) {
            JSONArray jSONArray = jSONObject.getJSONArray(KEY_THANKS_LIST);
            this.setThankYouItems(c.a(jSONArray));
        }
        this.localization.b(jSONObject);
    }

    public long getId() {
        return this.id;
    }

    public Survey setId(long id2) {
        this.id = id2;
        return this;
    }

    public void setThankYouItems(ArrayList<c> thankYouItems) {
        this.thankYouItems = thankYouItems;
    }

    public ArrayList<c> getThankYouItems() {
        return this.thankYouItems;
    }

    public boolean isAnswered() {
        return this.answered;
    }

    public void setAnswered(boolean answered) {
        this.answered = answered;
    }

    public void setShouldShowAgain(boolean shouldShowAgain) {
        this.shouldShowAgain = shouldShowAgain;
    }

    public com.instabug.survey.a.a.b getLocalization() {
        return this.localization;
    }

    public void setLocalization(com.instabug.survey.a.a.b localization) {
        this.localization = localization;
    }

    public void clearAnswers() {
        for (b b2 : this.questions) {
            b2.b((String)null);
        }
    }

    public boolean isLastEventSubmit() {
        return this.target.d() != null && this.target.d().size() > 0 && this.target.d().get(this.target.d().size() - 1).a() == a.a.SUBMIT;
    }

    public int hashCode() {
        return String.valueOf(this.getId()).hashCode();
    }

    public boolean equals(Object survey) {
        if (survey instanceof Survey) {
            Survey survey2 = (Survey)survey;
            return survey2.getId() == this.getId();
        }
        return false;
    }

    public static enum a {
        READY_TO_SEND,
        NOT_AVAILABLE,
        SYNCED;

    }
}

