/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.featuresrequest.cache;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.featuresrequest.d.b;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FeatureRequestCacheManager {
    private static final String TAG = "FeatureRequestCacheManager";
    public static final String FEATURES_REQUEST_DISK_CACHE_FILE_NAME = "/features_request.cache";
    public static final String FEATURES_REQUEST_DISK_CACHE_KEY = "features_request_disk_cache";
    public static final String FEATURES_REQUEST_MEMORY_CACHE_KEY = "features_request_memory_cache";
    public static final String FEATURES_REQUESTS_EXTRAS_DISK_CACHE_FILE_NAME = "/features_request_extras.cache";
    public static final String FEATURES_REQUESTS_EXTRAS_DISK_CACHE_KEY = "features_request_extras_disk_cache";
    public static final String FEATURES_REQUESTS_EXTRAS_MEMORY_CACHE_KEY = "features_request_extras_memory_cache";

    public static InMemoryCache<Long, b> getCache() throws IllegalArgumentException {
        if (!CacheManager.getInstance().cacheExists(FEATURES_REQUEST_MEMORY_CACHE_KEY)) {
            CacheManager.KeyExtractor<Long, b> keyExtractor;
            InstabugSDKLogger.d((Object)TAG, (String)("In-memory features requet cache not found, loading it from disk " + CacheManager.getInstance().getCache(FEATURES_REQUEST_MEMORY_CACHE_KEY)));
            CacheManager.KeyExtractor<Long, b> keyExtractor2 = keyExtractor;
            keyExtractor = new CacheManager.KeyExtractor<Long, b>(){

                public Long a(b b2) {
                    return b2.f();
                }
            };
            CacheManager.getInstance().migrateCache(FEATURES_REQUEST_DISK_CACHE_KEY, FEATURES_REQUEST_MEMORY_CACHE_KEY, (CacheManager.KeyExtractor)keyExtractor2);
            keyExtractor2 = CacheManager.getInstance().getCache(FEATURES_REQUEST_MEMORY_CACHE_KEY);
            if (keyExtractor2 != null) {
                InstabugSDKLogger.d((Object)TAG, (String)("In-memory Feature Request cache restored from disk, " + keyExtractor2.size() + " elements restored"));
            }
        }
        InstabugSDKLogger.d((Object)TAG, (String)"In-memory features request cache found");
        return (InMemoryCache)CacheManager.getInstance().getCache(FEATURES_REQUEST_MEMORY_CACHE_KEY);
    }

    @VisibleForTesting
    static void tearDown() {
        CacheManager.getInstance().deleteCache(FEATURES_REQUEST_MEMORY_CACHE_KEY);
        CacheManager.getInstance().deleteCache(FEATURES_REQUEST_DISK_CACHE_KEY);
    }

    public static void saveCacheToDisk() {
        int n;
        Cache cache = CacheManager.getInstance().getCache(FEATURES_REQUEST_DISK_CACHE_KEY);
        Cache cache2 = CacheManager.getInstance().getCache(FEATURES_REQUEST_MEMORY_CACHE_KEY);
        if (cache != null && cache2 != null) {
            InstabugSDKLogger.d((Object)TAG, (String)("Checking old values cached " + cache.getValues()));
            InstabugSDKLogger.addVerboseLog((Object)TAG, (String)("Saving In-memory feature requests cache to disk, no. of feature requests to save is " + cache2.size()));
            CacheManager.getInstance().migrateCache(cache2, cache, (CacheManager.KeyExtractor)new CacheManager.KeyExtractor<String, b>(){

                public String a(b b2) {
                    return String.valueOf(b2.f());
                }
            });
            n = cache.getValues().size();
        } else {
            n = 0;
        }
        InstabugSDKLogger.d((Object)TAG, (String)("In-memory feature requests cache had been persisted on-disk, " + n + " feautre reuests saved"));
    }

    public static void addFeatures(List<b> newFeatureRequests) {
        Iterator<b> iterator = newFeatureRequests.iterator();
        while (iterator.hasNext()) {
            FeatureRequestCacheManager.addFeature((b)iterator.next());
        }
    }

    public static void addFeature(b feature) {
        InMemoryCache<Long, b> inMemoryCache = FeatureRequestCacheManager.getCache();
        if (inMemoryCache != null) {
            b b2;
            inMemoryCache.put((Object)b2.f(), (Object)b2);
        }
    }

    public static List<b> getFeatures() {
        InMemoryCache<Long, b> inMemoryCache = FeatureRequestCacheManager.getCache();
        if (inMemoryCache != null) {
            return inMemoryCache.getValues();
        }
        return new ArrayList<b>();
    }

    @Nullable
    public static b getFeature(long featureId) {
        InMemoryCache<Long, b> inMemoryCache = FeatureRequestCacheManager.getCache();
        if (inMemoryCache != null) {
            for (b b2 : inMemoryCache.getValues()) {
                long l;
                if (b2.f() != l) continue;
                return b2;
            }
        }
        return null;
    }

    public static List<b> getVotesToUpload() {
        ArrayList<b> arrayList;
        ArrayList<b> arrayList2 = arrayList;
        arrayList = new ArrayList<b>();
        InMemoryCache<Long, b> inMemoryCache = FeatureRequestCacheManager.getCache();
        if (inMemoryCache != null) {
            List list = inMemoryCache.getValues();
            InstabugSDKLogger.d((Object)TAG, (String)("size: " + list.size()));
            arrayList2.addAll(list);
        }
        return arrayList2;
    }

    public static InMemoryCache<String, Object> getExtrasCache() throws IllegalArgumentException {
        if (!CacheManager.getInstance().cacheExists(FEATURES_REQUESTS_EXTRAS_MEMORY_CACHE_KEY)) {
            CacheManager.KeyExtractor<String, Object> keyExtractor;
            InstabugSDKLogger.d((Object)TAG, (String)("In-memory features request extas cache not found, loading it from disk " + CacheManager.getInstance().getCache(FEATURES_REQUESTS_EXTRAS_MEMORY_CACHE_KEY)));
            CacheManager.KeyExtractor<String, Object> keyExtractor2 = keyExtractor;
            keyExtractor = new CacheManager.KeyExtractor<String, Object>(){

                public String extractKey(Object object) {
                    return object instanceof Boolean ? "has_next_page" : "completed_features_count";
                }
            };
            CacheManager.getInstance().migrateCache(FEATURES_REQUESTS_EXTRAS_DISK_CACHE_KEY, FEATURES_REQUESTS_EXTRAS_MEMORY_CACHE_KEY, (CacheManager.KeyExtractor)keyExtractor2);
            keyExtractor2 = CacheManager.getInstance().getCache(FEATURES_REQUESTS_EXTRAS_MEMORY_CACHE_KEY);
            if (keyExtractor2 != null) {
                InstabugSDKLogger.d((Object)TAG, (String)("In-memory Feature Request extras cache restored from disk, " + keyExtractor2.size() + " elements restored"));
            }
        }
        InstabugSDKLogger.d((Object)TAG, (String)"In-memory features request extras cache found");
        return (InMemoryCache)CacheManager.getInstance().getCache(FEATURES_REQUESTS_EXTRAS_MEMORY_CACHE_KEY);
    }

    public static void saveExtrasCacheToDisk() {
        int n;
        Cache cache = CacheManager.getInstance().getCache(FEATURES_REQUESTS_EXTRAS_DISK_CACHE_KEY);
        Cache cache2 = CacheManager.getInstance().getCache(FEATURES_REQUESTS_EXTRAS_MEMORY_CACHE_KEY);
        if (cache != null && cache2 != null) {
            InstabugSDKLogger.d((Object)TAG, (String)("Checking old values cached " + cache.getValues()));
            InstabugSDKLogger.d((Object)TAG, (String)("Saving In-memory feature requests extras cache to disk, no. of feature requests to save is " + cache2.size()));
            CacheManager.getInstance().migrateCache(cache2, cache, (CacheManager.KeyExtractor)new CacheManager.KeyExtractor<String, Object>(){

                public String extractKey(Object object) {
                    return object instanceof Boolean ? "has_next_page" : "completed_features_count";
                }
            });
            n = cache.getValues().size();
        } else {
            n = 0;
        }
        InstabugSDKLogger.d((Object)TAG, (String)("In-memory feature requests extras cache had been persisted on-disk, " + n + " feauture requests extras saved"));
    }

    public static void setHasNextPage(boolean hasNextPage) {
        InMemoryCache<String, Object> inMemoryCache = FeatureRequestCacheManager.getExtrasCache();
        if (inMemoryCache != null) {
            boolean bl;
            inMemoryCache.put((Object)"has_next_page", (Object)bl);
        }
    }

    public static boolean hasNextPage() {
        InMemoryCache<String, Object> inMemoryCache = FeatureRequestCacheManager.getExtrasCache();
        if (inMemoryCache != null && inMemoryCache.get((Object)"has_next_page") != null) {
            return (Boolean)inMemoryCache.get((Object)"has_next_page");
        }
        return false;
    }

    public static int getCompletedFeaturesCount() {
        InMemoryCache<String, Object> inMemoryCache = FeatureRequestCacheManager.getExtrasCache();
        if (inMemoryCache != null && inMemoryCache.get((Object)"completed_features_count") != null) {
            return (Integer)inMemoryCache.get((Object)"completed_features_count");
        }
        return 0;
    }

    public static void setCompletedFeaturesCount(int count) {
        InMemoryCache<String, Object> inMemoryCache = FeatureRequestCacheManager.getExtrasCache();
        if (inMemoryCache != null) {
            int n;
            inMemoryCache.put((Object)"completed_features_count", (Object)n);
        }
    }
}

