/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.featuresrequest.ui.custom;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.CallSuper;
import android.support.annotation.LayoutRes;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewStub;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.instabug.featuresrequest.R;
import com.instabug.featuresrequest.ui.custom.IbFrRippleView;
import com.instabug.featuresrequest.ui.custom.f;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.ui.BaseContract;
import com.instabug.library.core.ui.BaseFragment;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.LocaleHelper;
import java.util.ArrayList;

public abstract class DynamicToolbarFragment<P extends BaseContract.Presenter>
extends BaseFragment<P>
implements View.OnClickListener {
    protected RelativeLayout toolbar;
    protected ArrayList<f> toolbarActionButtons = new ArrayList();
    private ImageButton closeButton;
    private LinearLayout actionButtonsLayout;

    @CallSuper
    protected void initViews(View view, Bundle bundle) {
        this.initToolbarViews(bundle);
        ViewStub viewStub = (ViewStub)this.findViewById(R.id.instabug_content);
        viewStub.setLayoutResource(this.getContentLayout());
        viewStub.inflate();
        this.initContentViews(view, bundle);
        this.setTitle(this.getTitle());
    }

    protected int getLayout() {
        return R.layout.ib_fr_toolbar_fragment;
    }

    protected abstract f getToolbarCloseActionButton();

    protected void initToolbarViews(Bundle bundle) {
        this.toolbar = (RelativeLayout)this.findViewById(R.id.ib_fr_toolbar_main);
        if (Instabug.getTheme() == InstabugColorTheme.InstabugColorThemeLight) {
            this.toolbar.setBackgroundColor(InstabugCore.getPrimaryColor());
        } else {
            this.toolbar.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.ib_fr_toolbar_dark_color));
        }
        this.actionButtonsLayout = (LinearLayout)this.toolbar.findViewById(R.id.ib_toolbar_action_btns_layout);
        this.closeButton = (ImageButton)this.findViewById(R.id.instabug_btn_toolbar_left);
        if (LocaleHelper.isRTL((Context)this.getContext())) {
            this.closeButton.setRotation(180.0f);
        }
        final f f2 = this.getToolbarCloseActionButton();
        this.closeButton.setImageResource(f2.a());
        this.closeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                f2.c().a();
            }
        });
        this.toolbarActionButtons.clear();
        this.addToolbarActionButtons();
        for (final f f3 : this.toolbarActionButtons) {
            switch (f3.d()) {
                case ICON: {
                    ImageView imageView = (ImageView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.ib_fr_toolbar_action_icon_view, null);
                    imageView.setImageResource(f3.a());
                    imageView.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            f3.c().a();
                        }
                    });
                    this.actionButtonsLayout.addView((View)imageView);
                    break;
                }
                case TEXT: {
                    TextView textView = (TextView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.ib_fr_toolbar_action_text_view, null);
                    textView.setText(f3.b());
                    textView.setContentDescription(this.getContext().getResources().getText(f3.b()));
                    textView.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            f3.c().a();
                        }
                    });
                    this.actionButtonsLayout.addView((View)textView);
                    break;
                }
                case VOTE: {
                    LinearLayout linearLayout = (LinearLayout)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.ib_fr_toolbar_action_vote_button, null);
                    TextView textView = (TextView)linearLayout.findViewById(R.id.ib_toolbar_vote_count);
                    IbFrRippleView ibFrRippleView = (IbFrRippleView)linearLayout.findViewById(R.id.ib_feature_request_toolbar_vote_action_layout);
                    textView.setText(f3.b());
                    ibFrRippleView.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            f3.c().a();
                        }
                    });
                    this.actionButtonsLayout.addView((View)linearLayout);
                    break;
                }
            }
        }
    }

    protected abstract void addToolbarActionButtons();

    protected abstract String getTitle();

    protected void setTitle(String string2) {
        if (this.rootView == null) {
            InstabugSDKLogger.v((Object)((Object)this), (String)"Calling setTitle before inflating the view! Ignoring call");
            return;
        }
        TextView textView = (TextView)this.findViewById(R.id.instabug_fragment_title);
        InstabugSDKLogger.v((Object)((Object)this), (String)("Setting fragment title to \"" + string2 + "\""));
        textView.setText((CharSequence)string2);
    }

    @LayoutRes
    protected abstract int getContentLayout();

    protected abstract void initContentViews(View var1, Bundle var2);

    public View findTextViewByTitle(@StringRes int n) {
        String string2 = this.getContext().getResources().getString(n);
        return this.findViewWithContentDescription((View)this.actionButtonsLayout, string2);
    }

    @Nullable
    public View findViewWithContentDescription(View view, String string2) {
        ArrayList arrayList = new ArrayList();
        view.findViewsWithText(arrayList, (CharSequence)string2, 2);
        View view2 = null;
        if (arrayList.size() > 0) {
            view2 = (View)arrayList.get(0);
        }
        return view2;
    }
}

