package com.instabug.featuresrequest.utils;

import androidx.annotation.StyleRes;

import com.instabug.featuresrequest.R;
import com.instabug.library.Feature;
import com.instabug.library.IBGFeature;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.core.InstabugCore;

/**
 * Created by mzelzoghbi on 2/15/18.
 */

public class FeatureRequestThemeResolver {
    public static
    @StyleRes
    int resolveTheme(InstabugColorTheme instabugTheme) {
        if (!InstabugCore.isFeatureEnabled(IBGFeature.CUSTOM_FONT)) {
            if (instabugTheme == InstabugColorTheme.InstabugColorThemeLight) {
                return R.style.IbFrLight;
            } else {
                return R.style.IbFrDark;
            }
        } else {
            return getCustomFontTheme(instabugTheme);
        }
    }

    @StyleRes
    private static int getCustomFontTheme(InstabugColorTheme instabugTheme) {
        if (instabugTheme == InstabugColorTheme.InstabugColorThemeLight) {
            return R.style.IbFrLight_CustomFont;
        } else {
            return R.style.IbFrDark_CustomFont;
        }
    }
}
