package com.instabug.featuresrequest.ui.featuresmain.mainmyfeatures;

import com.instabug.featuresrequest.models.FeatureRequest;
import com.instabug.featuresrequest.ui.base.BaseFeaturesListDao;

import java.util.ArrayList;
import java.util.List;

/**
 * @author hossam.
 */

public class MainMyFeaturesDao extends BaseFeaturesListDao {
    private static volatile MainMyFeaturesDao featuresListDaoInstance;
    private List<FeatureRequest> myFeatureRequestsList;

    private MainMyFeaturesDao() {
        if (featuresListDaoInstance != null) {
            throw new RuntimeException("Use getInstance() method to get the single instance" +
                    " of this class");
        }
        myFeatureRequestsList = new ArrayList<>();
    }

    public static MainMyFeaturesDao getInstance() {
        if (featuresListDaoInstance == null) {
            synchronized (MainMyFeaturesDao.class) {
                if (featuresListDaoInstance == null)
                    featuresListDaoInstance = new MainMyFeaturesDao();
            }
        }
        return featuresListDaoInstance;
    }

    @Override
    public List<FeatureRequest> getFeatures() {
        return myFeatureRequestsList;
    }

    @Override
    public int getCompletedFeaturesCount() {
        return 0;
    }

    @Override
    protected int getFeaturesCount() {
        return myFeatureRequestsList.size();
    }

    @Override
    protected FeatureRequest getFeatureByIndex(int index) {
        return myFeatureRequestsList.get(index);
    }

    @Override
    protected void addFeatures(List<FeatureRequest> featureRequests) {
        myFeatureRequestsList.addAll(featureRequests);
    }

    @Override
    protected void addFeature(FeatureRequest feature) {
        myFeatureRequestsList.add(feature);
    }

    @Override
    protected void destroy() {
        myFeatureRequestsList.clear();
    }
}
