package com.instabug.featuresrequest.ui.featuresmain.mainallfeatures;

import com.instabug.featuresrequest.models.FeatureRequest;
import com.instabug.featuresrequest.ui.base.BaseFeaturesListDao;

import java.util.ArrayList;
import java.util.List;

/**
 * @author hossam.
 */

public class MainAllFeaturesDao extends BaseFeaturesListDao {
    private static volatile MainAllFeaturesDao mainAllFeaturesDaoInstance;
    private List<FeatureRequest> allFeatureRequestsList;

    private MainAllFeaturesDao() {
        if (mainAllFeaturesDaoInstance != null) {
            throw new RuntimeException("Use getInstance() method to get the single instance" +
                    " of this class");
        }
        allFeatureRequestsList = new ArrayList<>();
    }

    public static MainAllFeaturesDao getInstance() {
        if (mainAllFeaturesDaoInstance == null) {
            synchronized (MainAllFeaturesDao.class) {
                if (mainAllFeaturesDaoInstance == null)
                    mainAllFeaturesDaoInstance = new MainAllFeaturesDao();
            }
        }
        return mainAllFeaturesDaoInstance;
    }

    @Override
    public List<FeatureRequest> getFeatures() {
        return allFeatureRequestsList;
    }

    @Override
    public int getCompletedFeaturesCount() {
        return 0;
    }

    @Override
    protected int getFeaturesCount() {
        return allFeatureRequestsList.size();
    }

    @Override
    protected FeatureRequest getFeatureByIndex(int index) {
        return allFeatureRequestsList.get(index);
    }

    @Override
    protected void addFeatures(List<FeatureRequest> featureRequests) {
        allFeatureRequestsList.addAll(featureRequests);
    }

    @Override
    protected void addFeature(FeatureRequest feature) {
        allFeatureRequestsList.add(feature);
    }

    @Override
    protected void destroy() {
        allFeatureRequestsList.clear();
    }
}
