package com.instabug.featuresrequest.ui;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.os.Bundle;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;

import com.instabug.featuresrequest.FeaturesRequestPlugin;
import com.instabug.featuresrequest.R;
import com.instabug.featuresrequest.ui.custom.ThanksActivity;
import com.instabug.featuresrequest.ui.featuredetails.FeatureRequestsDetailsFragment;
import com.instabug.featuresrequest.ui.featuresmain.FeaturesMainFragment;
import com.instabug.featuresrequest.utils.FeatureRequestThemeResolver;
import com.instabug.library.Instabug;
import com.instabug.library._InstabugActivity;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.coreeventbus.IBGCoreEventPublisher;
import com.instabug.library.core.eventbus.coreeventbus.IBGSdkCoreEvent;
import com.instabug.library.core.plugin.Plugin;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.UiUtils;
import com.instabug.library.view.IBGProgressDialog;

import java.util.List;

/**
 * Created by mohamedzakaria on 8/28/17.
 */

@SuppressLint("ERADICATE_FIELD_NOT_INITIALIZED")
public class FeaturesRequestActivity extends AppCompatActivity implements _InstabugActivity {
    IBGProgressDialog progressDialog;

    @Override
    @SuppressLint("STARVATION")
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        LocaleUtils.setLocale(this, InstabugCore.getLocale(this));

        if (Instabug.getTheme() != null) {
            setTheme(FeatureRequestThemeResolver.resolveTheme(Instabug.getTheme()));
        }

        super.onCreate(savedInstanceState);

        if (InstabugCore.isFullScreen()) {
            UiUtils.showInFullscreen(this.getWindow());
        }

        setContentView(R.layout.instabug_activity);

        if (savedInstanceState == null)
            getSupportFragmentManager().beginTransaction()
                    .replace(R.id.instabug_fragment_container, new FeaturesMainFragment())
                    .commit();

        setPluginVisibility(true);
    }

    @VisibleForTesting
    void setPluginVisibility(boolean isVisible) {
        FeaturesRequestPlugin plugin = (FeaturesRequestPlugin) InstabugCore.getXPlugin
                (FeaturesRequestPlugin.class);
        if (plugin != null) {
            if (isVisible) {
                plugin.setState(Plugin.STATE_FOREGROUND);
            } else {
                plugin.setState(Plugin.STATE_BACKGROUND);
                IBGCoreEventPublisher.post(IBGSdkCoreEvent.ForegroundAvailable.INSTANCE);
            }
        }
    }

    @Override
    public void onStop() {
        LocaleUtils.setAppLocale(this);
        super.onStop();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        setPluginVisibility(false);
    }

    public void showProgressDialog() {
        progressDialog = new IBGProgressDialog.Builder()
                .setMessage(getString(R.string.feature_requests_new_adding_your_suggestion))
                .setProgressColor(InstabugCore.getPrimaryColor())
                .build(this);
        progressDialog.show();
    }

    public void hideProgressDialog() {
        if (progressDialog != null)
            progressDialog.dismiss();
    }

    public void notifyCommentsChanged() {
        List<Fragment> fragments = getSupportFragmentManager().getFragments();
        for (Fragment fragment : fragments) {
            if (fragment instanceof FeatureRequestsDetailsFragment) {
                ((FeatureRequestsDetailsFragment) fragment).onNewCommentAdded();
                break;
            }
        }
    }

    @Override
    public void onBackPressed() {
        Fragment fragment = getSupportFragmentManager().findFragmentById(R.id.instabug_fragment_container);
        if (fragment instanceof OnBackPressedInterface && ((OnBackPressedInterface)fragment).onBackPressed()) {
            // Fragment handled the back press
            return;
        }
        super.onBackPressed();
    }

    public void showThanksDialog() {
        onBackPressed();

        List<Fragment> fragments = getSupportFragmentManager().getFragments();
        for (Fragment fragment : fragments) {
            if (fragment instanceof FeaturesMainFragment) {
                ((FeaturesMainFragment) fragment).refreshMyFeatures();
                break;
            }
        }
        startActivity(new Intent(this, ThanksActivity.class));
    }
}
