package com.instabug.featuresrequest;

import android.content.Context;

import com.instabug.featuresrequest.models.FeatureRequestResponse;
import com.instabug.featuresrequest.network.FeaturesRequestFetcher;
import com.instabug.library.util.InstabugSDKLogger;

import java.lang.ref.WeakReference;

/**
 * Created by mohamedzakaria on 9/5/17.
 */

public class FeaturesRequestManager implements FeaturesRequestFetcher.Callback {
    private static FeaturesRequestManager INSTANCE;

    private final WeakReference<Context> context;
    private final FeaturesRequestFetcher featuresRequestFetcher;


    private FeaturesRequestManager(Context context) {
        this.context = new WeakReference<>(context);
        featuresRequestFetcher = new FeaturesRequestFetcher(this);
    }

    private static void init(Context context) {
        INSTANCE = new FeaturesRequestManager(context);
    }

    public static FeaturesRequestManager getInstance(Context context) {
        if (INSTANCE == null) {
            init(context);
        }
        return INSTANCE;
    }

    @Override
    public void onFetchingSucceeded(final FeatureRequestResponse featureRequestResponse) {
        updateFeaturesRequests(featureRequestResponse);
    }

    @Override
    public void onFetchingFailed(Throwable error) {
        InstabugSDKLogger.e(Constants.LOG_TAG, "Features request fetching error ", error);
    }

    private void updateFeaturesRequests(FeatureRequestResponse newFeatureRequestsResponse) {
        // todo refactor with search implementation
    }
}
