package com.instabug.featuresrequest.ui.featuresmain;

import static com.instabug.featuresrequest.ui.custom.ToolbarActionButton.ViewType.ICON;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.Bundle;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.Toast;

import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.viewpager.widget.ViewPager;

import com.google.android.material.tabs.TabLayout;
import com.instabug.featuresrequest.R;
import com.instabug.featuresrequest.listeners.OnSortActionChangedListener;
import com.instabug.featuresrequest.listeners.OnTapSelectedListener;
import com.instabug.featuresrequest.settings.FeaturesRequestSettings;
import com.instabug.featuresrequest.ui.custom.DynamicToolbarFragment;
import com.instabug.featuresrequest.ui.custom.ToolbarActionButton;
import com.instabug.featuresrequest.ui.featuresmain.mainallfeatures.MainAllFeaturesFragment;
import com.instabug.featuresrequest.ui.featuresmain.mainmyfeatures.MainMyFeaturesFragment;
import com.instabug.featuresrequest.ui.newfeature.AddNewFeatureFragment;
import com.instabug.featuresrequest.utils.StringsUtils;
import com.instabug.featuresrequest.utils.ViewUtilsKt;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.PlaceHolderUtils;
import com.instabug.library.util.UiUtils;

import java.util.ArrayList;

/**
 * @author hossam.
 */

// no place for error here
@SuppressLint("ERADICATE_FIELD_NOT_INITIALIZED")
public class FeaturesMainFragment extends DynamicToolbarFragment<FeaturesMainPresenter>
        implements FeaturesMainContract.View, View.OnClickListener, OnTapSelectedListener {
    @Nullable
    TabLayout tabLayout;
    //tabs layout
    private FeaturesMainViewPagerAdapter featuresMainPagerAdapter;
    @Nullable
    private LinearLayout tabsContainer;
    @Nullable
    private ViewPager mViewPager;
    protected Boolean sortByTopVotedFeatures = false;
    private int mSortByAction = 1;

    private ArrayList<OnSortActionChangedListener> onSortActionChangedListeners;

    private MainAllFeaturesFragment mainAllFeaturesFragment;
    private MainMyFeaturesFragment mainMyFeaturesFragment;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setRetainInstance(true);
        presenter = new FeaturesMainPresenter(this);
        onSortActionChangedListeners = new ArrayList<>();
        mSortByAction = FeaturesRequestSettings.getLastSortByAction();
        sortByTopVotedFeatures = mSortByAction == 0;
    }

    @Override
    protected ToolbarActionButton getToolbarCloseActionButton() {
        return new ToolbarActionButton(R.drawable.ibg_core_ic_close, R.string.close,
                () -> {
                    if (presenter != null) {
                        presenter.onCloseButtonClicked();
                    }
                }, ICON);
    }

    @Override
    protected void addToolbarActionButtons() {
        // todo uncomment for search
//        toolbarActionButtons.add(new ToolbarActionButton(R.drawable.ibg_fr_ic_search, -1, new
//                ToolbarActionButton.OnToolbarButtonClick() {
//                    @Override
//                    public void onClick() {
//                        presenter.onSearchButtonClicked();
//                    }
//                }, ICON));

        toolbarActionButtons.add(new ToolbarActionButton(R.drawable.ibg_fr_ic_add_white_36dp, -1, () -> {
            if (presenter != null) {
                presenter.onAddFeatureButtonClicked();
            }
        }, ICON));
    }

    @Override
    @Nullable
    protected String getTitle() {
        return PlaceHolderUtils.getPlaceHolder(
                InstabugCustomTextPlaceHolder.Key.FEATURES_REQUEST,
                getLocalizedString(R.string.instabug_str_features_request_header));
    }

    @Override
    protected int getContentLayout() {
        return R.layout.ib_fr_features_main_fragment;
    }

    @Override
    protected void initContentViews(View rootView, @Nullable Bundle savedInstanceState) {
        // ViewPager and its adapters use support library
        // fragments, so use getSupportFragmentManager.
        featuresMainPagerAdapter =
                new FeaturesMainViewPagerAdapter(getChildFragmentManager(), this);
        initTabs();

        initSortingViews();

        handleThemeColors();
    }

    private void initSortingViews() {
        if (getContext() == null) return;
        //sorting layout
        FrameLayout sortingActionsLinearLayout = findViewById(R.id.sortingActionsLayoutRoot);
        Spinner sortingSpinner = findViewById(R.id.spinnerSortActions);
        ContextThemeWrapper contextThemeWrapper =
                Instabug.getTheme() == InstabugColorTheme.InstabugColorThemeLight ?
                        new ContextThemeWrapper(getContext(), R.style.InstabugSdkTheme_Light) :
                        new ContextThemeWrapper(getContext(), R.style.InstabugSdkTheme_Dark);

        UiUtils.avoidDropdownFocus(sortingSpinner);

        ArrayList<String> spinnerItems = new ArrayList<>();
        spinnerItems.add(StringsUtils.trimSortingStrings(getLocalizedString(R.string.sort_by_top_rated)));
        spinnerItems.add(StringsUtils.trimSortingStrings(getLocalizedString(R.string.sort_by_recently_updated)));

        // Create an empty ArrayAdapter
        SortingSpinnerAdapter adapter = new SortingSpinnerAdapter(contextThemeWrapper, R.layout.sorting_spinner_item, R.layout.sorting_spinner_drop_down_item, spinnerItems);

        sortingSpinner.setAdapter(adapter);

        sortingSpinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                adapter.setSelectedPosition(position);
                sortByTopVotedFeatures = position == 0;
                mSortByAction = position;
                FeaturesRequestSettings.setLastSortByAction(mSortByAction);
                publishSortEvent(sortByTopVotedFeatures);
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {
                //Nothing to do here
            }
        });
        if (sortByTopVotedFeatures) {
            sortingSpinner.setSelection(0);
        } else {
            sortingSpinner.setSelection(1);
        }
        if (sortingActionsLinearLayout != null) {
            sortingActionsLinearLayout.setOnClickListener(this);
        }


        if (sortByTopVotedFeatures) {
            sortingSpinner.setSelection(0);
        } else {
            sortingSpinner.setSelection(1);
        }
    }

    private void initTabs() {
        // Use a local allocation to overcome SpotBugs false-positive possible NPE warnings
        TabLayout tabLayout = findViewById(R.id.tab_layout);
        LinearLayout tabsContainer = findViewById(R.id.tabsContainer);
        ViewPager mViewPager = findViewById(R.id.pager);


        if (tabLayout == null || tabsContainer == null || mViewPager == null) return;
        if (Build.VERSION.SDK_INT > Build.VERSION_CODES.UPSIDE_DOWN_CAKE) {
            ViewUtilsKt.addSystemWindowInsetToPadding(tabsContainer,true,false,true,false);
        }

        tabLayout.addTab(tabLayout.newTab().setText(getLocalizedString(R.string
                .features_rq_main_fragment_tab1)));
        tabLayout.addTab(tabLayout.newTab().setText(getLocalizedString(R.string
                .features_rq_main_fragment_tab2)));
        tabLayout.setBackgroundColor(SettingsManager.getInstance().getPrimaryColor());
        tabLayout.setTabMode(TabLayout.MODE_SCROLLABLE);

        tabsContainer.setBackgroundColor(SettingsManager.getInstance().getPrimaryColor());
        mViewPager.setAdapter(featuresMainPagerAdapter);

        mViewPager.addOnPageChangeListener(new TabLayout.TabLayoutOnPageChangeListener(tabLayout));
        tabLayout.addOnTabSelectedListener(new TabLayout.BaseOnTabSelectedListener<TabLayout.Tab>() {
            @Override
            public void onTabSelected(TabLayout.Tab tab) {
                mViewPager.setCurrentItem(tab.getPosition());
            }

            @Override
            public void onTabUnselected(TabLayout.Tab tab) {
            }

            @Override
            public void onTabReselected(TabLayout.Tab tab) {
            }
        });
        this.tabLayout = tabLayout;
        this.tabsContainer = tabsContainer;
        this.mViewPager = mViewPager;
    }

    private void handleThemeColors() {
        // Use a local allocation to overcome SpotBugs false-positive possible NPE warnings
        TabLayout localTabLayout = tabLayout;
        if (tabsContainer == null || localTabLayout == null) return;

        if (Instabug.getTheme() == InstabugColorTheme.InstabugColorThemeLight) {
            tabsContainer.setBackgroundColor(SettingsManager.getInstance().getPrimaryColor());
            localTabLayout.setBackgroundColor(SettingsManager.getInstance().getPrimaryColor());
        } else {
            tabsContainer.setBackgroundColor(getResources().getColor(R.color
                    .ib_fr_toolbar_dark_color));
            localTabLayout.setBackgroundColor(getResources().getColor(R.color
                    .ib_fr_toolbar_dark_color));
        }
        tabLayout = localTabLayout;
    }

    @SuppressLint("STARVATION")
    @Override
    public void onClick(View view) {
        int id = view.getId();
        if (id == R.id.sortingActionsLayoutRoot) {
            showSortingActionMenu(view);
        }
    }

    @Override
    public void navigateToSearchScreen() {
        // was never implemented. so removed its code
    }

    @Override
    public void navigateToAddNewFeatureScreen() {
        if (getActivity() == null) return;
        getActivity().getSupportFragmentManager()
                .beginTransaction()
                .add(R.id.instabug_fragment_container, new AddNewFeatureFragment())
                .addToBackStack("search_features")
                .commit();
    }

    @Override
    public void showToast(String message) {
        if (getViewContext().getContext() != null) {
            Toast.makeText(getViewContext().getContext(), message, Toast.LENGTH_SHORT).show();
        }
    }

    @Override
    public void closeFeatureRequestsMainScreen() {
        finishActivity();
    }


    @Override
    public void showSortingActionMenu(final View v) {
        Spinner sortSpinner = findViewById(R.id.spinnerSortActions);
        if (sortSpinner != null) {
            sortSpinner.performClick();
        }
    }

    @Override
    public Fragment onTapSelected(int tapId) {
        switch (tapId) {
            default:
            case 0:
                if (mainAllFeaturesFragment == null) {
                    mainAllFeaturesFragment =
                            MainAllFeaturesFragment.newInstance(sortByTopVotedFeatures);
                    onSortActionChangedListeners.add(mainAllFeaturesFragment);
                }
                return mainAllFeaturesFragment;
            case 1:
                if (mainMyFeaturesFragment == null) {
                    mainMyFeaturesFragment =
                            MainMyFeaturesFragment.newInstance(sortByTopVotedFeatures);
                    onSortActionChangedListeners.add(mainMyFeaturesFragment);
                }
                return mainMyFeaturesFragment;
        }
    }

    void publishSortEvent(boolean sortByhTop) {
        for (OnSortActionChangedListener listener : onSortActionChangedListeners) {
            listener.onSortActionChanged(sortByhTop);
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        onSortActionChangedListeners = null;
    }

    public void refreshMyFeatures() {
        if (mViewPager != null) {
            mViewPager.setCurrentItem(1);
        }
        ((MainAllFeaturesFragment) featuresMainPagerAdapter.getItem(0)).onRefresh();
        ((MainMyFeaturesFragment) featuresMainPagerAdapter.getItem(1)).onRefresh();
    }
}
