package com.instabug.featuresrequest.settings;

/**
 * Contains Feature requests SDK settings that should be maintained
 * in-memory until application is terminated
 *
 * @author Hossam Hassan
 */
public class PerSessionSettings {
    private static PerSessionSettings perSessionSettings;

    private boolean newFeatureEmailFieldRequired = true;
    private boolean commenterEmailFieldRequired = true;
    private boolean userIdentificationStateEnabled = true;

    private PerSessionSettings() {
    }

    public synchronized static PerSessionSettings getInstance() {
        return perSessionSettings != null ? perSessionSettings : (perSessionSettings = new PerSessionSettings());
    }


    public void setNewFeatureEmailFieldRequired(boolean isRequired) {
        this.newFeatureEmailFieldRequired = isRequired;
    }

    public boolean isNewFeatureEmailFieldRequired() {
        return newFeatureEmailFieldRequired;
    }

    public void setCommenterEmailFieldRequired(boolean isRequires) {
        this.commenterEmailFieldRequired = isRequires;
    }

    public boolean isCommenterEmailFieldRequired() {
        return commenterEmailFieldRequired;
    }

    public boolean isUserIdentificationStateEnabled() {
        return userIdentificationStateEnabled;
    }

    public void setUserIdentificationStateEnabled(boolean userIdentificationStateEnabled) {
        this.userIdentificationStateEnabled = userIdentificationStateEnabled;
    }
}
