package com.instabug.featuresrequest.models;

import com.instabug.featuresrequest.Constants;
import com.instabug.featuresrequest.models.FeatureRequest.Status;
import com.instabug.library.util.InstabugSDKLogger;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by mzelzoghbi on 3/6/18.
 */

public class StatusChange extends TimelineObject {

    public static final String KEY_OLD_STATUS = "old_status";
    public static final String KEY_NEW_STATUS = "new_status";
    public static final String KEY_NEW_STATUS_COLOR_CODE = "new_status_color";
    public static final String KEY_OLD_STATUS_COLOR_CODE = "old_status_color";

    private Status oldStatus = Status.Open;
    private Status newStatus = Status.Open;
    private String newStatusColorCode = "#000000";
    private String oldStatusColorCode = "#000000";

    public Status getOldStatus() {
        return oldStatus;
    }

    public void setOldStatus(Status oldStatus) {
        this.oldStatus = oldStatus;
    }

    public Status getNewStatus() {
        return newStatus;
    }

    public void setNewStatus(Status newStatus) {
        this.newStatus = newStatus;
    }

    public void setNewStatusColorCode(String newStatusColorCode) {
        this.newStatusColorCode = newStatusColorCode;
    }

    public String getOldStatusColorCode() {
        return oldStatusColorCode;
    }

    public void setOldStatusColorCode(String oldStatusColorCode) {
        this.oldStatusColorCode = oldStatusColorCode;
    }

    public String getNewStatusColorCode() {
        return newStatusColorCode;
    }

    @Override
    public String toJson() throws JSONException {
        return new JSONObject()
                .put(KEY_CREATED_AT, getCreatedAt())
                .put(KEY_TYPE, getType())
                .put(KEY_OLD_STATUS, getOldStatus().toInt())
                .put(KEY_NEW_STATUS, getNewStatus().toInt())
                .put(KEY_OLD_STATUS_COLOR_CODE, getOldStatusColorCode())
                .put(KEY_NEW_STATUS_COLOR_CODE, getNewStatusColorCode())
                .toString();
    }

    @Override
    public void fromJson(String modelAsJson) throws JSONException {
        InstabugSDKLogger.v(Constants.LOG_TAG, modelAsJson);

        JSONObject statusChangeJsonObject = new JSONObject(modelAsJson);

        if (statusChangeJsonObject.has(KEY_CREATED_AT)) {
            setCreatedAt(statusChangeJsonObject.getLong(KEY_CREATED_AT));
        }

        if (statusChangeJsonObject.has(KEY_TYPE)) {
            String status = statusChangeJsonObject.getString(KEY_TYPE);
            switch (status) {
                default:
                case "comment":
                    setType(Type.COMMENT);
                    break;
                case "state_change":
                    setType(Type.STATUS_CHANE);
                    break;

            }
        }

        if (statusChangeJsonObject.has(KEY_OLD_STATUS)) {
            int type = statusChangeJsonObject.getInt(KEY_OLD_STATUS);
            switch (type) {
                case 0:
                    setOldStatus(Status.Open);
                    break;
                case 1:
                    setOldStatus(Status.Planned);
                    break;
                case 2:
                    setOldStatus(Status.InProgress);
                    break;
                case 3:
                    setOldStatus(Status.Completed);
                    break;
                case 4:
                    setOldStatus(Status.MaybeLater);
                    break;
                default:
                    break;
            }
        }

        if (statusChangeJsonObject.has(KEY_NEW_STATUS)) {
            int type = statusChangeJsonObject.getInt(KEY_NEW_STATUS);
            switch (type) {
                case 0:
                    setNewStatus(Status.Open);
                    break;
                case 1:
                    setNewStatus(Status.Planned);
                    break;
                case 2:
                    setNewStatus(Status.InProgress);
                    break;
                case 3:
                    setNewStatus(Status.Completed);
                    break;
                case 4:
                    setNewStatus(Status.MaybeLater);
                    break;
                default:
                    break;
            }
        }


        if (statusChangeJsonObject.has(KEY_NEW_STATUS_COLOR_CODE)) {
            setNewStatusColorCode(statusChangeJsonObject.getString(KEY_NEW_STATUS_COLOR_CODE));
        }

        if (statusChangeJsonObject.has(KEY_OLD_STATUS_COLOR_CODE)) {
            setOldStatusColorCode(statusChangeJsonObject.getString(KEY_OLD_STATUS_COLOR_CODE));
        }
    }
}
