/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.featuresrequest.ui.featuredetails;

import android.content.Context;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.ColorUtils;
import com.instabug.featuresrequest.R;
import com.instabug.featuresrequest.models.Comment;
import com.instabug.featuresrequest.models.StatusChange;
import com.instabug.featuresrequest.models.TimelineObject;
import com.instabug.featuresrequest.ui.featuredetails.FeaturesRequestsDetailsContract$View;
import com.instabug.featuresrequest.utils.DateUtils;
import com.instabug.featuresrequest.utils.DrawableUtils;
import com.instabug.featuresrequest.utils.StatusBinder;
import com.instabug.featuresrequest.utils.TextViewUtils;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.internal.storage.cache.AssetsCacheManager;
import com.instabug.library.model.AssetEntity;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.threading.PoolProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;

public class TimelineAdapter
extends BaseAdapter {
    ArrayList<TimelineObject> comments;
    FeaturesRequestsDetailsContract$View viewCallback;

    public TimelineAdapter(ArrayList<TimelineObject> arrayList, FeaturesRequestsDetailsContract$View featuresRequestsDetailsContract$View) {
        this.comments = arrayList;
        this.viewCallback = featuresRequestsDetailsContract$View;
    }

    private void bindStatus(Context objectArray, TimelineViewHolder timelineViewHolder, StatusChange statusChange) {
        if (timelineViewHolder.newStatus != null && (object = timelineViewHolder.newStatusDate) != null) {
            TimelineViewHolder timelineViewHolder2 = timelineViewHolder;
            object.setText(DateUtils.getTimeAgo((Context)objectArray, statusChange.getCreatedAt()));
            Object object = statusChange.getNewStatusColorCode();
            StatusBinder.bind(statusChange.getNewStatus(), (String)object, timelineViewHolder.newStatus, (Context)objectArray);
            timelineViewHolder2.newStatus.setTextColor(Color.parseColor((String)statusChange.getNewStatusColorCode()));
            TextView textView = timelineViewHolder2.newStatus;
            object = textView.getText();
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = object;
            textView.setText((CharSequence)String.format(" %1s", objectArray));
        }
    }

    private void bindAdminComment(Context context, TimelineViewHolder timelineViewHolder, Comment comment) {
        timelineAdapter.bindComment(context, timelineViewHolder, comment);
        TimelineAdapter timelineAdapter = timelineViewHolder.username;
        if (timelineAdapter != null) {
            TimelineAdapter timelineAdapter2 = timelineAdapter;
            timelineAdapter2.setTypeface(timelineAdapter2.getTypeface(), 1);
        }
        if ((timelineAdapter = timelineViewHolder.adminBackground) != null) {
            timelineAdapter.getBackground().setAlpha(13);
            if (Instabug.getTheme() == InstabugColorTheme.InstabugColorThemeLight) {
                DrawableUtils.setColor((View)timelineViewHolder.adminBackground, ColorUtils.setAlphaComponent((int)SettingsManager.getInstance().getPrimaryColor(), (int)255));
            } else {
                DrawableUtils.setColor((View)timelineViewHolder.adminBackground, ContextCompat.getColor((Context)context, (int)17170443));
            }
        }
    }

    private void loadImage(Context context, Comment comment, ImageView imageView) {
        PoolProvider.postIOTask(() -> this.lambda$loadImage$0(AssetsCacheManager.createEmptyEntity((Context)context, (String)comment.getAvatar(), (AssetEntity.AssetType)AssetEntity.AssetType.IMAGE), comment));
    }

    private /* synthetic */ void lambda$loadImage$0(AssetEntity object, final Comment comment) {
        AssetsCacheManager.OnDownloadFinished onDownloadFinished;
        AssetEntity assetEntity = object;
        object = onDownloadFinished;
        onDownloadFinished = new AssetsCacheManager.OnDownloadFinished(){

            public void onSuccess(final AssetEntity assetEntity) {
                PoolProvider.postMainThreadTask((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        1 v0 = this;
                        v0.comment.setAvatarFilePath(assetEntity.getFile().getAbsolutePath());
                        if (!v0.assetEntity.getFile().exists()) {
                            InstabugSDKLogger.e((String)"IBG-FR", (String)"Asset Entity downloading got FileNotFoundException error");
                        }
                        TimelineAdapter.this.notifyDataSetChanged();
                    }
                });
            }

            public void onFailed(Throwable throwable) {
                InstabugSDKLogger.e((String)"IBG-FR", (String)"Asset Entity downloading got error", (Throwable)throwable);
            }
        };
        AssetsCacheManager.getAssetEntity((AssetEntity)assetEntity, (AssetsCacheManager.OnDownloadFinished)object);
    }

    public int getCount() {
        return this.comments.size();
    }

    public Object getItem(int n) {
        return this.comments.get(n);
    }

    public long getItemId(int n) {
        return n;
    }

    public int getItemViewType(int n) {
        if (this.comments.get(n) instanceof Comment) {
            if (((Comment)this.comments.get(n)).isAdmin()) {
                return 1;
            }
            return 0;
        }
        return 2;
    }

    public View getView(int n, View view, ViewGroup object) {
        TimelineAdapter timelineAdapter;
        int n2 = timelineAdapter.getItemViewType(n);
        if (view == null) {
            TimelineViewHolder timelineViewHolder;
            view = n2 != 1 ? (n2 != 2 ? LayoutInflater.from((Context)object.getContext()).inflate(R.layout.ib_fr_item_comment, object, false) : LayoutInflater.from((Context)object.getContext()).inflate(R.layout.ib_fr_item_status_change, object, false)) : LayoutInflater.from((Context)object.getContext()).inflate(R.layout.ib_fr_item_admin_comment, object, false);
            object = timelineViewHolder;
            timelineViewHolder = new TimelineViewHolder(view);
            view.setTag(object);
        } else {
            object = (TimelineViewHolder)view.getTag();
        }
        if (n2 != 1) {
            if (n2 != 2) {
                TimelineAdapter timelineAdapter2 = timelineAdapter;
                timelineAdapter = view.getContext();
                Comment comment = (Comment)timelineAdapter2.getItem(n);
                timelineAdapter2.bindComment((Context)timelineAdapter, (TimelineViewHolder)object, comment);
            } else {
                TimelineAdapter timelineAdapter3 = timelineAdapter;
                timelineAdapter = view.getContext();
                StatusChange statusChange = (StatusChange)timelineAdapter3.getItem(n);
                timelineAdapter3.bindStatus((Context)timelineAdapter, (TimelineViewHolder)object, statusChange);
            }
        } else {
            TimelineAdapter timelineAdapter4 = timelineAdapter;
            timelineAdapter = view.getContext();
            Comment comment = (Comment)timelineAdapter4.getItem(n);
            timelineAdapter4.bindAdminComment((Context)timelineAdapter, (TimelineViewHolder)object, comment);
        }
        return view;
    }

    protected void bindComment(Context object, TimelineViewHolder object2, final Comment comment) {
        Object object3 = ((TimelineViewHolder)object2).username;
        if (object3 != null) {
            TextView textView = object3;
            textView.setTypeface(textView.getTypeface(), 0);
            object3 = ((TimelineViewHolder)object2).username;
            String string2 = comment.getCommenterName() != null && !comment.getCommenterName().equalsIgnoreCase("null") && !TextUtils.isEmpty((CharSequence)comment.getCommenterName().trim()) ? comment.getCommenterName() : LocaleUtils.getLocaleStringResource((Locale)Instabug.getLocale((Context)object), (int)R.string.feature_request_owner_anonymous_word, (Context)object);
            object3.setText((CharSequence)string2);
        }
        if (((TimelineViewHolder)object2).avatar != null) {
            if (comment.getAvatarFilePath() == null) {
                this.loadImage((Context)object, comment, ((TimelineViewHolder)object2).avatar);
                ((TimelineViewHolder)object2).avatar.setImageResource(R.drawable.ibg_core_ic_avatar);
            } else {
                try {
                    ((TimelineViewHolder)object2).avatar.setImageBitmap(BitmapFactory.decodeStream((InputStream)new FileInputStream(new File(comment.getAvatarFilePath()))));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    InstabugSDKLogger.e((String)"IBG-FR", (String)"Can't set avatar image in feature detail comments", (Throwable)fileNotFoundException);
                }
            }
        }
        if ((object3 = ((TimelineViewHolder)object2).date) != null) {
            object3.setText((CharSequence)DateUtils.getTimeAgo(object, comment.getCreatedAt()));
        }
        TimelineViewHolder timelineViewHolder = object2;
        Context context = object;
        object2 = LocaleUtils.getLocaleStringResource((Locale)Instabug.getLocale((Context)context), (int)R.string.feature_request_str_more, (Context)object);
        object = LocaleUtils.getLocaleStringResource((Locale)Instabug.getLocale((Context)context), (int)R.string.feature_request_str_less, (Context)object);
        object3 = timelineViewHolder.comment;
        if (object3 != null && object2 != null && object != null) {
            Runnable runnable;
            TextView textView = object3;
            Comment comment2 = comment;
            object3 = comment2.getBody();
            boolean bl = comment2.isLastViewmoreState();
            Runnable runnable2 = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    1 v0 = this;
                    Comment comment2 = v0.comment;
                    comment2.setLastViewmoreState(comment2.isLastViewmoreState() ^ true);
                    v0.TimelineAdapter.this.viewCallback.updateListHeight();
                }
            };
            TextViewUtils.makeTextViewResizable(textView, (String)object3, (String)object2, (String)object, bl, runnable2);
        }
    }

    public static class TimelineViewHolder {
        @Nullable
        public final RelativeLayout adminBackground;
        @Nullable
        public final ImageView avatar;
        @Nullable
        public final TextView username;
        @Nullable
        public final TextView date;
        @Nullable
        public final TextView comment;
        @Nullable
        public final TextView newStatus;
        @Nullable
        public final TextView newStatusDate;

        TimelineViewHolder(View view) {
            this.avatar = (ImageView)view.findViewById(R.id.instabug_feature_requests_comment_avatar);
            this.username = (TextView)view.findViewById(R.id.instabug_feature_requests_comment_username);
            this.date = (TextView)view.findViewById(R.id.instabug_feature_requests_comment_date);
            this.comment = (TextView)view.findViewById(R.id.instabug_feature_feature_details_comment);
            this.adminBackground = (RelativeLayout)view.findViewById(R.id.instabug_feature_request_admin_comment_layout);
            this.newStatus = (TextView)view.findViewById(R.id.instabug_feature_request_new_status);
            this.newStatusDate = (TextView)view.findViewById(R.id.instabug_feature_request_new_status_date);
        }
    }
}

