/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.featuresrequest.ui.featuredetails;

import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.instabug.featuresrequest.cache.FeatureRequestsDBHelper;
import com.instabug.featuresrequest.eventbus.FeatureRequestsEventBus;
import com.instabug.featuresrequest.models.FeatureRequest;
import com.instabug.featuresrequest.models.TimelineResponse;
import com.instabug.featuresrequest.network.service.FeaturesRequestVoteJob;
import com.instabug.featuresrequest.network.timelinerepository.FeatureRequestsRepository;
import com.instabug.featuresrequest.network.timelinerepository.RepositoryObserver;
import com.instabug.featuresrequest.ui.featuredetails.FeaturesRequestsDetailsContract$View;
import com.instabug.library.core.ui.BaseContract;
import com.instabug.library.core.ui.BasePresenter;
import com.instabug.library.util.threading.PoolProvider;
import org.json.JSONException;

public class FeaturesRequestsDetailsPresenter
extends BasePresenter<FeaturesRequestsDetailsContract$View>
implements BaseContract.Presenter,
RepositoryObserver<TimelineResponse> {
    @Nullable
    private final FeaturesRequestsDetailsContract$View viewInstance;
    @Nullable
    private FeatureRequestsRepository repository;

    public FeaturesRequestsDetailsPresenter(FeaturesRequestsDetailsContract$View featuresRequestsDetailsContract$View) {
        FeaturesRequestsDetailsPresenter featuresRequestsDetailsPresenter = this;
        super((BaseContract.View)featuresRequestsDetailsContract$View);
        featuresRequestsDetailsPresenter.viewInstance = (FeaturesRequestsDetailsContract$View)featuresRequestsDetailsPresenter.view.get();
        if (featuresRequestsDetailsContract$View.getViewContext() != null && ((Fragment)featuresRequestsDetailsContract$View.getViewContext()).getContext() != null) {
            this.repository = FeatureRequestsRepository.getInstance();
        }
    }

    private void vote(FeatureRequest featureRequest) {
        FeatureRequest featureRequest2 = featureRequest;
        featureRequest2.setUserVoteStatus(FeatureRequest.UserVoteStatus.USER_VOTED_UP);
        try {
            FeatureRequestsDBHelper.insert(featureRequest2);
        }
        catch (JSONException jSONException) {}
        this.submitVote();
        FeatureRequestsEventBus.getInstance().post(featureRequest);
    }

    private void submitVote() {
        FeaturesRequestsDetailsContract$View featuresRequestsDetailsContract$View = ((FeaturesRequestsDetailsPresenter)((Object)featuresRequestsDetailsContract$View)).viewInstance;
        if (featuresRequestsDetailsContract$View == null) {
            return;
        }
        if (((Fragment)featuresRequestsDetailsContract$View.getViewContext()).getContext() != null) {
            FeaturesRequestVoteJob.getInstance().start();
        }
    }

    private void unVote(FeatureRequest featureRequest) {
        FeatureRequest featureRequest2 = featureRequest;
        featureRequest2.setUserVoteStatus(FeatureRequest.UserVoteStatus.USER_UN_VOTED);
        try {
            FeatureRequestsDBHelper.insert(featureRequest2);
        }
        catch (JSONException jSONException) {}
        this.submitVote();
        FeatureRequestsEventBus.getInstance().post(featureRequest);
    }

    public void onBackBtnClicked() {
        FeaturesRequestsDetailsContract$View featuresRequestsDetailsContract$View = ((FeaturesRequestsDetailsPresenter)((Object)featuresRequestsDetailsContract$View)).viewInstance;
        if (featuresRequestsDetailsContract$View != null) {
            featuresRequestsDetailsContract$View.handleBackBtnClicked();
        }
    }

    public void onVoteButtonClick(FeatureRequest featureRequest) {
        if (featureRequest.isLiked()) {
            FeatureRequest featureRequest2 = featureRequest;
            featureRequest2.setLiked(false);
            featureRequest2.setLikesCount(featureRequest2.getLikesCount() - 1);
            ((FeaturesRequestsDetailsPresenter)((Object)featuresRequestsDetailsContract$View)).unVote(featureRequest2);
        } else {
            FeatureRequest featureRequest3 = featureRequest;
            featureRequest3.setLiked(true);
            featureRequest3.setLikesCount(featureRequest3.getLikesCount() + 1);
            ((FeaturesRequestsDetailsPresenter)((Object)featuresRequestsDetailsContract$View)).vote(featureRequest3);
        }
        FeaturesRequestsDetailsContract$View featuresRequestsDetailsContract$View = ((FeaturesRequestsDetailsPresenter)((Object)featuresRequestsDetailsContract$View)).viewInstance;
        if (featuresRequestsDetailsContract$View != null) {
            featuresRequestsDetailsContract$View.updateVote(featureRequest);
        }
    }

    public void getFeatureTimeline(long l) {
        PoolProvider.postIOTask(() -> {
            FeatureRequestsRepository featureRequestsRepository = this.repository;
            if (featureRequestsRepository != null) {
                featureRequestsRepository.getFeatureTimeline(l, this);
            }
        });
    }

    @Override
    public void onDataChanged(final TimelineResponse timelineResponse) {
        PoolProvider.postMainThreadTask((Runnable)new Runnable(){

            @Override
            public void run() {
                if (FeaturesRequestsDetailsPresenter.this.viewInstance == null) {
                    return;
                }
                if (timelineResponse.getTimelineObjects() != null && timelineResponse.getTimelineObjects().size() > 0) {
                    1 v0 = this;
                    v0.FeaturesRequestsDetailsPresenter.this.viewInstance.showComments(timelineResponse);
                    v0.FeaturesRequestsDetailsPresenter.this.viewInstance.handelCompletedFeaturesActions();
                } else {
                    FeaturesRequestsDetailsPresenter.this.viewInstance.showNoCommentsLayout();
                }
            }
        });
    }

    @Override
    public void onError(Throwable throwable) {
        throwable.printStackTrace();
    }
}

