/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.featuresrequest.ui.custom;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import com.instabug.featuresrequest.R;

public class SnackbarLayout
extends LinearLayout {
    @Nullable
    private TextView mMessageView;
    @Nullable
    private Button mActionView;
    public int mMaxWidth;
    private int mMaxInlineActionWidth;
    @Nullable
    private OnLayoutChangeListener mOnLayoutChangeListener;
    @Nullable
    private OnAttachStateChangeListener mOnAttachStateChangeListener;

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public SnackbarLayout(Context context) {
        this(context, null);
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public SnackbarLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        attributeSet = context.obtainStyledAttributes(attributeSet, R.styleable.SnackbarLayout);
        this.mMaxWidth = attributeSet.getDimensionPixelSize(R.styleable.SnackbarLayout_android_maxWidth, -1);
        this.mMaxInlineActionWidth = attributeSet.getDimensionPixelSize(R.styleable.SnackbarLayout_maxActionInlineWidth, -1);
        if (attributeSet.hasValue(R.styleable.SnackbarLayout_elevation)) {
            ViewCompat.setElevation((View)this, (float)attributeSet.getDimensionPixelSize(R.styleable.SnackbarLayout_elevation, 0));
        }
        attributeSet.recycle();
        this.setClickable(true);
        LayoutInflater.from((Context)context).inflate(R.layout.ib_fr_insta_toast_include, (ViewGroup)this);
        ViewCompat.setAccessibilityLiveRegion((View)this, (int)1);
    }

    private boolean updateViewsWithinLayout(int n, int n2, int n3) {
        TextView textView;
        boolean bl = false;
        if (n != this.getOrientation()) {
            this.setOrientation(n);
            bl = true;
        }
        if ((textView = this.mMessageView) != null && (textView.getPaddingTop() != n2 || this.mMessageView.getPaddingBottom() != n3)) {
            SnackbarLayout.updateTopBottomPadding((View)this.mMessageView, n2, n3);
            bl = true;
        }
        return bl;
    }

    private static void updateTopBottomPadding(View view, int n, int n2) {
        if (ViewCompat.isPaddingRelative((View)view)) {
            View view2 = view;
            int n3 = ViewCompat.getPaddingStart((View)view2);
            int n4 = ViewCompat.getPaddingEnd((View)view2);
            ViewCompat.setPaddingRelative((View)view2, (int)n3, (int)n, (int)n4, (int)n2);
        } else {
            View view3 = view;
            int n5 = view3.getPaddingLeft();
            int n6 = view3.getPaddingRight();
            view3.setPadding(n5, n, n6, n2);
        }
    }

    protected void onFinishInflate() {
        SnackbarLayout snackbarLayout = this;
        super.onFinishInflate();
        snackbarLayout.mMessageView = (TextView)snackbarLayout.findViewById(R.id.snackbar_text);
        snackbarLayout.mActionView = (Button)snackbarLayout.findViewById(R.id.snackbar_action);
    }

    @Nullable
    TextView getMessageView() {
        return this.mMessageView;
    }

    @Nullable
    Button getActionView() {
        return this.mActionView;
    }

    protected void onMeasure(int n, int n2) {
        block7: {
            block8: {
                boolean bl;
                int n3;
                int n4;
                block6: {
                    SnackbarLayout snackbarLayout = this;
                    super.onMeasure(n, n2);
                    if (snackbarLayout.mMaxWidth > 0) {
                        n4 = this.mMaxWidth;
                        if (this.getMeasuredWidth() > n4) {
                            n = View.MeasureSpec.makeMeasureSpec((int)n4, (int)0x40000000);
                            super.onMeasure(n, n2);
                        }
                    }
                    SnackbarLayout snackbarLayout2 = this;
                    n4 = snackbarLayout2.getResources().getDimensionPixelSize(R.dimen.ib_fr_toast_multi_line_padding);
                    n3 = snackbarLayout2.getResources().getDimensionPixelSize(R.dimen.ib_fr_toast_single_line_padding);
                    TextView textView = snackbarLayout2.mMessageView;
                    bl = textView != null && textView.getLayout().getLineCount() > 1;
                    Button button = this.mActionView;
                    if (button == null || !bl || this.mMaxInlineActionWidth <= 0 || button.getMeasuredWidth() <= this.mMaxInlineActionWidth) break block6;
                    int n5 = n4;
                    if (!this.updateViewsWithinLayout(1, n5, n5)) break block7;
                    break block8;
                }
                if (!bl) {
                    n4 = n3;
                }
                int n6 = n4;
                if (!this.updateViewsWithinLayout(0, n6, n6)) break block7;
            }
            super.onMeasure(n, n2);
        }
    }

    void animateChildrenIn(int n, int n2) {
        TextView textView = this.mMessageView;
        if (textView != null) {
            ViewCompat.setAlpha((View)textView, (float)0.0f);
            ViewCompat.animate((View)this.mMessageView).alpha(1.0f).setDuration((long)n2).setStartDelay((long)n).start();
        }
        if ((textView = this.mActionView) != null && textView.getVisibility() == 0) {
            SnackbarLayout snackbarLayout = this;
            ViewCompat.setAlpha((View)snackbarLayout.mActionView, (float)0.0f);
            ViewCompat.animate((View)snackbarLayout.mActionView).alpha(1.0f).setDuration((long)n2).setStartDelay((long)n).start();
        }
    }

    void animateChildrenOut(int n, int n2) {
        TextView textView = this.mMessageView;
        if (textView != null) {
            ViewCompat.setAlpha((View)textView, (float)1.0f);
            ViewCompat.animate((View)this.mMessageView).alpha(0.0f).setDuration((long)n2).setStartDelay((long)n).start();
        }
        if ((textView = this.mActionView) != null && textView.getVisibility() == 0) {
            SnackbarLayout snackbarLayout = this;
            ViewCompat.setAlpha((View)snackbarLayout.mActionView, (float)1.0f);
            ViewCompat.animate((View)snackbarLayout.mActionView).alpha(0.0f).setDuration((long)n2).setStartDelay((long)n).start();
        }
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        OnLayoutChangeListener onLayoutChangeListener;
        super.onLayout(bl, n, n2, n3, n4);
        if (bl && (onLayoutChangeListener = this.mOnLayoutChangeListener) != null) {
            onLayoutChangeListener.onLayoutChange((View)this, n, n2, n3, n4);
        }
    }

    protected void onAttachedToWindow() {
        SnackbarLayout snackbarLayout = this;
        super.onAttachedToWindow();
        OnAttachStateChangeListener onAttachStateChangeListener = snackbarLayout.mOnAttachStateChangeListener;
        if (onAttachStateChangeListener != null) {
            onAttachStateChangeListener.onViewAttachedToWindow((View)this);
        }
    }

    protected void onDetachedFromWindow() {
        SnackbarLayout snackbarLayout = this;
        super.onDetachedFromWindow();
        OnAttachStateChangeListener onAttachStateChangeListener = snackbarLayout.mOnAttachStateChangeListener;
        if (onAttachStateChangeListener != null) {
            onAttachStateChangeListener.onViewDetachedFromWindow((View)this);
        }
    }

    void setOnLayoutChangeListener(OnLayoutChangeListener onLayoutChangeListener) {
        this.mOnLayoutChangeListener = onLayoutChangeListener;
    }

    void setOnAttachStateChangeListener(OnAttachStateChangeListener onAttachStateChangeListener) {
        this.mOnAttachStateChangeListener = onAttachStateChangeListener;
    }

    static interface OnLayoutChangeListener {
        public void onLayoutChange(View var1, int var2, int var3, int var4, int var5);
    }

    static interface OnAttachStateChangeListener {
        public void onViewAttachedToWindow(View var1);

        public void onViewDetachedFromWindow(View var1);
    }
}

