/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.featuresrequest.ui.base.featureslist;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.text.Html;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.annotation.Nullable;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.content.ContextCompat;
import com.instabug.featuresrequest.R;
import com.instabug.featuresrequest.listeners.OnFeatureClickListener;
import com.instabug.featuresrequest.models.FeatureRequest;
import com.instabug.featuresrequest.ui.custom.IbFrRippleView;
import com.instabug.featuresrequest.utils.DateUtils;
import com.instabug.featuresrequest.utils.DrawableUtils;
import com.instabug.featuresrequest.utils.FormatterUtils;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.AttrResolver;

public class FeatureHolder {
    @Nullable
    private final TextView voteText;
    @Nullable
    private final ImageView voteIcon;
    @Nullable
    private final TextView title;
    @Nullable
    private final TextView tvVotesCount;
    @Nullable
    private final TextView tvCommentsCount;
    @Nullable
    private final TextView status;
    @Nullable
    private final TextView tvDate;
    @Nullable
    private final IbFrRippleView voteLayout;
    private final OnFeatureClickListener onFeatureClickListener;
    private final View view;

    FeatureHolder(View view, OnFeatureClickListener onFeatureClickListener) {
        this.view = view;
        this.onFeatureClickListener = onFeatureClickListener;
        this.voteText = (TextView)view.findViewById(R.id.instabug_txt_feature_request_vote_txt);
        this.voteIcon = (ImageView)view.findViewById(R.id.instabug_txt_feature_request_vote_icon);
        this.title = (TextView)view.findViewById(R.id.instabug_txt_feature_request_title);
        this.tvVotesCount = (TextView)view.findViewById(R.id.instabug_txt_feature_request_vote_count);
        this.tvCommentsCount = (TextView)view.findViewById(R.id.instabug_txt_feature_request_comment_count);
        this.status = (TextView)view.findViewById(R.id.instabug_txt_feature_request_status);
        this.tvDate = (TextView)view.findViewById(R.id.instabug_txt_feature_request_date);
        this.voteLayout = (IbFrRippleView)view.findViewById(R.id.ib_btn_fr_vote);
    }

    private void setFeatureStateColor(FeatureRequest featureRequest, FeatureHolder featureHolder, Context context, @ColorRes int n) {
        if (featureRequest.getColorCode() != null) {
            DrawableUtils.setColor((View)featureHolder.status, Color.parseColor((String)featureRequest.getColorCode()));
        } else {
            DrawableUtils.setColor((View)featureHolder.status, ContextCompat.getColor((Context)context, (int)n));
        }
    }

    public void setFeatureTitle(String string2) {
        FeatureHolder featureHolder = featureHolder.title;
        if (featureHolder != null) {
            if (Build.VERSION.SDK_INT >= 24) {
                featureHolder.setText((CharSequence)Html.fromHtml((String)string2, (int)63));
            } else {
                featureHolder.setText((CharSequence)Html.fromHtml((String)string2));
            }
        }
    }

    public void setFeatureStateColor(FeatureRequest featureRequest) {
        if (this.status != null && this.voteLayout != null) {
            switch (2.$SwitchMap$com$instabug$featuresrequest$models$FeatureRequest$Status[featureRequest.getStatus().ordinal()]) {
                default: {
                    break;
                }
                case 5: {
                    this.status.setText(R.string.ib_feature_rq_status_maybe_later);
                    Context context = this.view.getContext();
                    int n = R.color.ib_fr_color_maybe_later;
                    this.setFeatureStateColor(featureRequest, this, context, n);
                    this.voteLayout.setEnabled(true);
                    break;
                }
                case 4: {
                    this.status.setText(R.string.ib_feature_rq_status_open);
                    Context context = this.view.getContext();
                    int n = R.color.ib_fr_color_opened;
                    this.setFeatureStateColor(featureRequest, this, context, n);
                    this.voteLayout.setEnabled(true);
                    break;
                }
                case 3: {
                    this.status.setText(R.string.ib_feature_rq_status_planned);
                    Context context = this.view.getContext();
                    int n = R.color.ib_fr_color_planned;
                    this.setFeatureStateColor(featureRequest, this, context, n);
                    this.voteLayout.setEnabled(true);
                    break;
                }
                case 2: {
                    this.status.setText(R.string.ib_feature_rq_status_inprogress);
                    Context context = this.view.getContext();
                    int n = R.color.ib_fr_color_in_progress;
                    this.setFeatureStateColor(featureRequest, this, context, n);
                    this.voteLayout.setEnabled(true);
                    break;
                }
                case 1: {
                    this.status.setText(R.string.ib_feature_rq_status_completed);
                    Context context = this.view.getContext();
                    int n = R.color.ib_fr_color_completed;
                    this.setFeatureStateColor(featureRequest, this, context, n);
                    this.voteLayout.setEnabled(false);
                }
            }
        }
    }

    public void setCommentsCount(int n) {
        FeatureHolder featureHolder = featureHolder.tvCommentsCount;
        if (featureHolder != null) {
            featureHolder.setText(FormatterUtils.formatNumber(String.valueOf(n)));
        }
    }

    public void setVotesCount(int n) {
        FeatureHolder featureHolder = featureHolder.tvVotesCount;
        if (featureHolder != null) {
            featureHolder.setText(FormatterUtils.formatNumber(String.valueOf(n)));
        }
    }

    public void setCreationDate(long l) {
        TextView textView = this.tvDate;
        if (textView != null) {
            textView.setText((CharSequence)DateUtils.getTimeAgo(this.view.getContext(), l));
        }
    }

    public void setVoteButtonStyle(Boolean bl) {
        ImageView imageView = this.voteIcon;
        if (imageView != null && this.voteText != null && this.tvVotesCount != null) {
            imageView.setImageDrawable(AppCompatResources.getDrawable((Context)this.view.getContext(), (int)R.drawable.ibg_fr_ic_vote_arrow));
            if (bl.booleanValue()) {
                this.voteIcon.setColorFilter(ContextCompat.getColor((Context)this.view.getContext(), (int)R.color.ib_fr_white));
                DrawableUtils.setColor((View)this.voteLayout, SettingsManager.getInstance().getPrimaryColor());
                this.tvVotesCount.setTextColor(ContextCompat.getColor((Context)this.view.getContext(), (int)17170443));
                this.voteText.setTextColor(ContextCompat.getColor((Context)this.view.getContext(), (int)17170443));
            } else {
                DrawableUtils.setColor((View)this.voteLayout, 17170443);
                if (Instabug.getTheme() == InstabugColorTheme.InstabugColorThemeLight) {
                    this.voteIcon.setColorFilter(ContextCompat.getColor((Context)this.view.getContext(), (int)R.color.ib_fr_color_ptr_loading_txt));
                    this.tvVotesCount.setTextColor(ContextCompat.getColor((Context)this.view.getContext(), (int)R.color.ib_fr_color_ptr_loading_txt));
                    this.voteText.setTextColor(ContextCompat.getColor((Context)this.view.getContext(), (int)R.color.ib_fr_color_ptr_loading_txt));
                } else {
                    this.voteIcon.setColorFilter(ContextCompat.getColor((Context)this.view.getContext(), (int)R.color.ib_fr_vote_text_dark));
                    this.tvVotesCount.setTextColor(AttrResolver.getColor((Context)this.view.getContext(), (int)R.attr.instabug_fr_text_color));
                    this.voteText.setTextColor(AttrResolver.getColor((Context)this.view.getContext(), (int)R.attr.instabug_fr_text_color));
                }
            }
        }
    }

    public void setVoteButtonListener(final FeatureRequest featureRequest) {
        IbFrRippleView ibFrRippleView = this.voteLayout;
        if (ibFrRippleView != null) {
            View.OnClickListener onClickListener;
            IbFrRippleView ibFrRippleView2 = ibFrRippleView;
            ibFrRippleView = onClickListener;
            onClickListener = new View.OnClickListener(){

                @SuppressLint(value={"STARVATION"})
                public void onClick(View view) {
                    if (featureRequest.isLiked()) {
                        1 v0 = this;
                        FeatureRequest featureRequest2 = v0.featureRequest;
                        featureRequest2.setLikesCount(featureRequest2.getLikesCount() - 1);
                        v0.featureRequest.setLiked(false);
                        v0.FeatureHolder.this.setVoteButtonStyle(featureRequest.isLiked());
                        ((IbFrRippleView)view).setRippleColor(Color.parseColor((String)"#888888"));
                        FeatureHolder.this.onFeatureClickListener.onUnVote(featureRequest);
                    } else {
                        1 v2 = this;
                        1 v3 = this;
                        v3.featureRequest.setLiked(true);
                        FeatureRequest featureRequest3 = v3.featureRequest;
                        featureRequest3.setLikesCount(featureRequest3.getLikesCount() + 1);
                        ((IbFrRippleView)view).setRippleColor(Color.parseColor((String)"#ffffff"));
                        v2.FeatureHolder.this.setVoteButtonStyle(featureRequest.isLiked());
                        v2.FeatureHolder.this.onFeatureClickListener.onVote(featureRequest);
                    }
                }
            };
            ibFrRippleView2.setOnClickListener((View.OnClickListener)ibFrRippleView);
        }
    }
}

