/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.featuresrequest.ui.addcomment;

import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.instabug.featuresrequest.models.NewComment;
import com.instabug.featuresrequest.network.timelinerepository.FeatureRequestsRepository;
import com.instabug.featuresrequest.network.timelinerepository.RepositoryObserver;
import com.instabug.featuresrequest.settings.FeaturesRequestSettings;
import com.instabug.featuresrequest.ui.addcomment.AddCommentContract$View;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.ui.BaseContract;
import com.instabug.library.core.ui.BasePresenter;
import com.instabug.library.util.threading.PoolProvider;
import org.json.JSONObject;

public class AddCommentPresenter
extends BasePresenter<AddCommentContract$View>
implements RepositoryObserver<JSONObject> {
    @Nullable
    private FeatureRequestsRepository repository;
    @Nullable
    private final AddCommentContract$View viewInstance;
    @Nullable
    private volatile String enteredEmail;

    public AddCommentPresenter(AddCommentContract$View addCommentContract$View) {
        AddCommentPresenter addCommentPresenter = this;
        super((BaseContract.View)addCommentContract$View);
        PoolProvider.postIOTask(() -> {
            this.enteredEmail = InstabugCore.getEnteredEmail();
        });
        addCommentPresenter.viewInstance = (AddCommentContract$View)addCommentPresenter.view.get();
        if (addCommentContract$View.getViewContext() != null && ((Fragment)addCommentContract$View.getViewContext()).getContext() != null) {
            this.repository = FeatureRequestsRepository.getInstance();
        }
    }

    private static boolean isUserIdentificationStateEnabled() {
        return FeaturesRequestSettings.getInstance().isUserIdentificationStateEnabled();
    }

    private /* synthetic */ void lambda$fillEmailAndName$1(String string2, String string3) {
        AddCommentContract$View addCommentContract$View = this.viewInstance;
        if (addCommentContract$View != null) {
            if (string2 != null) {
                addCommentContract$View.setUserName(string2);
            }
            if (string3 != null) {
                this.viewInstance.setUserEmail(string3);
            }
        }
    }

    public void onCloseButtonClicked() {
        AddCommentContract$View addCommentContract$View = ((AddCommentPresenter)((Object)addCommentContract$View)).viewInstance;
        if (addCommentContract$View != null) {
            addCommentContract$View.onCloseButtonClicked();
        }
    }

    public void onAddCommentButtonClicked() {
        AddCommentContract$View addCommentContract$View = ((AddCommentPresenter)((Object)addCommentContract$View)).viewInstance;
        if (addCommentContract$View != null) {
            addCommentContract$View.validate();
        }
    }

    public void fillEmailAndName() {
        PoolProvider.postIOTask(() -> {
            AddCommentPresenter addCommentPresenter = string2;
            String string2 = addCommentPresenter.getEnteredUsername();
            PoolProvider.postMainThreadTask(() -> addCommentPresenter.lambda$fillEmailAndName$1(string2, addCommentPresenter.getEnteredEmail()));
        });
    }

    public void addComment(NewComment newComment) {
        FeatureRequestsRepository featureRequestsRepository;
        if (this.viewInstance != null) {
            if (AddCommentPresenter.isUserIdentificationStateEnabled()) {
                AddCommentPresenter addCommentPresenter = this;
                InstabugCore.setEnteredUsername((String)addCommentPresenter.viewInstance.getUsername());
                InstabugCore.setEnteredEmail((String)addCommentPresenter.viewInstance.getEmail());
            }
            this.viewInstance.showLoadingDialog();
        }
        if ((featureRequestsRepository = this.repository) != null) {
            featureRequestsRepository.addComment(newComment, this);
        }
    }

    @Override
    public void onDataChanged(JSONObject jSONObject) {
        PoolProvider.postMainThreadTask((Runnable)new Runnable(){

            @Override
            public void run() {
                if (AddCommentPresenter.this.viewInstance != null) {
                    1 v0 = this;
                    v0.AddCommentPresenter.this.viewInstance.dismissLoadingDialog();
                    v0.AddCommentPresenter.this.viewInstance.onCommentAddedSuccessfully();
                }
            }
        });
    }

    @Override
    public void onError(Throwable throwable) {
        PoolProvider.postMainThreadTask((Runnable)new Runnable(){

            @Override
            public void run() {
                if (AddCommentPresenter.this.viewInstance != null) {
                    2 v0 = this;
                    v0.AddCommentPresenter.this.viewInstance.dismissLoadingDialog();
                    v0.AddCommentPresenter.this.viewInstance.showError();
                }
            }
        });
    }

    public boolean isCommenterEmailRequired() {
        return FeaturesRequestSettings.getInstance().isCommenterEmailFieldRequired() && AddCommentPresenter.isUserIdentificationStateEnabled();
    }

    @Nullable
    public String getEnteredEmail() {
        return this.enteredEmail != null ? this.enteredEmail : InstabugCore.getEnteredEmail();
    }

    @Nullable
    public String getEnteredUsername() {
        return InstabugCore.getEnteredUsername();
    }

    public void handelRequiredFieldsHints() {
        AddCommentContract$View addCommentContract$View = ((AddCommentPresenter)((Object)addCommentContract$View)).viewInstance;
        if (addCommentContract$View != null) {
            addCommentContract$View.setEmailHintStringWithAsterisk(FeaturesRequestSettings.getInstance().isCommenterEmailFieldRequired());
        }
    }
}

