package com.instabug.featuresrequest.ui.featuresmain.mainmyfeatures;

import android.os.Bundle;

import com.instabug.featuresrequest.ui.base.FeaturesListBo;
import com.instabug.featuresrequest.ui.base.featureslist.FeaturesListFragment;
import com.instabug.featuresrequest.ui.base.featureslist.FeaturesListPresenter;

import androidx.annotation.NonNull;

/**
 * @author hossam.
 */

public class MainMyFeaturesFragment extends FeaturesListFragment {

    public static MainMyFeaturesFragment newInstance(boolean sortByTopVoted) {
        Bundle args = new Bundle();
        args.putBoolean(KEY_SORT_BY_TOP_VOTED, sortByTopVoted);
        args.putBoolean(KEY_MY_POSTS, true);
        MainMyFeaturesFragment fragment = new MainMyFeaturesFragment();
        fragment.setArguments(args);
        return fragment;
    }

    @NonNull
    @Override
    public FeaturesListPresenter getPresenter() {
        return new MainMyFeaturesPresenter(this,
                new FeaturesListBo(MainMyFeaturesDao.getInstance()));
    }

}
