package com.instabug.featuresrequest.models;

import android.annotation.SuppressLint;

import com.instabug.library.internal.storage.cache.Cacheable;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;

/**
 * Created by mzelzoghbi on 3/5/18.
 */
// no place for error here
@SuppressLint("ERADICATE_FIELD_NOT_INITIALIZED")
public class TimelineResponse implements Cacheable, Serializable {
    private static final String KEY_ID = "featureId";
    private static final String KEY_COMMENTS = "timeline";

    private long featureId;
    private ArrayList<TimelineObject> timelineObjects;

    public static TimelineResponse fromJson(JSONObject response) throws JSONException {
        TimelineResponse timeline = new TimelineResponse();
        timeline.fromJson(response.toString());
        return timeline;
    }

    public ArrayList<TimelineObject> getTimelineObjects() {
        return timelineObjects;
    }

    public void setTimelineObjects(ArrayList<TimelineObject> timelineObjects) {
        this.timelineObjects = timelineObjects;
    }

    public long getFeatureId() {
        return featureId;
    }

    public void setFeatureId(long featureId) {
        this.featureId = featureId;
    }

    @Override
    public String toJson() throws JSONException {
        return new JSONObject()
                .put(KEY_ID, getFeatureId())
                .put(KEY_COMMENTS, TimelineObject.toJson(getTimelineObjects()))
                .toString();
    }

    @Override
    public void fromJson(String modelAsJson) throws JSONException {
        JSONObject featureCommentsJsonObject = new JSONObject(modelAsJson);
        if (featureCommentsJsonObject.has(KEY_ID)) {
            setFeatureId(featureCommentsJsonObject.getLong(KEY_ID));
        }

        if (featureCommentsJsonObject.has(KEY_COMMENTS)) {
            setTimelineObjects(TimelineObject.fromJson(featureCommentsJsonObject.getJSONArray(KEY_COMMENTS)));
        }

    }
}
