package com.instabug.featuresrequest.models;

import com.instabug.library.internal.storage.cache.Cacheable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;

/**
 * Created by mzelzoghbi on 3/6/18.
 */

public abstract class TimelineObject implements Cacheable, Serializable {
    public static final String KEY_TYPE = "type";
    public static final String KEY_CREATED_AT = "created_at";

    private Type type = Type.COMMENT;
    protected long createdAt;

    public long getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public Type getType() {
        return type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public static JSONArray toJson(ArrayList<TimelineObject> timelineObjects) throws JSONException {
        JSONArray timelineJsonArray = new JSONArray();
        for (int i = 0; i < timelineObjects.size(); i++) {
            if (timelineObjects.get(i) instanceof Comment) {
                timelineJsonArray.put(new JSONObject(((Comment) timelineObjects.get(i)).toJson()));
            } else {
                timelineJsonArray.put(new JSONObject(((StatusChange) timelineObjects.get(i)).toJson()));
            }
        }
        return timelineJsonArray;
    }

    public static ArrayList<TimelineObject> fromJson(JSONArray timelineJsonArray) throws JSONException {
        ArrayList<TimelineObject> timelineObjects = new ArrayList<>();
        for (int i = 0; i < timelineJsonArray.length(); i++) {
            if (timelineJsonArray.getJSONObject(i).has(KEY_TYPE)) {
                if (timelineJsonArray.getJSONObject(i).getString(KEY_TYPE).equals("comment")) {
                    Comment comment = new Comment();
                    comment.fromJson(timelineJsonArray.getJSONObject(i).toString());
                    timelineObjects.add(comment);
                } else {
                    StatusChange statusChange = new StatusChange();
                    statusChange.fromJson(timelineJsonArray.getJSONObject(i).toString());
                    timelineObjects.add(statusChange);
                }
            }

        }
        return timelineObjects;
    }

    public enum Type {
        COMMENT("comment"), STATUS_CHANE("state_change");

        private final String type;

        Type(String type) {
            this.type = type;
        }

        @Override
        public String toString() {
            return type;
        }

    }
}
