package com.instabug.featuresrequest.models;

import android.annotation.SuppressLint;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by mzelzoghbi on 3/11/18.
 */

public class NewComment extends Comment {
    public static final String KEY_FEATURE_ID = "feature_id";
    public static final String KEY_EMAIL = "email";

    @SuppressLint("ERADICATE_FIELD_NOT_INITIALIZED")
    private String commenterEmail;
    private long featureId;

    public NewComment(long featureId, String body, String name, String email) {
        setFeatureId(featureId);
        setCreatedAt(System.currentTimeMillis() / 1000);
        setCommenterName(name);
        setCommenterEmail(email);
        setBody(body);
    }

    public long getFeatureId() {
        return featureId;
    }

    public void setFeatureId(long featureId) {
        this.featureId = featureId;
    }

    public String getCommenterEmail() {
        return commenterEmail;
    }

    public void setCommenterEmail(String commenterEmail) {
        this.commenterEmail = commenterEmail;
    }

    @Override
    public String toJson() throws JSONException {
        JSONObject jsonObject = new JSONObject(super.toJson());
        jsonObject.put(KEY_FEATURE_ID, getFeatureId());
        jsonObject.put(KEY_EMAIL, getCommenterEmail());
        return jsonObject.toString();
    }

    @Override
    public void fromJson(String modelAsJson) throws JSONException {
        super.fromJson(modelAsJson);

        JSONObject newCommentJsonObject = new JSONObject(modelAsJson);

        if (newCommentJsonObject.has(KEY_EMAIL)) {
            setCommenterEmail(newCommentJsonObject.getString(KEY_EMAIL));
        }
        if (newCommentJsonObject.has(KEY_FEATURE_ID)) {
            setFeatureId(newCommentJsonObject.getLong(KEY_FEATURE_ID));
        }

    }
}
