package com.instabug.featuresrequest;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import androidx.annotation.IntDef;

/**
 * Actions Used for setting email required in add-feature-requests, add-comment-on-feature
 * Created by mzelzoghbi on 5/20/18.
 */
@IntDef(flag = true,
        value = {
                ActionType.REQUEST_NEW_FEATURE,
                ActionType.ADD_COMMENT_TO_FEATURE})
@Retention(RetentionPolicy.SOURCE)
public @interface ActionType {

    int REQUEST_NEW_FEATURE = 1 << 1;
    int ADD_COMMENT_TO_FEATURE = 1 << 2;
}

