/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.crash;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.Nullable;
import com.instabug.crash.a.a;
import com.instabug.crash.b.b;
import com.instabug.crash.models.Crash;
import com.instabug.crash.network.InstabugCrashesUploaderService;
import com.instabug.library.APIBuildChecker;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.AutoScreenRecordingEventBus;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.internal.storage.operation.DiskOperation;
import com.instabug.library.internal.storage.operation.WriteStateToFileDiskOperation;
import com.instabug.library.internal.video.AutoScreenRecordingService;
import com.instabug.library.model.Report;
import com.instabug.library.model.State;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.ReportHelper;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class CrashReporting {
    public static void reportException(Throwable throwable) {
        APIBuildChecker.check();
        if (InstabugCore.getFeatureState((Feature)Feature.CRASH_REPORTING) == Feature.State.DISABLED) {
            return;
        }
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("error", (Object)com.instabug.crash.d.b.a(throwable, null));
            CrashReporting.reportException(jSONObject, true);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    public static void reportException(Throwable throwable, @Nullable String string) {
        APIBuildChecker.check();
        if (InstabugCore.getFeatureState((Feature)Feature.CRASH_REPORTING) == Feature.State.DISABLED) {
            return;
        }
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("error", (Object)com.instabug.crash.d.b.a(throwable, string));
            CrashReporting.reportException(jSONObject, true);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    private static void reportUncaughtException(JSONObject jSONObject) {
        CrashReporting.reportException(jSONObject, false);
    }

    private static void reportException(JSONObject jSONObject, boolean bl) {
        if (InstabugCore.getFeatureState((Feature)Feature.CRASH_REPORTING) == Feature.State.DISABLED) {
            return;
        }
        Context context = Instabug.getApplicationContext();
        if (SettingsManager.getInstance().getPreReportRunnable() != null) {
            try {
                SettingsManager.getInstance().getPreReportRunnable().run();
            }
            catch (Exception exception) {
                InstabugSDKLogger.e(CrashReporting.class, (String)"Pre sending runnable failed to run.", (Throwable)exception);
            }
        }
        SettingsManager settingsManager = SettingsManager.getInstance();
        Report report = new Report();
        if (settingsManager.getOnReportCreatedListener() != null) {
            settingsManager.getOnReportCreatedListener().onReportCreated(report);
        }
        Crash crash = new Crash.a().a(context);
        crash.c(jSONObject.toString());
        crash.a(Crash.CrashState.READY_TO_BE_SENT);
        crash.a(bl);
        ReportHelper.update((State)crash.e(), (Report)report);
        if (InstabugCore.getExtraAttachmentFiles().size() >= 1) {
            for (Map.Entry entry : InstabugCore.getExtraAttachmentFiles().entrySet()) {
                Uri uri = AttachmentsUtility.getNewFileAttachmentUri((Context)context, (Uri)((Uri)entry.getKey()), (String)((String)entry.getValue()));
                crash.a(uri);
            }
        }
        if (b.a().isEnabled()) {
            AutoScreenRecordingEventBus.getInstance().post((Object)AutoScreenRecordingService.Action.STOP_KEEP);
            com.instabug.crash.b.a.a(crash);
        }
        try {
            File file = DiskUtils.createStateTextFile((Context)context);
            Uri uri = DiskUtils.with((Context)context).writeOperation((DiskOperation)new WriteStateToFileDiskOperation(file, crash.e().toJson())).execute();
            crash.e().setUri(uri);
            a.a(crash);
        }
        catch (JSONException jSONException) {
            InstabugSDKLogger.e(CrashReporting.class, (String)jSONException.toString());
        }
        catch (IOException iOException) {
            InstabugSDKLogger.e(CrashReporting.class, (String)iOException.toString());
        }
        InstabugSDKLogger.i(CrashReporting.class, (String)"ReportCaughtException: Your exception has been reported");
        if (context != null) {
            InstabugCrashesUploaderService.a(context, new Intent(context, InstabugCrashesUploaderService.class));
        }
        b.a().b();
    }
}

